/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.lang.Nullable;

public class SetOperation
implements FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private Map<Object, Object> valueMap;
    private ExposedFields exposedFields = ExposedFields.empty();

    private SetOperation(Map<Object, Object> source) {
        this.valueMap = new LinkedHashMap<Object, Object>(source);
        for (Object key : source.keySet()) {
            this.exposedFields = this.add(key);
        }
    }

    public SetOperation(Object field, @Nullable Object value) {
        this(Collections.singletonMap(field, value));
    }

    public static FieldAppender builder() {
        return new FieldAppender();
    }

    public static FieldAppender.ValueAppender set(String field) {
        return new FieldAppender().set(field);
    }

    public SetOperation set(Object field, Object value) {
        LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(this.valueMap);
        target.put(field, value);
        return new SetOperation(target);
    }

    public FieldAppender and() {
        return new FieldAppender(this.valueMap);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(this.exposedFields, context);
        if (this.valueMap.size() == 1) {
            return context.getMappedObject(new Document("$set", (Object)SetOperation.toSetEntry(this.valueMap.entrySet().iterator().next(), operationContext)));
        }
        Document $set = new Document();
        this.valueMap.entrySet().stream().map(it -> SetOperation.toSetEntry(it, operationContext)).forEach(arg_0 -> ((Document)$set).putAll(arg_0));
        return context.getMappedObject(new Document("$set", (Object)$set));
    }

    @Override
    public ExposedFields getFields() {
        return this.exposedFields;
    }

    private ExposedFields add(Object field) {
        if (field instanceof Field) {
            return this.exposedFields.and(new ExposedFields.ExposedField((Field)field, true));
        }
        if (field instanceof String) {
            return this.exposedFields.and(new ExposedFields.ExposedField(Fields.field((String)field), true));
        }
        throw new IllegalArgumentException(String.format("Expected %s to be a field/property.", field));
    }

    private static Document toSetEntry(Map.Entry<Object, Object> entry, AggregationOperationContext context) {
        String field = entry.getKey() instanceof String ? context.getReference((String)entry.getKey()).getRaw() : context.getReference((Field)entry.getKey()).getRaw();
        Object value = SetOperation.computeValue(entry.getValue(), context);
        return new Document(field, value);
    }

    private static Object computeValue(Object value, AggregationOperationContext context) {
        if (value instanceof Field) {
            return context.getReference((Field)value).toString();
        }
        if (value instanceof AggregationExpression) {
            return ((AggregationExpression)value).toDocument(context);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(it -> SetOperation.computeValue(it, context)).collect(Collectors.toList());
        }
        return value;
    }

    public static class FieldAppender {
        private final Map<Object, Object> valueMap;

        private FieldAppender() {
            this.valueMap = new LinkedHashMap<Object, Object>();
        }

        private FieldAppender(Map<Object, Object> source) {
            this.valueMap = new LinkedHashMap<Object, Object>(source);
        }

        public ValueAppender set(final String field) {
            return new ValueAppender(){

                @Override
                public SetOperation toValue(Object value) {
                    valueMap.put(field, value);
                    return this.build();
                }

                @Override
                public SetOperation toValueOf(Object value) {
                    valueMap.put(field, value instanceof String ? Fields.fields((String)value) : value);
                    return this.build();
                }
            };
        }

        private SetOperation build() {
            return new SetOperation(this.valueMap);
        }

        public static interface ValueAppender {
            public SetOperation toValue(@Nullable Object var1);

            public SetOperation toValueOf(Object var1);
        }
    }
}

