/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveGridFsResource {
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final String filename;
    @Nullable
    private final GridFSDownloadPublisher downloadPublisher;
    private final DataBufferFactory dataBufferFactory;

    public ReactiveGridFsResource(String filename, @Nullable GridFSDownloadPublisher downloadPublisher) {
        this(filename, downloadPublisher, (DataBufferFactory)new DefaultDataBufferFactory());
    }

    ReactiveGridFsResource(String filename, @Nullable GridFSDownloadPublisher downloadPublisher, DataBufferFactory dataBufferFactory) {
        this.filename = filename;
        this.downloadPublisher = downloadPublisher;
        this.dataBufferFactory = dataBufferFactory;
    }

    public static ReactiveGridFsResource absent(String filename) {
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        return new ReactiveGridFsResource(filename, null);
    }

    public String getFilename() throws IllegalStateException {
        return this.filename;
    }

    public Mono<GridFSFile> getGridFSFile() {
        return this.downloadPublisher != null ? Mono.from((Publisher)this.downloadPublisher.getGridFSFile()) : Mono.empty();
    }

    public Mono<InputStream> getInputStream() throws IllegalStateException {
        return ((Mono)this.getDownloadStream().transform(DataBufferUtils::join).as(Mono::from)).map(DataBuffer::asInputStream);
    }

    public Flux<DataBuffer> getDownloadStream() {
        if (this.downloadPublisher == null) {
            return Flux.empty();
        }
        return this.createDownloadStream(this.downloadPublisher);
    }

    public Flux<DataBuffer> getDownloadStream(int chunkSize) {
        if (this.downloadPublisher == null) {
            return Flux.empty();
        }
        return this.createDownloadStream(this.downloadPublisher.bufferSizeBytes(chunkSize));
    }

    private Flux<DataBuffer> createDownloadStream(GridFSDownloadPublisher publisher) {
        return Flux.from((Publisher)publisher).map(arg_0 -> ((DataBufferFactory)this.dataBufferFactory).wrap(arg_0)).doOnSubscribe(it -> this.verifyStreamStillAvailable());
    }

    public boolean exists() {
        return this.downloadPublisher != null;
    }

    private void verifyStreamStillAvailable() {
        if (!this.consumed.compareAndSet(false, true)) {
            throw new IllegalStateException("Stream already consumed.");
        }
    }
}

