/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.rest.core.Handler;
import org.springframework.data.rest.core.convert.DelegatingConversionService;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.data.rest.repository.RepositoryConstraintViolationException;
import org.springframework.data.rest.repository.RepositoryExporter;
import org.springframework.data.rest.repository.RepositoryExporterSupport;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.repository.RepositoryNotFoundException;
import org.springframework.data.rest.repository.UriToDomainObjectUriResolver;
import org.springframework.data.rest.repository.annotation.RestResource;
import org.springframework.data.rest.repository.context.AfterDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkSaveEvent;
import org.springframework.data.rest.repository.context.AfterSaveEvent;
import org.springframework.data.rest.repository.context.BeforeDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkSaveEvent;
import org.springframework.data.rest.repository.context.BeforeSaveEvent;
import org.springframework.data.rest.repository.context.RepositoryEvent;
import org.springframework.data.rest.repository.invoke.CrudMethod;
import org.springframework.data.rest.repository.invoke.MethodParameterConversionService;
import org.springframework.data.rest.repository.invoke.RepositoryQueryMethod;
import org.springframework.data.rest.webmvc.EntityToResourceConverter;
import org.springframework.data.rest.webmvc.MediaTypes;
import org.springframework.data.rest.webmvc.PagingAndSorting;
import org.springframework.data.rest.webmvc.RepositoryAwareMappingHttpMessageConverter;
import org.springframework.data.rest.webmvc.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.UriListHttpMessageConverter;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryRestController
extends RepositoryExporterSupport<RepositoryRestController>
implements ApplicationContextAware,
InitializingBean {
    public static final String LOCATION = "Location";
    public static final String SELF = "self";
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRestController.class);
    private static final TypeDescriptor STRING_ARRAY_TYPE = TypeDescriptor.valueOf(String[].class);
    private DelegatingConversionService conversionService = new DelegatingConversionService(new ConversionService[]{new DefaultFormattingConversionService()});
    private MethodParameterConversionService methodParameterConversionService = new MethodParameterConversionService((ConversionService)this.conversionService);
    private List<HttpMessageConverter> httpMessageConverters = new ArrayList<HttpMessageConverter>();
    private SortedSet<String> availableMediaTypes = new TreeSet<String>();
    private RepositoryRestConfiguration config = RepositoryRestConfiguration.DEFAULT;
    private ObjectMapper objectMapper = new ObjectMapper();
    private RepositoryAwareMappingHttpMessageConverter mappingHttpMessageConverter;
    private UriToDomainObjectUriResolver domainObjectResolver;
    private ApplicationContext applicationContext;

    public RepositoryRestController() {
        ArrayList<HttpMessageConverter> httpMessageConverters = new ArrayList<HttpMessageConverter>();
        httpMessageConverters.add((HttpMessageConverter)new UriListHttpMessageConverter());
        this.setHttpMessageConverters(httpMessageConverters);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Autowired(required=false)
    public void setConversionServices(List<ConversionService> conversionServices) {
        if (null == conversionServices) {
            return;
        }
        Collections.reverse(conversionServices);
        if (null != this.conversionService) {
            this.conversionService.addConversionServices(conversionServices.toArray(new ConversionService[conversionServices.size()]));
        }
    }

    public ConversionService conversionService() {
        return this.conversionService;
    }

    public RepositoryRestController conversionServices(List<ConversionService> conversionServices) {
        this.setConversionServices(conversionServices);
        return this;
    }

    public List<HttpMessageConverter> getHttpMessageConverters() {
        return this.httpMessageConverters;
    }

    public void setHttpMessageConverters(List<HttpMessageConverter> httpMessageConverters) {
        Assert.notNull(httpMessageConverters);
        this.httpMessageConverters = httpMessageConverters;
        this.availableMediaTypes.clear();
        for (HttpMessageConverter httpMessageConverter : httpMessageConverters) {
            for (MediaType mt : httpMessageConverter.getSupportedMediaTypes()) {
                this.availableMediaTypes.add(mt.toString());
            }
        }
        for (HttpMessageConverter httpMessageConverter : this.config.getCustomConverters()) {
            for (MediaType mt : httpMessageConverter.getSupportedMediaTypes()) {
                this.availableMediaTypes.add(mt.toString());
            }
        }
    }

    public List<HttpMessageConverter> httpMessageConverters() {
        return this.httpMessageConverters;
    }

    public RepositoryRestController httpMessageConverters(List<HttpMessageConverter> httpMessageConverters) {
        this.setHttpMessageConverters(httpMessageConverters);
        return this;
    }

    public RepositoryRestConfiguration getRepositoryRestConfig() {
        return this.config;
    }

    @Autowired(required=false)
    public RepositoryRestController setRepositoryRestConfig(RepositoryRestConfiguration config) {
        this.config = config;
        return this;
    }

    public RepositoryAwareMappingHttpMessageConverter getMappingHttpMessageConverter() {
        return this.mappingHttpMessageConverter;
    }

    @Autowired
    public RepositoryRestController setMappingHttpMessageConverter(RepositoryAwareMappingHttpMessageConverter mappingHttpMessageConverter) {
        this.mappingHttpMessageConverter = mappingHttpMessageConverter;
        this.httpMessageConverters.add((HttpMessageConverter)mappingHttpMessageConverter);
        this.objectMapper = mappingHttpMessageConverter.getObjectMapper();
        return this;
    }

    public UriToDomainObjectUriResolver getDomainObjectResolver() {
        return this.domainObjectResolver;
    }

    @Autowired
    public RepositoryRestController setDomainObjectResolver(UriToDomainObjectUriResolver domainObjectResolver) {
        this.domainObjectResolver = domainObjectResolver;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        for (ConversionService cs : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ConversionService.class).values()) {
            this.conversionService.addConversionServices(new ConversionService[]{cs});
        }
        GenericConversionService entityConverters = new GenericConversionService();
        for (RepositoryExporter exp : this.repositoryExporters()) {
            for (String repoName : exp.repositoryNames()) {
                RepositoryMetadata repoMeta = exp.repositoryMetadataFor(repoName);
                Class domainType = repoMeta.domainType();
                entityConverters.addConverter(domainType, Resource.class, (Converter)new EntityToResourceConverter(this.config, repoMeta));
            }
        }
        this.conversionService.addConversionServices(new ConversionService[]{entityConverters});
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> listRepositories(ServletServerHttpRequest request, URI baseUri) throws IOException {
        ArrayList<Link> links = new ArrayList<Link>();
        for (RepositoryExporter repoExporter : this.repositoryExporters) {
            for (String name : repoExporter.repositoryNames()) {
                RepositoryMetadata repoMeta = repoExporter.repositoryMetadataFor(name);
                String rel = repoMeta.rel();
                URI path = UriUtils.buildUri((URI)baseUri, (String[])new String[]{name});
                links.add(new Link(path.toString(), rel));
            }
        }
        return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), new Resources(Collections.emptyList(), links));
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> listEntities(ServletServerHttpRequest request, PagingAndSorting pageSort, URI baseUri, @PathVariable String repository) throws IOException {
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.FIND_ALL).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        ArrayList<Link> links = new ArrayList<Link>();
        PagedResources.PageMetadata pageMeta = null;
        Iterator allEntities = Collections.emptyList().iterator();
        if (repoMeta.repository() instanceof PagingAndSortingRepository) {
            Page page = ((PagingAndSortingRepository)repoMeta.repository()).findAll((Pageable)pageSort);
            if (page.hasContent()) {
                allEntities = page.iterator();
            }
            pageMeta = new PagedResources.PageMetadata((long)page.getSize(), (long)(page.getNumber() + 1), page.getTotalElements(), (long)page.getTotalPages());
            UriComponentsBuilder selfUri = UriComponentsBuilder.fromUri((URI)baseUri).pathSegment(new String[]{repository});
            for (String name : request.getServletRequest().getParameterMap().keySet()) {
                if (!this.notPagingParam(name)) continue;
                selfUri.queryParam(name, new Object[]{request.getServletRequest().getParameter(name)});
            }
            URI nextPrevBase = selfUri.build().toUri();
            this.maybeAddPrevNextLink(nextPrevBase, repoMeta, pageSort, page, !page.isFirstPage() && page.hasPreviousPage(), page.getNumber(), "prev", links);
            this.maybeAddPrevNextLink(nextPrevBase, repoMeta, pageSort, page, !page.isLastPage() && page.hasNextPage(), page.getNumber() + 2, "next", links);
        } else {
            Iterable it = repoMeta.repository().findAll();
            if (null != it) {
                allEntities = it.iterator();
            }
        }
        ArrayList allResources = new ArrayList();
        while (allEntities.hasNext()) {
            Object o = allEntities.next();
            if (this.shouldReturnLinks(request.getServletRequest().getHeader("Accept"))) {
                Serializable id = (Serializable)repoMeta.entityMetadata().idAttribute().get(o);
                URI selfUri = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id.toString()});
                links.add(new Link(selfUri.toString(), repoMeta.rel() + "." + o.getClass().getSimpleName()));
                continue;
            }
            allResources.add(o);
        }
        if (!repoMeta.queryMethods().isEmpty()) {
            links.add(new Link(UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, "search"}).toString(), repoMeta.rel() + ".search"));
        }
        return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), null != pageMeta ? new PagedResources(allResources, pageMeta, links) : new Resources(allResources, links));
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> listQueryMethods(ServletServerHttpRequest request, URI baseUri, @PathVariable String repository) throws IOException {
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        HashSet<Link> links = new HashSet<Link>();
        for (Map.Entry entry : repoMeta.queryMethods().entrySet()) {
            URI baseSearchUri = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, "search"});
            Method m = ((RepositoryQueryMethod)entry.getValue()).method();
            if (m.isAnnotationPresent(RestResource.class)) {
                RestResource resourceAnno = m.getAnnotation(RestResource.class);
                links.add(new Link(UriUtils.buildUri((URI)baseSearchUri, (String[])new String[]{StringUtils.hasText((String)resourceAnno.path()) ? resourceAnno.path() : (String)entry.getKey()}).toString(), StringUtils.hasText((String)resourceAnno.rel()) ? repoMeta.rel() + "." + resourceAnno.rel() : repoMeta.rel() + "." + (String)entry.getKey()));
                continue;
            }
            links.add(new Link(UriUtils.buildUri((URI)baseSearchUri, (String[])new String[]{(String)entry.getKey()}).toString(), repoMeta.rel() + "." + (String)entry.getKey()));
        }
        return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), new Resources(Collections.emptyList(), links));
    }

    @RequestMapping(value={"/{repository}/search/{query}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> query(ServletServerHttpRequest request, PagingAndSorting pageSort, URI baseUri, @PathVariable String repository, @PathVariable String query) throws InvocationTargetException, IllegalAccessException, IOException {
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        CrudRepository repo = repoMeta.repository();
        RepositoryQueryMethod queryMethod = repoMeta.queryMethod(query);
        if (null == queryMethod) {
            return this.notFoundResponse(request);
        }
        Class[] paramTypes = queryMethod.paramTypes();
        String[] paramNames = queryMethod.paramNames();
        Object[] paramVals = new Object[paramTypes.length];
        for (int i = 0; i < paramVals.length; ++i) {
            String firstVal;
            if (Pageable.class.isAssignableFrom(paramTypes[i])) {
                paramVals[i] = pageSort;
                continue;
            }
            if (Sort.class.isAssignableFrom(paramTypes[i])) {
                paramVals[i] = null != pageSort ? pageSort.getSort() : null;
                continue;
            }
            String[] queryVals = request.getServletRequest().getParameterValues(paramNames[i]);
            if (null == queryVals) continue;
            MethodParameter methodParam = new MethodParameter(queryMethod.method(), i);
            String string = firstVal = queryVals.length > 0 ? queryVals[0] : null;
            if (this.hasRepositoryMetadataFor(paramTypes[i])) {
                RepositoryMetadata paramRepoMeta = this.repositoryMetadataFor(paramTypes[i]);
                Object id = this.stringToSerializable(firstVal, paramRepoMeta.entityMetadata().idAttribute().type());
                Object o = paramRepoMeta.repository().findOne(id);
                if (null == o) {
                    return this.notFoundResponse(request);
                }
                paramVals[i] = o;
                continue;
            }
            if (String.class.isAssignableFrom(paramTypes[i])) {
                paramVals[i] = firstVal;
                continue;
            }
            if (this.methodParameterConversionService.canConvert(STRING_ARRAY_TYPE, methodParam)) {
                paramVals[i] = this.methodParameterConversionService.convert((Object)queryVals, STRING_ARRAY_TYPE, methodParam);
                continue;
            }
            try {
                paramVals[i] = this.objectMapper.readValue(firstVal, paramTypes[i]);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Object result = queryMethod.method().invoke((Object)repo, paramVals);
        if (null == result) {
            return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), new Resources(Collections.emptyList(), new Link[0]));
        }
        ArrayList<Link> links = new ArrayList<Link>();
        PagedResources.PageMetadata pageMetadata = null;
        Iterator<Object> entities = Collections.emptyList().iterator();
        if (result instanceof Collection) {
            entities = ((Collection)result).iterator();
        } else if (result instanceof Page) {
            Page page = (Page)result;
            if (page.hasContent()) {
                entities = page.iterator();
            }
            pageMetadata = new PagedResources.PageMetadata((long)page.getSize(), (long)(page.getNumber() + 1), page.getTotalElements(), (long)page.getTotalPages());
            UriComponentsBuilder selfUri = UriComponentsBuilder.fromUri((URI)baseUri).pathSegment(new String[]{repository, "search", query});
            for (String name : request.getServletRequest().getParameterMap().keySet()) {
                if (!this.notPagingParam(name)) continue;
                selfUri.queryParam(name, new Object[]{request.getServletRequest().getParameter(name)});
            }
            URI nextPrevBase = selfUri.build().toUri();
            this.maybeAddPrevNextLink(nextPrevBase, repoMeta, pageSort, page, !page.isFirstPage() && page.hasPreviousPage(), page.getNumber(), "prev", links);
            this.maybeAddPrevNextLink(nextPrevBase, repoMeta, pageSort, page, !page.isLastPage() && page.hasNextPage(), page.getNumber() + 2, "next", links);
        } else {
            entities = Collections.singletonList(result).iterator();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        while (entities.hasNext()) {
            Object obj = entities.next();
            if (this.shouldReturnLinks(request.getServletRequest().getHeader("Accept"))) {
                if (!this.hasRepositoryMetadataFor(obj.getClass())) {
                    results.add(obj);
                    continue;
                }
                RepositoryMetadata elemRepoMeta = this.repositoryMetadataFor(obj.getClass());
                String id = elemRepoMeta.entityMetadata().idAttribute().get(obj).toString();
                String rel = elemRepoMeta.rel() + "." + elemRepoMeta.entityMetadata().type().getSimpleName();
                URI path = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id});
                links.add(new Link(path.toString(), rel));
                continue;
            }
            results.add(obj);
        }
        return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), null != pageMetadata ? new PagedResources(results, pageMetadata, links) : new Resources(results, links));
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> create(ServletServerHttpRequest request, URI baseUri, @PathVariable String repository) throws IOException {
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.SAVE_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        CrudRepository repo = repoMeta.repository();
        MediaType incomingMediaType = request.getHeaders().getContentType();
        Object incoming = this.readIncoming((HttpInputMessage)request, incomingMediaType, repoMeta.entityMetadata().type());
        if (null == incoming) {
            throw new HttpMessageNotReadableException("Could not create an instance of " + repoMeta.entityMetadata().type().getSimpleName() + " from input.");
        }
        this.publishEvent(new BeforeSaveEvent(incoming));
        Object savedEntity = repo.save(incoming);
        this.publishEvent(new AfterSaveEvent(savedEntity));
        String sId = repoMeta.entityMetadata().idAttribute().get(savedEntity).toString();
        URI selfUri = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, sId});
        HttpHeaders headers = new HttpHeaders();
        headers.set(LOCATION, selfUri.toString());
        Resource body = null;
        if (this.returnBody(request)) {
            body = new Resource(savedEntity, new Link[0]);
        }
        return this.negotiateResponse(request, HttpStatus.CREATED, headers, body);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> entity(ServletServerHttpRequest request, URI baseUri, @PathVariable String repository, @PathVariable String id) throws IOException {
        Object version;
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.FIND_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type());
        CrudRepository repo = repoMeta.repository();
        Object entity = repo.findOne(serId);
        if (null == entity) {
            return this.notFoundResponse(request);
        }
        HttpHeaders headers = new HttpHeaders();
        if (null != repoMeta.entityMetadata().versionAttribute() && null != (version = repoMeta.entityMetadata().versionAttribute().get(entity))) {
            List etags = request.getHeaders().getIfNoneMatch();
            for (String etag : etags) {
                if (!("\"" + version.toString() + "\"").equals(etag)) continue;
                return this.negotiateResponse(request, HttpStatus.NOT_MODIFIED, new HttpHeaders(), null);
            }
            headers.set("ETag", "\"" + version.toString() + "\"");
        }
        return this.negotiateResponse(request, HttpStatus.OK, headers, entity);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> createOrUpdate(ServletServerHttpRequest request, URI baseUri, @PathVariable String repository, @PathVariable String id) throws IOException, IllegalAccessException, InstantiationException {
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.SAVE_ONE).booleanValue() || !repoMeta.exportsMethod(CrudMethod.FIND_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type());
        CrudRepository repo = repoMeta.repository();
        Class domainType = repoMeta.entityMetadata().type();
        MediaType incomingMediaType = request.getHeaders().getContentType();
        Object incoming = this.readIncoming((HttpInputMessage)request, incomingMediaType, domainType);
        if (null == incoming) {
            throw new HttpMessageNotReadableException("Could not create an instance of " + domainType.getSimpleName() + " from input.");
        }
        repoMeta.entityMetadata().idAttribute().set(serId, incoming);
        boolean isUpdate = false;
        Object entity = repo.findOne(serId);
        if (null != entity) {
            isUpdate = true;
            for (AttributeMetadata attrMeta : repoMeta.entityMetadata().embeddedAttributes().values()) {
                Object incomingVal = attrMeta.get(incoming);
                if (null == incomingVal) continue;
                attrMeta.set(incomingVal, entity);
            }
        } else {
            entity = incoming;
        }
        this.publishEvent(new BeforeSaveEvent(entity));
        Object savedEntity = repo.save(entity);
        this.publishEvent(new AfterSaveEvent(savedEntity));
        URI selfUri = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id});
        Object body = null;
        if (this.returnBody(request)) {
            body = savedEntity;
        }
        if (!isUpdate) {
            HttpHeaders headers = new HttpHeaders();
            headers.set(LOCATION, selfUri.toString());
            return this.negotiateResponse(request, HttpStatus.CREATED, headers, body);
        }
        return this.negotiateResponse(request, null != body ? HttpStatus.OK : HttpStatus.NO_CONTENT, new HttpHeaders(), body);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteEntity(ServletServerHttpRequest request, @PathVariable String repository, @PathVariable String id) throws IOException {
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.DELETE_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type());
        CrudRepository repo = repoMeta.repository();
        Object entity = repo.findOne(serId);
        if (null == entity) {
            return this.notFoundResponse(request);
        }
        this.publishEvent(new BeforeDeleteEvent(entity));
        repo.delete(serId);
        this.publishEvent(new AfterDeleteEvent(entity));
        return this.negotiateResponse(request, HttpStatus.NO_CONTENT, new HttpHeaders(), null);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> propertyOfEntity(ServletServerHttpRequest request, URI baseUri, @PathVariable String repository, @PathVariable String id, @PathVariable String property) throws IOException {
        RepositoryMetadata propRepoMeta;
        String accept = request.getServletRequest().getHeader("Accept");
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.FIND_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type());
        CrudRepository repo = repoMeta.repository();
        Object entity = repo.findOne(serId);
        if (null == entity) {
            return this.notFoundResponse(request);
        }
        AttributeMetadata attrMeta = repoMeta.entityMetadata().attribute(property);
        if (null == attrMeta) {
            return this.notFoundResponse(request);
        }
        Class attrType = attrMeta.elementType();
        if (null == attrType) {
            attrType = attrMeta.type();
        }
        if (!(propRepoMeta = this.repositoryMetadataFor(attrType)).exportsMethod(CrudMethod.FIND_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object propVal = attrMeta.get(entity);
        if (null == propVal) {
            return this.notFoundResponse(request);
        }
        HashSet<Link> links = new HashSet<Link>();
        AttributeMetadata idAttr = propRepoMeta.entityMetadata().idAttribute();
        String propertyRel = repository + "." + entity.getClass().getSimpleName() + "." + property;
        if (propVal instanceof Collection) {
            propertyRel = propertyRel + "." + propRepoMeta.entityMetadata().type().getSimpleName();
            ArrayList<Resource> outgoing = new ArrayList<Resource>();
            for (Object o : (Collection)propVal) {
                String propValId = idAttr.get(o).toString();
                URI path = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id, property, propValId});
                if (this.shouldReturnLinks(accept)) {
                    links.add(new Link(path.toString(), propertyRel));
                    continue;
                }
                Resource r = this.conversionService.canConvert(o.getClass(), Resource.class) ? (Resource)this.conversionService.convert(o, Resource.class) : new Resource(o, new Link[0]);
                r.add(new Link(path.toString(), propertyRel));
                outgoing.add(r);
            }
            return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), new Resources(outgoing, links));
        }
        if (propVal instanceof Map) {
            propertyRel = propertyRel + "." + propRepoMeta.entityMetadata().type().getSimpleName();
            HashMap<String, Object> resource = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)propVal).entrySet()) {
                if (null == entry.getValue()) continue;
                String propValId = idAttr.get(entry.getValue()).toString();
                URI path = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id, property, propValId});
                Object oKey = entry.getKey();
                String sKey = this.objectToMapKey(oKey);
                if (this.shouldReturnLinks(accept)) {
                    resource.put(sKey, new Link(path.toString(), propertyRel));
                    continue;
                }
                Resource r = this.conversionService.canConvert(entry.getValue().getClass(), Resource.class) ? (Resource)this.conversionService.convert(entry.getValue(), Resource.class) : new Resource(entry.getValue(), new Link[0]);
                r.add(new Link(path.toString(), propertyRel));
                resource.put(sKey, r);
            }
            return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), new Resource(resource, links));
        }
        URI path = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id, property});
        if (this.shouldReturnLinks(accept)) {
            links.add(new Link(path.toString(), propertyRel));
            return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), new Resources(Collections.emptyList(), links));
        }
        Resource r = this.conversionService.canConvert(propVal.getClass(), Resource.class) ? (Resource)this.conversionService.convert(propVal, Resource.class) : new Resource(propVal, new Link[0]);
        r.add(new Link(path.toString(), propertyRel));
        return this.negotiateResponse(request, HttpStatus.OK, new HttpHeaders(), r);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> updatePropertyOfEntity(final ServletServerHttpRequest request, URI baseUri, @PathVariable String repository, @PathVariable String id, @PathVariable String property) throws IOException {
        AttributeMetadata attrMeta;
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.SAVE_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type());
        CrudRepository repo = repoMeta.repository();
        final Object entity = repo.findOne(serId);
        if (null == entity || null == (attrMeta = repoMeta.entityMetadata().attribute(property))) {
            return this.notFoundResponse(request);
        }
        Object linked = attrMeta.get(entity);
        final AtomicReference<String> rel = new AtomicReference<String>();
        Handler entityHandler = new Handler<Object, ResponseEntity<?>>(){

            public ResponseEntity<?> handle(Object linkedEntity) {
                if (attrMeta.isCollectionLike()) {
                    ArrayList<Object> c = new ArrayList<Object>();
                    Collection current = attrMeta.asCollection(entity);
                    if (request.getMethod() == HttpMethod.POST && null != current) {
                        c.addAll(current);
                    }
                    c.add(linkedEntity);
                    attrMeta.set(c, entity);
                } else if (attrMeta.isSetLike()) {
                    HashSet<Object> s = new HashSet<Object>();
                    Set current = attrMeta.asSet(entity);
                    if (request.getMethod() == HttpMethod.POST && null != current) {
                        s.addAll(current);
                    }
                    s.add(linkedEntity);
                    attrMeta.set(s, entity);
                } else if (attrMeta.isMapLike()) {
                    String key;
                    HashMap m = new HashMap();
                    Map current = attrMeta.asMap(entity);
                    if (request.getMethod() == HttpMethod.POST && null != current) {
                        m.putAll(current);
                    }
                    if (null == (key = (String)rel.get())) {
                        throw new IllegalArgumentException("Map key cannot be null (usually the 'rel' value of a JSON object).");
                    }
                    m.put(rel.get(), linkedEntity);
                    attrMeta.set(m, entity);
                } else {
                    if (request.getMethod() == HttpMethod.POST) {
                        try {
                            return RepositoryRestController.this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e.getMessage(), e);
                        }
                    }
                    attrMeta.set(linkedEntity, entity);
                }
                return null;
            }
        };
        MediaType incomingMediaType = request.getHeaders().getContentType();
        Resource incomingLinks = this.readIncoming((HttpInputMessage)request, incomingMediaType, Resource.class);
        for (Link l : incomingLinks.getLinks()) {
            Object o = this.domainObjectResolver.resolve(baseUri, URI.create(l.getHref()));
            if (null != o) {
                rel.set(l.getRel());
                ResponseEntity possibleResponse = (ResponseEntity)entityHandler.handle(o);
                if (null != possibleResponse) {
                    return possibleResponse;
                }
            }
            this.publishEvent(new BeforeSaveEvent(entity));
            this.publishEvent(new BeforeLinkSaveEvent(entity, linked));
            Object savedEntity = repo.save(entity);
            linked = attrMeta.get(savedEntity);
            this.publishEvent(new AfterLinkSaveEvent(savedEntity, linked));
            this.publishEvent(new AfterSaveEvent(savedEntity));
        }
        if (request.getMethod() == HttpMethod.PUT) {
            return this.negotiateResponse(request, HttpStatus.NO_CONTENT, new HttpHeaders(), null);
        }
        return this.negotiateResponse(request, HttpStatus.CREATED, new HttpHeaders(), null);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> clearLinks(ServletServerHttpRequest request, @PathVariable String repository, @PathVariable String id, @PathVariable String property) throws IOException {
        AttributeMetadata attrMeta;
        Object serId;
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.SAVE_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        CrudRepository repo = repoMeta.repository();
        Object entity = repo.findOne(serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type()));
        if (null == entity || null == (attrMeta = repoMeta.entityMetadata().attribute(property))) {
            return this.notFoundResponse(request);
        }
        if (!attrMeta.isNullable()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object linked = attrMeta.get(entity);
        attrMeta.set(null, entity);
        this.publishEvent(new BeforeLinkSaveEvent(entity, linked));
        Object savedEntity = repo.save(entity);
        this.publishEvent(new AfterLinkSaveEvent(savedEntity, null));
        return this.negotiateResponse(request, HttpStatus.NO_CONTENT, new HttpHeaders(), null);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{linkedId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> linkedEntity(ServletServerHttpRequest request, URI baseUri, @PathVariable String repository, @PathVariable String id, @PathVariable String property, @PathVariable String linkedId) throws IOException {
        Object sChildId;
        Object serId;
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        if (!repoMeta.exportsMethod(CrudMethod.FIND_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        CrudRepository repo = repoMeta.repository();
        if (!repo.exists(serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type()))) {
            return this.notFoundResponse(request);
        }
        AttributeMetadata attrMeta = repoMeta.entityMetadata().attribute(property);
        if (null == attrMeta) {
            return this.notFoundResponse(request);
        }
        RepositoryMetadata linkedRepoMeta = this.repositoryMetadataFor(attrMeta);
        if (null == linkedRepoMeta) {
            return this.notFoundResponse(request);
        }
        if (!linkedRepoMeta.exportsMethod(CrudMethod.FIND_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        CrudRepository linkedRepo = linkedRepoMeta.repository();
        Object linkedEntity = linkedRepo.findOne(sChildId = this.stringToSerializable(linkedId, linkedRepoMeta.entityMetadata().idAttribute().type()));
        if (null == linkedEntity) {
            return this.notFoundResponse(request);
        }
        String propertyRel = repository + "." + repoMeta.entityMetadata().type().getSimpleName() + "." + property;
        URI propertyPath = UriUtils.buildUri((URI)baseUri, (String[])new String[]{repository, id, property, linkedId});
        URI selfUri = UriUtils.buildUri((URI)baseUri, (String[])new String[]{linkedRepoMeta.name(), linkedId});
        Resource r = this.conversionService.canConvert(linkedEntity.getClass(), Resource.class) ? (Resource)this.conversionService.convert(linkedEntity, Resource.class) : new Resource(linkedEntity, new Link[0]);
        r.add(new Link(propertyPath.toString(), propertyRel));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Location", selfUri.toString());
        return this.negotiateResponse(request, HttpStatus.OK, headers, r);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{linkedId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteLink(ServletServerHttpRequest request, @PathVariable String repository, @PathVariable String id, @PathVariable String property, @PathVariable String linkedId) throws IOException {
        Object sChildId;
        AttributeMetadata attrMeta;
        RepositoryMetadata repoMeta = this.repositoryMetadataFor(repository);
        CrudRepository repo = repoMeta.repository();
        if (!repoMeta.exportsMethod(CrudMethod.FIND_ONE).booleanValue() || !repoMeta.exportsMethod(CrudMethod.SAVE_ONE).booleanValue()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        Object serId = this.stringToSerializable(id, repoMeta.entityMetadata().idAttribute().type());
        Object entity = repo.findOne(serId);
        if (null == entity || null == (attrMeta = repoMeta.entityMetadata().attribute(property))) {
            return this.notFoundResponse(request);
        }
        if (!attrMeta.isNullable()) {
            return this.negotiateResponse(request, HttpStatus.METHOD_NOT_ALLOWED, new HttpHeaders(), null);
        }
        RepositoryMetadata linkedRepoMeta = this.repositoryMetadataFor(attrMeta);
        if (null == linkedRepoMeta) {
            return this.notFoundResponse(request);
        }
        CrudRepository linkedRepo = linkedRepoMeta.repository();
        Object linkedEntity = linkedRepo.findOne(sChildId = this.stringToSerializable(linkedId, linkedRepoMeta.entityMetadata().idAttribute().type()));
        if (null == linkedEntity) {
            return this.notFoundResponse(request);
        }
        if (attrMeta.isCollectionLike()) {
            Collection c = attrMeta.asCollection(entity);
            if (null != c && c != Collections.emptyList()) {
                c.remove(linkedEntity);
            }
        } else if (attrMeta.isSetLike()) {
            Set s = attrMeta.asSet(entity);
            if (null != s && s != Collections.emptySet()) {
                s.remove(linkedEntity);
            }
        } else if (attrMeta.isMapLike()) {
            Object keyToRemove = null;
            Map m = attrMeta.asMap(entity);
            if (null != m && m != Collections.emptyMap()) {
                for (Map.Entry entry : m.entrySet()) {
                    Object val = entry.getValue();
                    if (null == val || !val.equals(linkedEntity)) continue;
                    keyToRemove = entry.getKey();
                    break;
                }
                if (null != keyToRemove) {
                    m.remove(keyToRemove);
                }
            }
        } else {
            attrMeta.set(null, entity);
        }
        this.publishEvent(new BeforeLinkDeleteEvent(entity, linkedEntity));
        Object savedEntity = repo.save(entity);
        this.publishEvent(new AfterLinkDeleteEvent(savedEntity, linkedEntity));
        return this.negotiateResponse(request, HttpStatus.NO_CONTENT, new HttpHeaders(), null);
    }

    @ExceptionHandler(value={RepositoryNotFoundException.class})
    @ResponseBody
    public ResponseEntity handleRepositoryNotFoundFailure(RepositoryNotFoundException e, ServletServerHttpRequest request) throws IOException {
        if (LOG.isWarnEnabled()) {
            LOG.warn("RepositoryNotFoundException: " + e.getMessage());
        }
        return this.notFoundResponse(request);
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public ResponseEntity handleNPE(NullPointerException e, ServletServerHttpRequest request) throws IOException {
        LOG.error(e.getMessage(), (Throwable)e);
        return this.errorResponse(request, HttpStatus.INTERNAL_SERVER_ERROR, e);
    }

    @ExceptionHandler(value={InvocationTargetException.class, IllegalArgumentException.class, ClassCastException.class, ConversionFailedException.class})
    @ResponseBody
    public ResponseEntity handleMiscFailures(Throwable t, ServletServerHttpRequest request) throws IOException {
        LOG.error(t.getMessage(), t);
        return this.errorResponse(request, HttpStatus.BAD_REQUEST, t);
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class, DataIntegrityViolationException.class})
    @ResponseBody
    public ResponseEntity handleConflict(Exception ex, ServletServerHttpRequest request) throws IOException {
        LOG.error(ex.getMessage(), (Throwable)ex);
        return this.errorResponse(request, HttpStatus.CONFLICT, ex);
    }

    @ExceptionHandler(value={RepositoryConstraintViolationException.class})
    @ResponseBody
    public ResponseEntity handleValidationFailure(RepositoryConstraintViolationException ex, ServletServerHttpRequest request) throws IOException {
        LOG.error(ex.getMessage(), (Throwable)ex);
        HashMap m = new HashMap();
        ArrayList<String> errors = new ArrayList<String>();
        for (FieldError fe : ex.getErrors().getFieldErrors()) {
            String msg = this.applicationContext.getMessage(fe.getCode(), new Object[]{fe.getObjectName(), fe.getField(), fe.getRejectedValue()}, fe.getDefaultMessage(), null);
            errors.add(msg);
        }
        m.put("errors", errors);
        return this.negotiateResponse(request, HttpStatus.BAD_REQUEST, new HttpHeaders(), m);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public ResponseEntity handleJsr303ValidationFailure(ConstraintViolationException ex, ServletServerHttpRequest request) throws IOException {
        LOG.error(ex.getMessage(), (Throwable)ex);
        HashMap m = new HashMap();
        ArrayList<String> errors = new ArrayList<String>();
        for (ConstraintViolation cv : ex.getConstraintViolations()) {
            String msg = this.applicationContext.getMessage(cv.getMessageTemplate(), new Object[]{cv.getLeafBean().getClass().getSimpleName(), cv.getPropertyPath().toString(), cv.getInvalidValue()}, cv.getMessage(), null);
            errors.add(msg);
        }
        m.put("errors", errors);
        return this.negotiateResponse(request, HttpStatus.BAD_REQUEST, new HttpHeaders(), m);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class, HttpMessageNotWritableException.class})
    @ResponseBody
    public ResponseEntity handleMessageConversionFailure(Exception ex, HttpServletRequest request) throws IOException {
        LOG.error(ex.getMessage(), (Throwable)ex);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("message", ex.getMessage());
        m.put("acceptableTypes", this.availableMediaTypes);
        return this.negotiateResponse(new ServletServerHttpRequest(request), HttpStatus.BAD_REQUEST, new HttpHeaders(), m);
    }

    private void maybeAddPrevNextLink(URI resourceUri, RepositoryMetadata repoMeta, PagingAndSorting pageSort, Page page, boolean addIf, int nextPage, String rel, Collection<Link> links) {
        if (null != page && addIf) {
            UriComponentsBuilder urib = UriComponentsBuilder.fromUri((URI)resourceUri);
            urib.queryParam(this.config.getPageParamName(), new Object[]{nextPage});
            urib.queryParam(this.config.getLimitParamName(), new Object[]{page.getSize()});
            pageSort.addSortParameters(urib);
            links.add(new Link(urib.build().toUri().toString(), repoMeta.rel() + "." + rel));
        }
    }

    private <V extends Serializable> V stringToSerializable(String s, Class<V> targetType) {
        if (ClassUtils.isAssignable(targetType, String.class)) {
            return (V)s;
        }
        return (V)((Serializable)this.conversionService.convert((Object)s, targetType));
    }

    private <V> V readIncoming(HttpInputMessage request, MediaType incomingMediaType, Class<V> targetType) throws IOException {
        for (HttpMessageConverter<?> httpMessageConverter : this.config.getCustomConverters()) {
            if (!httpMessageConverter.canRead(targetType, incomingMediaType)) continue;
            return (V)httpMessageConverter.read(targetType, request);
        }
        for (HttpMessageConverter<?> httpMessageConverter : this.httpMessageConverters) {
            if (!httpMessageConverter.canRead(targetType, incomingMediaType)) continue;
            return (V)httpMessageConverter.read(targetType, request);
        }
        return (V)this.mappingHttpMessageConverter.read(targetType, request);
    }

    private boolean shouldReturnLinks(String acceptHeader) {
        if (null != acceptHeader) {
            List accept = MediaType.parseMediaTypes((String)acceptHeader);
            for (MediaType mt : accept) {
                if (mt.getSubtype().startsWith("x-spring-data-verbose")) {
                    return false;
                }
                if (mt.getSubtype().startsWith("x-spring-data-compact")) {
                    return true;
                }
                if (!mt.getSubtype().equals("uri-list")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean returnBody(ServletServerHttpRequest request) {
        String s = request.getServletRequest().getParameter("returnBody");
        if (null != s) {
            return "true".equals(s);
        }
        return false;
    }

    private <E extends RepositoryEvent> void publishEvent(E event) {
        if (null != this.applicationContext) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean notPagingParam(String name) {
        return !this.config.getPageParamName().equals(name) && !this.config.getLimitParamName().equals(name) && !this.config.getSortParamName().equals(name);
    }

    private Map throwableToMap(Throwable t) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("message", t.getMessage());
        if (null != t.getCause()) {
            m.put("cause", this.throwableToMap(t.getCause()));
        }
        return m;
    }

    private String objectToMapKey(Object obj) {
        String key;
        Assert.notNull((Object)obj, (String)"Map key cannot be null!");
        if (ClassUtils.isAssignable(obj.getClass(), String.class)) {
            key = (String)obj;
        } else {
            RepositoryMetadata repoMeta = this.repositoryMetadataFor(obj.getClass());
            if (null != repoMeta) {
                AttributeMetadata attrMeta = repoMeta.entityMetadata().idAttribute();
                String id = attrMeta.get(obj).toString();
                key = "@" + UriUtils.buildUri((URI)this.config.getBaseUri(), (String[])new String[]{repoMeta.name(), id});
            } else {
                key = (String)this.conversionService.convert(obj, String.class);
            }
        }
        return key;
    }

    private ResponseEntity<byte[]> notFoundResponse(ServletServerHttpRequest request) throws IOException {
        return this.negotiateResponse(request, HttpStatus.NOT_FOUND, new HttpHeaders(), null);
    }

    private ResponseEntity<byte[]> errorResponse(ServletServerHttpRequest request, HttpStatus status, Throwable t) throws IOException {
        Map body = null;
        if (this.config.isDumpErrors()) {
            body = this.throwableToMap(t);
        }
        return this.negotiateResponse(request, status, new HttpHeaders(), body);
    }

    private ResponseEntity<byte[]> negotiateResponse(ServletServerHttpRequest request, HttpStatus status, final HttpHeaders headers, Object resource) throws IOException {
        String jsonpParam = request.getServletRequest().getParameter(this.config.getJsonpParamName());
        String jsonpOnErrParam = null;
        if (null != this.config.getJsonpOnErrParamName()) {
            jsonpOnErrParam = request.getServletRequest().getParameter(this.config.getJsonpOnErrParamName());
        }
        if (null == resource) {
            return this.maybeWrapJsonp(status, jsonpParam, jsonpOnErrParam, headers, null);
        }
        MediaType acceptType = this.config.getDefaultMediaType();
        Object converter = this.findWriteConverter(resource.getClass(), acceptType);
        if (null == converter) {
            for (MediaType mt : request.getHeaders().getAccept()) {
                HttpMessageConverter hmc;
                if (MediaType.ALL.equals((Object)mt) || null == (hmc = this.findWriteConverter(resource.getClass(), mt))) continue;
                if ("*".equals(mt.getSubtype())) break;
                acceptType = mt;
                headers.setContentType(acceptType);
                converter = hmc;
                break;
            }
        }
        if (null == converter) {
            converter = this.mappingHttpMessageConverter;
            headers.setContentType(MediaType.APPLICATION_JSON);
        }
        final ByteArrayOutputStream bout = new ByteArrayOutputStream();
        converter.write(resource, headers.getContentType(), new HttpOutputMessage(){

            public OutputStream getBody() throws IOException {
                return bout;
            }

            public HttpHeaders getHeaders() {
                return headers;
            }
        });
        return this.maybeWrapJsonp(status, jsonpParam, jsonpOnErrParam, headers, bout.toByteArray());
    }

    private HttpMessageConverter findWriteConverter(Class<?> type, MediaType mediaType) {
        for (HttpMessageConverter<?> httpMessageConverter : this.config.getCustomConverters()) {
            if (!httpMessageConverter.canWrite(type, mediaType)) continue;
            return httpMessageConverter;
        }
        for (HttpMessageConverter<?> httpMessageConverter : this.httpMessageConverters) {
            if (!httpMessageConverter.canWrite(type, mediaType)) continue;
            return httpMessageConverter;
        }
        return null;
    }

    private ResponseEntity<byte[]> maybeWrapJsonp(HttpStatus status, String jsonpParam, String jsonpOnErrParam, HttpHeaders headers, byte[] body) {
        byte[] responseBody;
        byte[] byArray = responseBody = null == body ? new byte[]{} : body;
        if (status.value() >= 400 && null != jsonpOnErrParam) {
            status = HttpStatus.OK;
            responseBody = String.format("%s(%s, %s)", jsonpOnErrParam, status.value(), null != body ? new String(body) : null).getBytes();
            headers.setContentType(MediaTypes.APPLICATION_JAVASCRIPT);
        } else if (null != jsonpParam) {
            responseBody = String.format("%s(%s)", jsonpParam, null != body ? new String(body) : null).getBytes();
            headers.setContentType(MediaTypes.APPLICATION_JAVASCRIPT);
        }
        headers.setContentLength((long)responseBody.length);
        return new ResponseEntity((Object)responseBody, (MultiValueMap)headers, status);
    }
}

