/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.KeyDeserializers;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.Serializers;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.map.module.SimpleDeserializers;
import org.codehaus.jackson.map.module.SimpleKeyDeserializers;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.module.SimpleSerializers;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.AttributeMetadata;
import org.springframework.data.rest.repository.RepositoryExporter;
import org.springframework.data.rest.repository.RepositoryMetadata;
import org.springframework.data.rest.repository.UriToDomainObjectUriResolver;
import org.springframework.data.rest.webmvc.EntityToResourceConverter;
import org.springframework.data.rest.webmvc.RepositoryRestConfiguration;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class RepositoryAwareJacksonModule
extends SimpleModule
implements InitializingBean {
    @Autowired(required=false)
    private RepositoryRestConfiguration config = RepositoryRestConfiguration.DEFAULT;
    @Autowired(required=false)
    protected List<RepositoryExporter> repositoryExporters = Collections.emptyList();
    @Autowired(required=false)
    private List<ConversionService> conversionServices = Collections.emptyList();
    @Autowired(required=false)
    private List<ResourceProcessor<Resource<?>>> resourceProcessors = Collections.emptyList();
    private Multimap<Class<?>, ResourceProcessor<Resource<?>>> resourceProcessorMap = ArrayListMultimap.create();
    @Autowired
    private UriToDomainObjectUriResolver domainObjectResolver;
    private final GenericConversionService conversionService = new GenericConversionService();
    private final SimpleSerializers sers = new SimpleSerializers();
    private final SimpleDeserializers dsers = new SimpleDeserializers();
    private final SimpleSerializers keySers = new SimpleSerializers();
    private final SimpleKeyDeserializers keyDsers = new SimpleKeyDeserializers();

    public RepositoryAwareJacksonModule() {
        super("RepositoryAwareJacksonModule", Version.unknownVersion());
    }

    public void afterPropertiesSet() throws Exception {
        for (RepositoryExporter repoExp : this.repositoryExporters) {
            for (String repoName : new ArrayList(repoExp.repositoryNames())) {
                RepositoryMetadata repoMeta = repoExp.repositoryMetadataFor(repoName);
                Class domainType = repoMeta.entityMetadata().type();
                TypeInformation domainTypeInfo = ClassTypeInformation.from((Class)domainType);
                for (ResourceProcessor<Resource<?>> rp : this.resourceProcessors) {
                    TypeInformation resourceType = ClassTypeInformation.from(rp.getClass()).getSuperTypeInformation(ResourceProcessor.class).getComponentType();
                    Class processorType = resourceType.getType();
                    TypeInformation componentType = resourceType.getComponentType();
                    if (!Resource.class.isAssignableFrom(processorType) || !componentType.isAssignableFrom(domainTypeInfo)) continue;
                    this.resourceProcessorMap.put((Object)domainType, rp);
                }
                this.conversionService.addConverter(domainType, Resource.class, (Converter)new EntityToResourceConverter(this.config, repoMeta));
                this.sers.addSerializer(domainType, (JsonSerializer)new DomainObjectToResourceSerializer(domainType));
                this.keySers.addSerializer(domainType, (JsonSerializer)new DomainObjectToStringKeySerializer(domainType, repoMeta));
                this.dsers.addDeserializer(domainType, (JsonDeserializer)new LinkToDomainObjectDeserializer(domainType, repoMeta));
                this.keyDsers.addDeserializer(domainType, (KeyDeserializer)new KeyToDomainObjectDeserializer());
            }
        }
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)this.sers);
        context.addKeySerializers((Serializers)this.keySers);
        context.addDeserializers((Deserializers)this.dsers);
        context.addKeyDeserializers((KeyDeserializers)this.keyDsers);
    }

    private class KeyToDomainObjectDeserializer
    extends KeyDeserializer {
        private KeyToDomainObjectDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (key.startsWith("@http")) {
                return RepositoryAwareJacksonModule.this.domainObjectResolver.resolve(RepositoryAwareJacksonModule.this.config.getBaseUri(), URI.create(key.substring(1)));
            }
            return key;
        }
    }

    private class LinkToDomainObjectDeserializer
    extends StdDeserializer<Object> {
        protected final RepositoryMetadata repoMeta;

        private LinkToDomainObjectDeserializer(Class<?> vc, RepositoryMetadata repoMeta) {
            super(vc);
            this.repoMeta = repoMeta;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object entity = BeanUtils.instantiateClass((Class)this.getValueClass());
            JsonToken tok = jp.nextToken();
            while (tok != JsonToken.END_OBJECT) {
                String name = jp.getCurrentName();
                switch (tok) {
                    case FIELD_NAME: {
                        void var7_7;
                        AttributeMetadata attrMeta = this.repoMeta.entityMetadata().attribute(name);
                        Object var7_8 = null;
                        if (name.startsWith("@http")) {
                            entity = RepositoryAwareJacksonModule.this.domainObjectResolver.resolve(RepositoryAwareJacksonModule.this.config.getBaseUri(), URI.create(name.substring(1)));
                            break;
                        }
                        if ("href".equals(name)) {
                            entity = RepositoryAwareJacksonModule.this.domainObjectResolver.resolve(RepositoryAwareJacksonModule.this.config.getBaseUri(), URI.create(jp.nextTextValue()));
                            break;
                        }
                        if ("rel".equals(name)) break;
                        if ("links".equals(name)) {
                            tok = jp.nextToken();
                            if (tok == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                }
                                break;
                            }
                            if (tok == JsonToken.VALUE_NULL) break;
                            throw new HttpMessageNotReadableException("Property 'links' is not of array type. Either eliminate this property from the document or make it an array.");
                        }
                        if (null == attrMeta) break;
                        if (attrMeta.isCollectionLike()) {
                            ArrayList<Object> c = attrMeta.asCollection(entity);
                            if (null == c || c == Collections.emptyList()) {
                                c = new ArrayList<Object>();
                            }
                            if ((tok = jp.nextToken()) == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                    Object cval = jp.readValueAs(attrMeta.elementType());
                                    c.add(cval);
                                }
                                ArrayList<Object> arrayList = c;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Collection.");
                                Object var7_10 = null;
                            }
                        } else if (attrMeta.isSetLike()) {
                            HashSet<Object> s = attrMeta.asSet(entity);
                            if (null == s || s == Collections.emptySet()) {
                                s = new HashSet<Object>();
                            }
                            if ((tok = jp.nextToken()) == JsonToken.START_ARRAY) {
                                while ((tok = jp.nextToken()) != JsonToken.END_ARRAY) {
                                    Object sval = jp.readValueAs(attrMeta.elementType());
                                    s.add(sval);
                                }
                                HashSet<Object> hashSet = s;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Set.");
                                Object var7_13 = null;
                            }
                        } else if (attrMeta.isMapLike()) {
                            HashMap<String, Object> m = attrMeta.asMap(entity);
                            if (null == m || m == Collections.emptyMap()) {
                                m = new HashMap<String, Object>();
                            }
                            if ((tok = jp.nextToken()) == JsonToken.START_OBJECT) {
                                do {
                                    String mkey = (name = jp.getCurrentName()).startsWith("@http") ? RepositoryAwareJacksonModule.this.domainObjectResolver.resolve(RepositoryAwareJacksonModule.this.config.getBaseUri(), URI.create(name.substring(1))) : name;
                                    tok = jp.nextToken();
                                    Object mval = jp.readValueAs(attrMeta.elementType());
                                    m.put(mkey, mval);
                                } while ((tok = jp.nextToken()) != JsonToken.END_OBJECT);
                                HashMap<String, Object> hashMap = m;
                            } else {
                                if (tok != JsonToken.VALUE_NULL) throw new HttpMessageNotReadableException("Cannot read a JSON " + tok + " as a Map.");
                                Object var7_16 = null;
                            }
                        } else {
                            tok = jp.nextToken();
                            if (tok != JsonToken.VALUE_NULL) {
                                Object object = jp.readValueAs(attrMeta.type());
                            }
                        }
                        if (null == var7_7) break;
                        attrMeta.set((Object)var7_7, entity);
                        break;
                    }
                }
                tok = jp.nextToken();
            }
            return entity;
        }
    }

    private class DomainObjectToStringKeySerializer
    extends SerializerBase<Object> {
        private final RepositoryMetadata repoMeta;
        private final AttributeMetadata idAttr;

        private DomainObjectToStringKeySerializer(Class<Object> t, RepositoryMetadata repoMeta) {
            super(t);
            this.repoMeta = repoMeta;
            this.idAttr = null != repoMeta ? repoMeta.entityMetadata().idAttribute() : null;
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (null == value) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            if (null == this.repoMeta) {
                provider.defaultSerializeValue(value, jgen);
                return;
            }
            Serializable serId = (Serializable)this.idAttr.get(value);
            String sId = null;
            for (ConversionService cs : RepositoryAwareJacksonModule.this.conversionServices) {
                if (!cs.canConvert(this.idAttr.type(), String.class)) continue;
                sId = (String)cs.convert((Object)serId, String.class);
                break;
            }
            if (null == sId) {
                sId = serId.toString();
            }
            URI href = UriUtils.buildUri((URI)RepositoryAwareJacksonModule.this.config.getBaseUri(), (String[])new String[]{this.repoMeta.name(), sId});
            jgen.writeString("@" + href.toString());
        }
    }

    private class DomainObjectToResourceSerializer
    extends SerializerBase<Object> {
        private DomainObjectToResourceSerializer(Class<Object> t) {
            super(t);
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (null == value) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            if (!RepositoryAwareJacksonModule.this.conversionService.canConvert(value.getClass(), Resource.class)) {
                provider.defaultSerializeValue(value, jgen);
                return;
            }
            Resource resource = new Resource(value, new Link[0]);
            for (ResourceProcessor rp : RepositoryAwareJacksonModule.this.resourceProcessorMap.get(value.getClass())) {
                resource = (Resource)rp.process((ResourceSupport)resource);
            }
            if (null == resource.getContent()) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            Class<?> sourceType = resource.getContent().getClass();
            GenericConversionService entityConversionSvc = RepositoryAwareJacksonModule.this.conversionService;
            for (ConversionService cs : RepositoryAwareJacksonModule.this.conversionServices) {
                if (!cs.canConvert(sourceType, Resource.class)) continue;
                entityConversionSvc = cs;
                break;
            }
            if (entityConversionSvc.canConvert(sourceType, Resource.class)) {
                List links = resource.getLinks();
                resource = (Resource)entityConversionSvc.convert(value, Resource.class);
                resource.add((Iterable)links);
            }
            jgen.writeObject((Object)resource);
        }
    }
}

