/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.hibernate5.jakarta.Hibernate5JakartaModule;
import org.hibernate.Version;
import org.springframework.util.ClassUtils;

public class Jackson2DatatypeHelper {
    private static final boolean IS_HIBERNATE_AVAILABLE = ClassUtils.isPresent((String)"org.hibernate.Version", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());
    private static final boolean IS_HIBERNATE5_MODULE_AVAILABLE = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.hibernate5.jakarta.Hibernate5JakartaModule", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());

    public static void configureObjectMapper(ObjectMapper mapper) {
        if (IS_HIBERNATE_AVAILABLE && HibernateVersions.isHibernate5() && IS_HIBERNATE5_MODULE_AVAILABLE) {
            new Hibernate5ModuleRegistrar().registerModule(mapper);
        }
    }

    private static class HibernateVersions {
        private HibernateVersions() {
        }

        public static boolean isHibernate5() {
            return Version.getVersionString().startsWith("5");
        }
    }

    private static class Hibernate5ModuleRegistrar {
        private Hibernate5ModuleRegistrar() {
        }

        public void registerModule(ObjectMapper mapper) {
            Hibernate5JakartaModule module = new Hibernate5JakartaModule();
            module.enable(Hibernate5JakartaModule.Feature.FORCE_LAZY_LOADING);
            mapper.registerModule((Module)module);
        }
    }
}

