/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompilationSummary {
    private String id;
    private List<Compiled> data;

    private CompilationSummary() {
    }

    private CompilationSummary(String id, List<Compiled> data) {
        this.id = id;
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public List<Compiled> getData() {
        return this.data;
    }

    public static CompilationSummary load(String id, String file) {
        try {
            ArrayList<Compiled> data = new ArrayList<Compiled>();
            List<String> lines = Files.readAllLines(Paths.get(new File(file).toURI()));
            for (String line : lines) {
                if (!line.startsWith("Compiling ")) continue;
                data.add(Compiled.from(line));
            }
            return new CompilationSummary(id, data);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Problem loading file: " + file, ioe);
        }
    }

    public String getReason(String typename) {
        for (Compiled compiled : this.data) {
            if (!compiled.type.equals(typename)) continue;
            return compiled.getReason();
        }
        return null;
    }

    static class Compiled
    implements Comparable<Compiled> {
        private static final Pattern p = Pattern.compile("^Compiling ([^ ]*) ([^ ]*)\\.([^ ]*)(\\(.*\\)) *\\[(.*)\\]$");
        private String returnType;
        private String type;
        private String method;
        private String parameterString;
        private String reason;

        private Compiled(String returnType, String type, String method, String parameterString, String reason) {
            this.returnType = returnType;
            this.type = type;
            this.method = method;
            this.parameterString = parameterString;
            this.reason = reason;
        }

        public static Compiled from(String line) {
            int u;
            Matcher matcher = p.matcher(line);
            boolean matched = matcher.find();
            if (!matched || matcher.groupCount() != 5) {
                throw new IllegalStateException("Unable to match '" + line + "' " + (!matched ? "" : "(groupCount=" + matcher.groupCount() + ")"));
            }
            String returnType = matcher.group(1);
            String type = matcher.group(2);
            String method = matcher.group(3);
            String parameterString = matcher.group(4);
            String reason = matcher.group(5);
            if (type.startsWith("com.oracle.svm.reflect") && (u = type.lastIndexOf("_")) != -1) {
                type = type.substring(0, u);
            }
            return new Compiled(returnType, type, method, parameterString, reason);
        }

        public String getPackageName() {
            int dot = this.type.lastIndexOf(".");
            if (dot == -1) {
                return "default";
            }
            return this.type.substring(0, dot + 1);
        }

        public String getType() {
            return this.type;
        }

        public String getReason() {
            return this.reason;
        }

        @Override
        public int compareTo(Compiled o) {
            int rc = this.returnType.compareTo(o.returnType);
            if (rc != 0) {
                return rc;
            }
            rc = this.type.compareTo(o.type);
            if (rc != 0) {
                return rc;
            }
            rc = this.method.compareTo(o.method);
            if (rc != 0) {
                return rc;
            }
            return this.parameterString.compareTo(o.parameterString);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.returnType).append(" ").append(this.type).append(".").append(this.method).append(this.parameterString);
            return s.toString();
        }
    }
}

