/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.graalvm.support.CompilationSummary;
import org.springframework.graalvm.support.ReportNode;

public class CompilationSummaryDiff {
    private static int collapseCount;

    public static void main(String[] args) throws IOException, URISyntaxException {
        if (args == null || args.length < 3) {
            System.out.println("Usage: CompilationSummaryDiff <id>:<fileLocation> <id>:<fileLocation> [htmlDiffFile]");
            System.out.println("e.g. CompilationSummaryDiff agent:/path/to/output.txt hybrid:/path/to/output.txt diff.html");
            System.exit(0);
        }
        int idxA = args[0].indexOf(":");
        int idxB = args[1].indexOf(":");
        if (idxA == -1 || idxB == -1) {
            System.out.println("Usage: CompilationSummaryDiff <id>:<fileLocation> <id>:<fileLocation> [htmlDiffFile]");
            System.out.println("e.g. CompilationSummaryDiff agent:/path/to/output.txt hybrid:/path/to/output.txt diff.html");
            System.exit(0);
        }
        String idA = args[0].substring(0, idxA);
        String fileA = args[0].substring(idxA + 1);
        String idB = args[1].substring(0, idxB);
        String fileB = args[1].substring(idxB + 1);
        CompilationSummary a = CompilationSummary.load(idA, fileA);
        CompilationSummary b = CompilationSummary.load(idB, fileB);
        System.out.println("Compiled entries in " + a.getId() + " = " + a.getData().size());
        System.out.println("Compiled entries in " + b.getId() + " = " + b.getData().size());
        Map packagesA = a.getData().stream().map(CompilationSummary.Compiled::getPackageName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map packagesB = b.getData().stream().map(CompilationSummary.Compiled::getPackageName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        System.out.println("Number of packages in " + a.getId() + ": " + packagesA.size());
        System.out.println("Number of packages in " + b.getId() + ": " + packagesB.size());
        List typenamesA = a.getData().stream().map(CompilationSummary.Compiled::getType).collect(Collectors.toList());
        List typenamesB = b.getData().stream().map(CompilationSummary.Compiled::getType).collect(Collectors.toList());
        HashSet diff = null;
        diff = new HashSet();
        diff.addAll(typenamesA);
        diff.removeAll(typenamesB);
        System.out.println("Types in " + a.getId() + " but not in " + b.getId() + " = " + diff.size());
        diff = new HashSet();
        diff.addAll(typenamesB);
        diff.removeAll(typenamesA);
        System.out.println("Types in " + b.getId() + " but not in " + a.getId() + " = " + diff.size());
        Iterator iterator = diff.iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (!next.contains("$$Lambda$")) continue;
            iterator.remove();
        }
        ReportNode root = new ReportNode();
        for (String typename : diff) {
            StringTokenizer st = new StringTokenizer(typename, ".");
            ReportNode currentDepth = root;
            while (st.hasMoreElements()) {
                String nameElement = st.nextToken();
                ReportNode exists = currentDepth.getChild(nameElement);
                if (exists != null) {
                    currentDepth = exists;
                    continue;
                }
                ReportNode n = new ReportNode(nameElement, 0);
                currentDepth.addChild(n);
                currentDepth = n;
            }
        }
        collapseCount = 0;
        CompilationSummaryDiff.collapse(null, root);
        System.out.println("Collapsed: " + collapseCount);
        root.sortChildren();
        StringBuilder html = new StringBuilder();
        CompilationSummaryDiff.walkGraph(root, html);
        URI template = CompilationSummary.class.getResource("/template-compilation-diff.html").toURI();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        List<String> readAllLines = Files.readAllLines(Paths.get(template));
        ArrayList<String> lines = new ArrayList<String>();
        for (String l : readAllLines) {
            if (l.contains("TREE-GOES-HERE")) {
                lines.add(l.replace("TREE-GOES-HERE", "" + html.toString()) + "");
                continue;
            }
            if (l.contains("HEADER")) {
                lines.add(l.replace("HEADER", "Types in " + b.getId() + " but not in " + a.getId() + " = " + diff.size()));
                continue;
            }
            lines.add(l);
        }
        File outputHTML = new File(args[2]);
        Files.write(outputHTML.toPath(), lines, new OpenOption[0]);
    }

    private static void collapse(ReportNode parent, ReportNode node) {
        List<ReportNode> children = node.getChildren();
        if (children.size() == 1 && children.get(0).getChildren().size() != 0) {
            ReportNode singleChild = children.get(0);
            node.setData((parent == null ? "" : node.getData() + ".") + singleChild.getData());
            node.setChildren(singleChild.getChildren());
            ++collapseCount;
            CompilationSummaryDiff.collapse(parent, node);
        } else {
            for (ReportNode child : children) {
                CompilationSummaryDiff.collapse(node, child);
            }
        }
    }

    private static void walkGraph(ReportNode node, StringBuilder json) {
        List<ReportNode> children = node.getChildren();
        if (node.getData() == null) {
            json.append("<ul id=\"root\">\n");
            for (int n = 0; n < children.size(); ++n) {
                if (n > 0) {
                    json.append("\n");
                }
                CompilationSummaryDiff.walkGraph(children.get(n), json);
            }
            json.append("</ul>\n");
        } else if (children.size() == 0) {
            json.append("<li>" + node.getData() + "</li>");
        } else {
            String label = node.getData() + (children.size() != 0 ? ":" + node.totalChildren() : "");
            json.append("<li><span class=\"caret\">" + label + "</span>\n");
            if (children.size() != 0) {
                json.append("<ul class=\"nested\"\n");
                for (int n = 0; n < children.size(); ++n) {
                    CompilationSummaryDiff.walkGraph(children.get(n), json);
                }
                json.append("</ul>\n");
            }
            json.append("</li>");
        }
    }
}

