/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Histogram {
    private String name;
    private List<Datum> data;
    private Set<String> packages = null;

    private Histogram() {
    }

    private Histogram(String name, List<Datum> data) {
        this.name = name;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public List<Datum> getData() {
        return this.data;
    }

    public static Histogram load(String name, String file) {
        try {
            ArrayList<Datum> data = new ArrayList<Datum>();
            List<String> lines = Files.readAllLines(Paths.get(new File(file).toURI()));
            boolean processingData = false;
            boolean inTotalSection = false;
            for (String line : lines) {
                if (inTotalSection && processingData) {
                    if (line.trim().length() == 0) break;
                    data.add(Datum.from(line));
                    continue;
                }
                if (line.trim().equals("=== Total ===")) {
                    inTotalSection = true;
                    continue;
                }
                if (line.trim().equals("")) {
                    inTotalSection = false;
                    continue;
                }
                if (!inTotalSection || !line.matches(".*Count.*Size.*Size%.*Cum%.*Class.*$")) continue;
                processingData = true;
            }
            return new Histogram(name, data);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Problem loading file: " + file, ioe);
        }
    }

    public Set<String> packagesNotIn(Histogram b) {
        Set<String> thisPackages = this.getPackages();
        Set<String> thatPackages = b.getPackages();
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(thisPackages);
        result.removeAll(thatPackages);
        return result;
    }

    public Set<Datum> typesNotIn(Histogram b) {
        return this.typesNotIn(b, false);
    }

    public Set<Datum> typesNotIn(Histogram b, boolean skipReflectiveEntries) {
        TreeSet<Datum> result = new TreeSet<Datum>();
        for (Datum d : this.data) {
            if (skipReflectiveEntries && d.isReflection || b.containsClassname(d.getClassname())) continue;
            result.add(d);
        }
        return result;
    }

    private boolean containsClassname(String classname) {
        for (Datum d : this.data) {
            if (!d.classname.equals(classname)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getPackages() {
        if (this.packages == null) {
            this.packages = new TreeSet<String>();
            for (Datum d : this.data) {
                String packageName = d.getPackageName();
                this.packages.add(packageName);
            }
        }
        return this.packages;
    }

    public List<Datum> getReflectiveEntries() {
        ArrayList<Datum> result = new ArrayList<Datum>();
        for (Datum d : this.data) {
            if (!d.isReflection) continue;
            result.add(d);
        }
        return result;
    }

    public int getSizeOf(String classname) {
        for (Datum d : this.data) {
            if (!d.getClassname().equals(classname)) continue;
            return d.size;
        }
        return 0;
    }

    static class Datum
    implements Comparable<Datum> {
        static final Pattern p = Pattern.compile("^ *([0-9]*) *([0-9]*) *([0-9\\.]*)% *([0-9\\.]*)% *(.*)$");
        static final Pattern withoutHex = Pattern.compile("^(.*)_[0-9a-f]*$");
        int count;
        int size;
        double sizePercent;
        double cPercent;
        String classname;
        boolean isReflection;

        public int getSize() {
            return this.size;
        }

        private Datum(int count, int size, double sizePercent, double cPercent, String classname) {
            this.count = count;
            this.size = size;
            this.sizePercent = sizePercent;
            this.cPercent = cPercent;
            Matcher matcher = withoutHex.matcher(classname);
            if (matcher.find()) {
                this.classname = matcher.group(1);
                this.isReflection = true;
            } else {
                this.classname = classname;
                this.isReflection = false;
            }
        }

        public String getClassname() {
            return this.classname;
        }

        public static Datum from(String line) {
            Matcher matcher = p.matcher(line);
            boolean matched = matcher.find();
            if (!matched || matcher.groupCount() != 5) {
                throw new IllegalStateException("Unable to match '" + line + "' " + (!matched ? "" : "(groupCount=" + matcher.groupCount() + ")"));
            }
            return new Datum(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Double.parseDouble(matcher.group(3)), Double.parseDouble(matcher.group(4)), matcher.group(5));
        }

        public String getPackageName() {
            int lastDot = this.classname.lastIndexOf(".");
            return lastDot == -1 ? this.classname : this.classname.substring(0, lastDot + 1);
        }

        public boolean isReflection() {
            return this.isReflection;
        }

        @Override
        public int compareTo(Datum o) {
            if (this.classname.equals(o.classname)) {
                return this.size - o.size;
            }
            return this.classname.compareTo(o.classname);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.classname).append("::").append(this.size);
            return s.toString();
        }
    }
}

