/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.springframework.graalvm.support.Histogram;
import org.springframework.graalvm.support.ReportNode;

public class HistogramDiff {
    private static int collapseCount;

    public static void main(String[] args) throws IOException, URISyntaxException {
        if (args == null || args.length < 3) {
            System.out.println("Usage: HistogramDiff <id>:<fileLocation> <id>:<fileLocation> <htmlDiffFileOutput>");
            System.out.println("e.g. HistogramDiff agent:/path/to/output.txt hybrid:/path/to/output.txt diff.html");
            System.exit(0);
        }
        int idxA = args[0].indexOf(":");
        int idxB = args[1].indexOf(":");
        if (idxA == -1 || idxB == -1) {
            System.out.println("Usage: HistogramDiff <id>:<fileLocation> <id>:<fileLocation> <htmlDiffFileOutput>");
            System.out.println("e.g. HistogramDiff agent:/path/to/output.txt hybrid:/path/to/output.txt diff.html");
            System.exit(0);
        }
        String idA = args[0].substring(0, idxA);
        String fileA = args[0].substring(idxA + 1);
        String idB = args[1].substring(0, idxB);
        String fileB = args[1].substring(idxB + 1);
        Histogram a = Histogram.load(idA, fileA);
        Histogram b = Histogram.load(idB, fileB);
        System.out.println(a.getData().size() + " entries loaded");
        System.out.println(b.getData().size() + " entries loaded");
        Set<String> packagesInFirstAndNotInSecond = a.packagesNotIn(b);
        System.out.println("These packages are in the first and not the second:" + packagesInFirstAndNotInSecond.size());
        packagesInFirstAndNotInSecond.stream().forEach(System.out::println);
        Set<Histogram.Datum> typesInFirstAndNotInSecond = a.typesNotIn(b);
        System.out.println("These types are in the first and not the second:" + typesInFirstAndNotInSecond.size());
        typesInFirstAndNotInSecond.stream().forEach(System.out::println);
        System.out.println("Comparing feature vs hybrid");
        Set<String> packagesInSecondAndNotInFirst = b.packagesNotIn(a);
        System.out.println("These packages are in the second and not the first:" + packagesInSecondAndNotInFirst.size());
        packagesInSecondAndNotInFirst.stream().forEach(System.out::println);
        Set<Histogram.Datum> typesInSecondAndNotInFirst = b.typesNotIn(a, true);
        System.out.println("These types are in the second and not the first:" + typesInSecondAndNotInFirst.size());
        typesInSecondAndNotInFirst.stream().forEach(System.out::println);
        System.out.println("XX These types (excluding reflection) are in the " + b.getName() + " and not in " + a.getName() + ": " + typesInSecondAndNotInFirst.size());
        typesInSecondAndNotInFirst.stream().forEach(System.out::println);
        System.out.println("===");
        List<Histogram.Datum> reflectiveA = a.getReflectiveEntries();
        System.out.println("Reflective in " + a.getName() + ": " + reflectiveA.size() + "  Total bytes: " + reflectiveA.stream().mapToInt(Histogram.Datum::getSize).sum());
        List<Histogram.Datum> reflectiveB = b.getReflectiveEntries();
        System.out.println("Reflective in " + b.getName() + ": " + reflectiveB.size() + "  Total bytes: " + reflectiveB.stream().mapToInt(Histogram.Datum::getSize).sum());
        System.out.println("Total size for " + a.getName() + " = " + a.getData().stream().mapToInt(Histogram.Datum::getSize).sum());
        System.out.println("Total size for " + b.getName() + " = " + b.getData().stream().mapToInt(Histogram.Datum::getSize).sum());
        ArrayList<Histogram.Datum> sortedList = new ArrayList<Histogram.Datum>();
        sortedList.addAll(b.getData());
        Collections.sort(sortedList, (d1, d2) -> {
            int differenceD1;
            int sizeOfD1_A = a.getSizeOf(d1.getClassname());
            int sizeOfD1_B = b.getSizeOf(d1.getClassname());
            int sizeOfD2_A = a.getSizeOf(d2.getClassname());
            int sizeOfD2_B = b.getSizeOf(d2.getClassname());
            int differenceD2 = sizeOfD2_B - sizeOfD2_A;
            if (differenceD2 < (differenceD1 = sizeOfD1_B - sizeOfD1_A)) {
                return -1;
            }
            if (differenceD2 > differenceD1) {
                return 1;
            }
            return 0;
        });
        LinkedHashMap<String, Integer> differences = new LinkedHashMap<String, Integer>();
        Iterator di = sortedList.iterator();
        while (di.hasNext()) {
            Histogram.Datum d = (Histogram.Datum)di.next();
            int sizeOfD_A = a.getSizeOf(d.getClassname());
            int sizeOfD_B = b.getSizeOf(d.getClassname());
            int differenceD = sizeOfD_B - sizeOfD_A;
            if (differenceD == 0) {
                di.remove();
            }
            differences.put(d.getClassname(), differenceD);
        }
        ReportNode root = new ReportNode();
        for (Histogram.Datum d : sortedList) {
            String typename = d.getClassname();
            StringTokenizer st = new StringTokenizer(typename, ".");
            ReportNode currentDepth = root;
            while (st.hasMoreElements()) {
                String nameElement = st.nextToken();
                ReportNode exists = currentDepth.getChild(nameElement);
                if (exists != null) {
                    currentDepth = exists;
                    continue;
                }
                System.out.println("differences.get for " + typename + " = " + differences.get(typename));
                ReportNode n = new ReportNode(nameElement, st.hasMoreTokens() ? -1 : (Integer)differences.get(typename));
                currentDepth.addChild(n);
                currentDepth = n;
            }
        }
        collapseCount = 0;
        HistogramDiff.collapse(null, root);
        System.out.println("Collapsed: " + collapseCount);
        HistogramDiff.walkGraphComputeSize(root);
        root.sortChildrenBySize();
        StringBuilder html = new StringBuilder();
        HistogramDiff.walkGraph(root, html);
        URI template = HistogramDiff.class.getResource("/template-histogram-diff.html").toURI();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        FileSystem zipfs = FileSystems.newFileSystem(template, env);
        List<String> readAllLines = Files.readAllLines(Paths.get(template));
        ArrayList<String> lines = new ArrayList<String>();
        for (String l : readAllLines) {
            if (l.contains("TREE-GOES-HERE")) {
                lines.add(l.replace("TREE-GOES-HERE", "" + html.toString()) + "");
                continue;
            }
            if (l.contains("HEADER")) {
                lines.add(l.replace("HEADER", "What is consuming more data in " + b.getName() + " than in " + a.getName()));
                continue;
            }
            lines.add(l);
        }
        File outputHTML = new File(args[2]);
        Files.write(outputHTML.toPath(), lines, new OpenOption[0]);
    }

    private static void collapse(ReportNode parent, ReportNode node) {
        List<ReportNode> children = node.getChildren();
        if (children.size() == 1 && children.get(0).getChildren().size() != 0) {
            ReportNode singleChild = children.get(0);
            node.setData(node.getData() + "." + singleChild.getData());
            node.setChildren(singleChild.getChildren());
            ++collapseCount;
            HistogramDiff.collapse(parent, node);
        } else {
            for (ReportNode child : children) {
                HistogramDiff.collapse(node, child);
            }
        }
    }

    private static void walkGraph(ReportNode node, StringBuilder json) {
        List<ReportNode> children = node.getChildren();
        if (node.getData() == null) {
            json.append("<ul id=\"root\">\n");
            for (int n = 0; n < children.size(); ++n) {
                if (n > 0) {
                    json.append("\n");
                }
                HistogramDiff.walkGraph(children.get(n), json);
            }
            json.append("</ul>\n");
        } else if (children.size() == 0) {
            json.append("<li>" + node.getData() + " (" + node.getSize() + "bytes)</li>");
        } else {
            String label = node.getData() + " (" + node.getSize() + "bytes)";
            json.append("<li><span class=\"caret\">" + label + "</span>\n");
            if (children.size() != 0) {
                json.append("<ul class=\"nested\"\n");
                for (int n = 0; n < children.size(); ++n) {
                    HistogramDiff.walkGraph(children.get(n), json);
                }
                json.append("</ul>\n");
            }
            json.append("</li>");
        }
    }

    private static void walkGraphComputeSize(ReportNode node) {
        List<ReportNode> children = node.getChildren();
        int totalSize = 0;
        for (ReportNode child : children) {
            HistogramDiff.walkGraphComputeSize(child);
            totalSize += child.getSize();
        }
        if (node.getSize() == -1) {
            node.setSize(totalSize);
        }
    }
}

