/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReportNode {
    private String data;
    private int size;
    private List<ReportNode> children = new ArrayList<ReportNode>();

    ReportNode() {
    }

    public void sortChildren() {
        if (this.children.size() > 1) {
            Collections.sort(this.children, (n1, n2) -> {
                int score = n2.totalChildren() - n1.totalChildren();
                if (score != 0) {
                    return score;
                }
                return n1.data.compareTo(n2.data);
            });
            for (ReportNode c : this.children) {
                c.sortChildren();
            }
        }
    }

    public void sortChildrenBySize() {
        if (this.children.size() > 1) {
            Collections.sort(this.children, (n1, n2) -> n2.getSize() - n1.getSize());
            for (ReportNode c : this.children) {
                c.sortChildrenBySize();
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public int totalSize() {
        if (this.children.size() == 0) {
            return this.size;
        }
        int totalsize = 0;
        for (ReportNode c : this.children) {
            totalsize += c.totalSize();
        }
        return totalsize;
    }

    public int totalChildren() {
        int totalkids = 0;
        if (this.children.size() == 0) {
            return 1;
        }
        for (ReportNode c : this.children) {
            totalkids += c.totalChildren();
        }
        return totalkids;
    }

    public void setData(String string) {
        this.data = string;
    }

    public void setChildren(List<ReportNode> children2) {
        this.children = children2;
    }

    public String getData() {
        return this.data;
    }

    ReportNode(String data, int size) {
        this.data = data;
        this.size = size;
    }

    void addChild(ReportNode n) {
        this.children.add(n);
    }

    ReportNode getChild(String data) {
        for (ReportNode n : this.children) {
            if (!n.data.equals(data)) continue;
            return n;
        }
        return null;
    }

    List<ReportNode> getChildren() {
        return this.children;
    }
}

