/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.springframework.boot.NativePropertiesListener;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationImportListener;
import org.springframework.boot.autoconfigure.condition.ConditionProvider;
import org.springframework.boot.autoconfigure.flyway.FlywayProvider;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerTemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.jdbc.JdbcProvider;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportLoggingListener;
import org.springframework.boot.autoconfigure.mustache.MustacheTemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProvider;
import org.springframework.boot.autoconfigure.session.SessionProvider;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafTemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.web.servlet.JspTemplateAvailabilityProvider;
import org.springframework.boot.builder.ParentContextCloserApplicationListener;
import org.springframework.boot.context.ConfigurationWarningsApplicationContextInitializer;
import org.springframework.boot.context.ContextIdApplicationContextInitializer;
import org.springframework.boot.context.FileEncodingApplicationListener;
import org.springframework.boot.context.config.AnsiOutputApplicationListener;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.config.DelegatingApplicationContextInitializer;
import org.springframework.boot.context.config.DelegatingApplicationListener;
import org.springframework.boot.context.logging.ClasspathLoggingApplicationListener;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.boot.diagnostics.FailureAnalysisReporter;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.boot.diagnostics.LoggingFailureAnalysisReporter;
import org.springframework.boot.diagnostics.analyzer.AnalyzerProvider;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.SpringApplicationJsonEnvironmentPostProcessor;
import org.springframework.boot.env.SystemEnvironmentPropertySourceEnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.boot.liquibase.LiquibaseServiceLocatorApplicationListener;
import org.springframework.boot.rsocket.context.RSocketPortInfoApplicationContextInitializer;
import org.springframework.boot.web.context.ServerPortInfoApplicationContextInitializer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.init.func.FunctionalInstallerListener;
import org.springframework.init.func.InfrastructureInitializer;
import org.springframework.init.func.InfrastructureListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class SpringBootFactories {
    public static MultiValueMap<Class<?>, Object> factories = new LinkedMultiValueMap<Class<?>, Object>(){};

    static {
        boolean removeYamlSupport = Boolean.valueOf(System.getProperty("spring.native.remove-yaml-support", "false"));
        boolean isAutoconfigurePresent = ClassUtils.isPresent((String)"org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportLoggingListener", null);
        boolean isRsocketPresent = ClassUtils.isPresent((String)"io.rsocket.RSocket", null);
        boolean isLiquibasePresent = ClassUtils.isPresent((String)"liquibase.servicelocator.CustomResolverServiceLocator", null);
        boolean isFlywayPresent = ClassUtils.isPresent((String)"org.flywaydb.core.Flyway", null);
        boolean isFreemarkerPresent = ClassUtils.isPresent((String)"freemarker.template.Configuration", null);
        boolean isMustachePresent = ClassUtils.isPresent((String)"com.samskivert.mustache.Mustache", null);
        boolean isGroovyTemplatePresent = ClassUtils.isPresent((String)"groovy.text.TemplateEngine", null);
        boolean isThymeleafPresent = ClassUtils.isPresent((String)"org.thymeleaf.spring5.SpringTemplateEngine", null);
        boolean isJspPresent = ClassUtils.isPresent((String)"org.apache.jasper.compiler.JspConfig", null);
        boolean isSpringJdbcPresent = ClassUtils.isPresent((String)"org.springframework.jdbc.CannotGetJdbcConnectionException", null);
        boolean isR2dbcPresent = ClassUtils.isPresent((String)"io.r2dbc.spi.ConnectionFactory", null);
        boolean isSpringInitPresent = ClassUtils.isPresent((String)"org.springframework.init.func.FunctionalInstallerListener", null);
        factories.add(PropertySourceLoader.class, (Object)new PropertiesPropertySourceLoader());
        if (!removeYamlSupport) {
            factories.add(PropertySourceLoader.class, (Object)new YamlPropertySourceLoader());
        }
        factories.add(ApplicationContextInitializer.class, (Object)new ConfigurationWarningsApplicationContextInitializer());
        factories.add(ApplicationContextInitializer.class, (Object)new ContextIdApplicationContextInitializer());
        factories.add(ApplicationContextInitializer.class, (Object)new DelegatingApplicationContextInitializer());
        if (isRsocketPresent) {
            factories.add(ApplicationContextInitializer.class, (Object)new RSocketPortInfoApplicationContextInitializer());
        }
        factories.add(ApplicationContextInitializer.class, (Object)new ServerPortInfoApplicationContextInitializer());
        if (isAutoconfigurePresent) {
            factories.add(ApplicationContextInitializer.class, (Object)new ConditionEvaluationReportLoggingListener());
        }
        factories.add(ApplicationListener.class, (Object)new ParentContextCloserApplicationListener());
        factories.add(ApplicationListener.class, (Object)new FileEncodingApplicationListener());
        factories.add(ApplicationListener.class, (Object)new AnsiOutputApplicationListener());
        factories.add(ApplicationListener.class, (Object)new DelegatingApplicationListener());
        factories.add(ApplicationListener.class, (Object)new ClasspathLoggingApplicationListener());
        factories.add(ApplicationListener.class, (Object)new LoggingApplicationListener());
        if (isLiquibasePresent) {
            factories.add(ApplicationListener.class, (Object)new LiquibaseServiceLocatorApplicationListener());
        }
        if (isSpringInitPresent) {
            factories.add(ApplicationContextInitializer.class, (Object)new InfrastructureInitializer());
            factories.add(ApplicationListener.class, (Object)new InfrastructureListener());
            factories.add(ApplicationListener.class, (Object)new FunctionalInstallerListener());
        }
        factories.add(ApplicationListener.class, (Object)new NativePropertiesListener());
        factories.add(EnvironmentPostProcessor.class, (Object)new SpringApplicationJsonEnvironmentPostProcessor());
        factories.add(EnvironmentPostProcessor.class, (Object)new SystemEnvironmentPropertySourceEnvironmentPostProcessor());
        factories.add(EnvironmentPostProcessor.class, (Object)new ConfigFileApplicationListener());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getBeanCurrentlyInCreationFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getBeanDefinitionOverrideFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getBeanNotOfRequiredTypeFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getBindFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getBindValidationFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getUnboundConfigurationPropertyFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getConnectorStartFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getNoSuchMethodFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getNoUniqueBeanDefinitionFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getPortInUseFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getInvalidConfigurationPropertyNameFailureAnalyzer());
        factories.add(FailureAnalyzer.class, (Object)AnalyzerProvider.getInvalidConfigurationPropertyValueFailureAnalyzer());
        if (isAutoconfigurePresent) {
            if (isFlywayPresent) {
                factories.add(FailureAnalyzer.class, (Object)FlywayProvider.getFlywayMigrationScriptMissingFailureAnalyzer());
            }
            if (isSpringJdbcPresent) {
                factories.add(FailureAnalyzer.class, (Object)JdbcProvider.getDataSourceBeanCreationFailureAnalyzer());
                factories.add(FailureAnalyzer.class, (Object)JdbcProvider.getHikariDriverConfigurationFailureAnalyzer());
            }
            if (isR2dbcPresent) {
                factories.add(FailureAnalyzer.class, (Object)R2dbcProvider.getConnectionFactoryBeanCreationFailureAnalyzer());
            }
            factories.add(FailureAnalyzer.class, (Object)SessionProvider.getNonUniqueSessionRepositoryFailureAnalyzer());
        }
        factories.add(FailureAnalysisReporter.class, (Object)new LoggingFailureAnalysisReporter());
        if (isAutoconfigurePresent) {
            factories.add(AutoConfigurationImportListener.class, (Object)ConditionProvider.getConditionEvaluationReportAutoConfigurationImportListener());
            factories.add(AutoConfigurationImportFilter.class, (Object)ConditionProvider.getOnBeanCondition());
            factories.add(AutoConfigurationImportFilter.class, (Object)ConditionProvider.getOnClassCondition());
            factories.add(AutoConfigurationImportFilter.class, (Object)ConditionProvider.getOnWebApplicationCondition());
            if (isFreemarkerPresent) {
                factories.add(TemplateAvailabilityProvider.class, (Object)new FreeMarkerTemplateAvailabilityProvider());
            }
            if (isMustachePresent) {
                factories.add(TemplateAvailabilityProvider.class, (Object)new MustacheTemplateAvailabilityProvider());
            }
            if (isGroovyTemplatePresent) {
                factories.add(TemplateAvailabilityProvider.class, (Object)new GroovyTemplateAvailabilityProvider());
            }
            if (isThymeleafPresent) {
                factories.add(TemplateAvailabilityProvider.class, (Object)new ThymeleafTemplateAvailabilityProvider());
            }
            if (isJspPresent) {
                factories.add(TemplateAvailabilityProvider.class, (Object)new JspTemplateAvailabilityProvider());
            }
        }
    }
}

