/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.domain.init;

import java.util.ArrayList;
import java.util.List;
import org.springframework.graalvm.domain.init.InitializationJsonMarshaller;

public class InitializationDescriptor {
    private final List<String> buildtimeClasses;
    private final List<String> buildtimePackages;
    private final List<String> runtimeClasses;
    private final List<String> runtimePackages;

    public InitializationDescriptor() {
        this.buildtimeClasses = new ArrayList<String>();
        this.buildtimePackages = new ArrayList<String>();
        this.runtimeClasses = new ArrayList<String>();
        this.runtimePackages = new ArrayList<String>();
    }

    public InitializationDescriptor(InitializationDescriptor metadata) {
        this.buildtimeClasses = new ArrayList<String>(metadata.buildtimeClasses);
        this.buildtimePackages = new ArrayList<String>(metadata.buildtimePackages);
        this.runtimeClasses = new ArrayList<String>(metadata.runtimeClasses);
        this.runtimePackages = new ArrayList<String>(metadata.runtimePackages);
    }

    public List<String> getBuildtimeClasses() {
        return this.buildtimeClasses;
    }

    public List<String> getBuildtimePackages() {
        return this.buildtimePackages;
    }

    public List<String> getRuntimeClasses() {
        return this.runtimeClasses;
    }

    public List<String> getRuntimePackages() {
        return this.runtimePackages;
    }

    public void addBuildtimeClass(String clazz) {
        this.buildtimeClasses.add(clazz);
    }

    public void addBuildtimePackage(String pkg) {
        this.buildtimePackages.add(pkg);
    }

    public void addRuntimeClass(String clazz) {
        this.runtimeClasses.add(clazz);
    }

    public void addRuntimePackage(String pkg) {
        this.runtimePackages.add(pkg);
    }

    public String toDetailedString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("#%s buildtime-init-classes   #%s buildtime-init-packages   #%s runtime-init-classes    #%s runtime-init-packages\n", this.buildtimeClasses.size(), this.buildtimePackages.size(), this.runtimeClasses.size(), this.runtimePackages.size()));
        result.append("buildtime classes:\n");
        this.buildtimeClasses.forEach(cd -> result.append(String.format("%s\n", cd)));
        result.append("buildtime packages:\n");
        this.buildtimePackages.forEach(cd -> result.append(String.format("%s\n", cd)));
        result.append("runtime classes:\n");
        this.runtimeClasses.forEach(cd -> result.append(String.format("%s\n", cd)));
        result.append("runtime packages:\n");
        this.runtimePackages.forEach(cd -> result.append(String.format("%s\n", cd)));
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("#%s buildtime-init-classes   #%s buildtime-init-packages   #%s runtime-init-classes    #%s runtime-init-packages\n", this.buildtimeClasses.size(), this.buildtimePackages.size(), this.runtimeClasses.size(), this.runtimePackages.size()));
        return result.toString();
    }

    public boolean isEmpty() {
        return this.buildtimeClasses.isEmpty() && this.runtimeClasses.isEmpty();
    }

    public static InitializationDescriptor of(String jsonString) {
        try {
            return InitializationJsonMarshaller.read(jsonString);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read json:\n" + jsonString, e);
        }
    }
}

