/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.domain.resources;

import java.util.ArrayList;
import java.util.List;
import org.springframework.graalvm.domain.resources.ResourcesJsonMarshaller;

public class ResourcesDescriptor {
    private final List<String> patterns;
    private final List<String> bundles;

    public ResourcesDescriptor() {
        this.patterns = new ArrayList<String>();
        this.bundles = new ArrayList<String>();
    }

    public ResourcesDescriptor(ResourcesDescriptor metadata) {
        this.patterns = new ArrayList<String>(metadata.patterns);
        this.bundles = new ArrayList<String>(metadata.bundles);
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void add(String pattern) {
        this.patterns.add(pattern);
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public void addBundle(String name) {
        this.bundles.add(name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("ResourcesDescriptors Resources: #%s\n", this.patterns.size()));
        this.patterns.forEach(cd -> result.append(String.format("%s: \n", cd)));
        result.append(String.format("ResourcesDescriptors Bundles: #%s\n", this.bundles.size()));
        this.bundles.forEach(cd -> result.append(String.format("%s: \n", cd)));
        return result.toString();
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    public static ResourcesDescriptor of(String jsonString) {
        try {
            return ResourcesJsonMarshaller.read(jsonString);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read json:\n" + jsonString, e);
        }
    }
}

