/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.util.Map;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;
import org.springframework.graalvm.support.Mode;
import org.springframework.graalvm.type.TypeSystem;

public abstract class ConfigOptions {
    private static final boolean IGNORE_HINTS_ON_EXCLUDED_CONFIG;
    private static final boolean REMOVE_UNUSED_AUTOCONFIG;
    private static final boolean REMOVE_SPEL_SUPPORT;
    private static final boolean REMOVE_XML_SUPPORT;
    private static final boolean REMOVE_JMX_SUPPORT;
    private static final boolean REMOVE_YAML_SUPPORT;
    private static final String DUMP_CONFIG;
    private static final boolean VERBOSE;
    private static final boolean FAIL_ON_VERSION_CHECK;
    private static final String MISSING_SELECTOR_HINTS;
    private static final boolean VERIFIER_ON;
    private static final boolean SKIP_AT_BEAN_HINT_PROCESSING;
    private static final boolean SKIP_AT_BEAN_SIGNATURE_TYPES;
    private static Mode MODE;

    public static boolean shouldRemoveUnusedAutoconfig() {
        return REMOVE_UNUSED_AUTOCONFIG;
    }

    public static boolean areMissingSelectorHintsAnError() {
        return MISSING_SELECTOR_HINTS.equals("error");
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public static boolean shouldFailOnVersionCheck() {
        return FAIL_ON_VERSION_CHECK;
    }

    public static boolean isVerifierOn() {
        return VERIFIER_ON;
    }

    public static boolean shouldDumpConfig() {
        return DUMP_CONFIG != null;
    }

    public static boolean shouldRemoveYamlSupport() {
        return REMOVE_YAML_SUPPORT;
    }

    public static boolean shouldRemoveXmlSupport() {
        return REMOVE_XML_SUPPORT;
    }

    public static boolean shouldRemoveSpelSupport() {
        return REMOVE_SPEL_SUPPORT;
    }

    public static boolean shouldRemoveJmxSupport() {
        return REMOVE_JMX_SUPPORT;
    }

    public static boolean isInitMode() {
        return ConfigOptions.getMode() == Mode.INIT;
    }

    public static boolean isAgentMode() {
        return ConfigOptions.getMode() == Mode.AGENT;
    }

    public static boolean isAnnotationMode() {
        return ConfigOptions.getMode() == Mode.REFLECTION;
    }

    public static boolean isFunctionalMode() {
        return ConfigOptions.getMode() == Mode.FUNCTIONAL;
    }

    public static boolean isIgnoreHintsOnExcludedConfig() {
        return IGNORE_HINTS_ON_EXCLUDED_CONFIG;
    }

    public static String getDumpConfigLocation() {
        return DUMP_CONFIG;
    }

    public static boolean isSkipAtBeanHintProcessing() {
        return SKIP_AT_BEAN_HINT_PROCESSING;
    }

    public static boolean isSkipAtBeanSignatureTypes() {
        return SKIP_AT_BEAN_SIGNATURE_TYPES;
    }

    public static Mode getMode() {
        return MODE;
    }

    public static void ensureModeInitialized(Feature.DuringSetupAccess access) {
        if (MODE == null) {
            FeatureImpl.DuringSetupAccessImpl dsai = (FeatureImpl.DuringSetupAccessImpl)access;
            ImageClassLoader icl = dsai.getImageClassLoader();
            TypeSystem ts = TypeSystem.get(icl.getClasspath());
            if (ts.resolveDotted("org.springframework.init.func.InfrastructureInitializer", true) != null || ts.resolveDotted("org.springframework.fu.kofu.KofuApplication", true) != null || ts.resolveDotted("org.springframework.fu.jafu.JafuApplication", true) != null) {
                MODE = Mode.FUNCTIONAL;
            } else {
                Map<String, ReflectionDescriptor> reflectionConfigurationsOnClasspath = ts.getReflectionConfigurationsOnClasspath();
                for (ReflectionDescriptor reflectionDescriptor : reflectionConfigurationsOnClasspath.values()) {
                    if (!reflectionDescriptor.hasClassDescriptor("org.springframework.boot.autoconfigure.SpringBootApplication")) continue;
                    MODE = Mode.AGENT;
                    break;
                }
            }
            if (MODE == null) {
                MODE = Mode.REFLECTION;
            }
            System.out.println("Inferred feature operating mode: " + MODE.name().toLowerCase());
        }
    }

    static {
        String removeJmxSupport;
        String springXmlIgnore;
        String modeValue;
        IGNORE_HINTS_ON_EXCLUDED_CONFIG = Boolean.valueOf(System.getProperty("spring.native.ignore-hints-on-excluded-config", "true"));
        if (!IGNORE_HINTS_ON_EXCLUDED_CONFIG) {
            System.out.println("Currently not processing any spring.autoconfigure.exclude property in application.properties)");
        }
        if (SKIP_AT_BEAN_HINT_PROCESSING = Boolean.valueOf(System.getProperty("spring.native.skip-at-bean-hint-processing", "false")).booleanValue()) {
            System.out.println("Skipping @Bean hint processing");
        }
        if (SKIP_AT_BEAN_SIGNATURE_TYPES = Boolean.valueOf(System.getProperty("spring.native.skip-at-bean-signature-types-processing", "false")).booleanValue()) {
            System.out.println("Skipping @Bean signature type processing");
        }
        if ((modeValue = System.getProperty("spring.native.mode")) != null) {
            MODE = Mode.valueOf(modeValue.toUpperCase());
            if (MODE == null) {
                MODE = Mode.REFLECTION;
            }
            System.out.println("Feature operating in " + (Object)((Object)MODE) + " mode");
        }
        if (REMOVE_UNUSED_AUTOCONFIG = Boolean.valueOf(System.getProperty("spring.native.remove-unused-autoconfig", "true")).booleanValue()) {
            System.out.println("Removing unused configurations");
        }
        if (VERIFIER_ON = Boolean.valueOf(System.getProperty("spring.native.verify", "false")).booleanValue()) {
            System.out.println("Verification turned on");
        }
        if (VERBOSE = Boolean.valueOf(System.getProperty("spring.native.verbose", "false")).booleanValue()) {
            System.out.println("Turning on verbose mode for the feature");
        }
        if (!(FAIL_ON_VERSION_CHECK = Boolean.valueOf(System.getProperty("spring.native.fail-on-version-check", "true")).booleanValue())) {
            System.out.println("Turning off Spring Boot version check");
        }
        if ((MISSING_SELECTOR_HINTS = System.getProperty("spring.native.missing-selector-hints", "error")).equals("warning")) {
            System.out.println("Selectors missing hints will be reported as a warning, not an error");
        } else if (!MISSING_SELECTOR_HINTS.equals("error")) {
            throw new IllegalStateException("Supported values for 'spring.native.missing-selector-hints' are 'error' (default) or 'warning'");
        }
        REMOVE_YAML_SUPPORT = Boolean.valueOf(System.getProperty("spring.native.remove-yaml-support", "false"));
        if (REMOVE_YAML_SUPPORT) {
            System.out.println("Removing Yaml support");
        }
        if ((springXmlIgnore = System.getProperty("spring.xml.ignore")) == null) {
            springXmlIgnore = "true";
            System.setProperty("spring.xml.ignore", springXmlIgnore);
        }
        if (REMOVE_XML_SUPPORT = Boolean.valueOf(springXmlIgnore).booleanValue()) {
            System.out.println("Removing XML support");
        }
        if (REMOVE_SPEL_SUPPORT = Boolean.valueOf(System.getProperty("spring.spel.ignore", "false")).booleanValue()) {
            System.out.println("Removing SpEL support");
        }
        if ((removeJmxSupport = System.getProperty("spring.native.remove-jmx-support")) == null) {
            removeJmxSupport = "true";
            System.setProperty("spring.native.remove-jmx-support", removeJmxSupport);
        }
        if (REMOVE_JMX_SUPPORT = Boolean.valueOf(removeJmxSupport).booleanValue()) {
            System.out.println("Removing JMX support");
        }
        if ((DUMP_CONFIG = System.getProperty("spring.native.dump-config")) != null) {
            System.out.println("Dumping computed config to " + DUMP_CONFIG);
        }
    }
}

