/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.graalvm.extension.SpringFactoriesProcessor;

public class ConfigurableSpringFactoriesProcessor
implements SpringFactoriesProcessor {
    private static final String option = "spring.native.spring-factories-exclusions";
    private static final Map<String, List<String>> springFactoriesExclusions = new HashMap<String, List<String>>();

    @Override
    public boolean filter(URL springFactoryResource, String key, List<String> values) {
        boolean modified = false;
        for (Map.Entry<String, List<String>> exclusion : springFactoriesExclusions.entrySet()) {
            if (!exclusion.getKey().equals(key)) continue;
            modified = values.removeAll((Collection)exclusion.getValue()) || modified;
        }
        return modified;
    }

    static {
        String optionValue = System.getProperty(option, "");
        try {
            String[] exclusions;
            for (String exclusion : exclusions = optionValue.split(";")) {
                if (exclusion.trim().length() == 0) continue;
                int equals = exclusion.indexOf("=");
                if (equals == -1) {
                    throw new IllegalStateException("Problem in format of exclusions (expected 'a=b,c,d;d=e,f;g=i') : '" + optionValue + "'");
                }
                String key = exclusion.substring(0, equals);
                List<String> values = Arrays.asList(exclusion.substring(equals + 1).split(","));
                springFactoriesExclusions.put(key, values);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to process spring.native.spring-factories-exclusions: " + springFactoriesExclusions, t);
        }
        if (springFactoriesExclusions.size() > 0) {
            System.out.println("The following map of spring.factories entries will be removed if encountered: " + springFactoriesExclusions);
        }
    }
}

