/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.domain.init.InitializationJsonMarshaller;
import org.springframework.graalvm.support.ConfigOptions;
import org.springframework.graalvm.support.SpringFeature;
import org.springframework.graalvm.type.TypeSystem;

public class InitializationHandler {
    private ImageClassLoader cl;
    private TypeSystem ts;

    public InitializationDescriptor compute() {
        try {
            InputStream s = this.getClass().getResourceAsStream("/initialization.json");
            return InitializationJsonMarshaller.read(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void register(Feature.BeforeAnalysisAccess access) {
        this.cl = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getImageClassLoader();
        this.ts = TypeSystem.get(this.cl.getClasspath());
        InitializationDescriptor id = this.compute();
        System.out.println("Configuring initialization time for specific types and packages:");
        if (id == null) {
            throw new IllegalStateException("Unable to load initialization descriptor");
        }
        System.out.println(id.toString());
        List<Class> collect = id.getBuildtimeClasses().stream().map(arg_0 -> ((Feature.BeforeAnalysisAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        RuntimeClassInitialization.initializeAtBuildTime((Class[])collect.toArray(new Class[0]));
        id.getRuntimeClasses().stream().map(arg_0 -> ((Feature.BeforeAnalysisAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
        SpringFeature.log("Registering these packages for buildtime initialization: \n" + id.getBuildtimePackages());
        RuntimeClassInitialization.initializeAtBuildTime((String[])id.getBuildtimePackages().toArray(new String[0]));
        SpringFeature.log("Registering these packages for runtime initialization: \n" + id.getRuntimePackages());
        RuntimeClassInitialization.initializeAtRunTime((String[])id.getRuntimePackages().toArray(new String[0]));
        if (ConfigOptions.isVerifierOn()) {
            for (Map.Entry<String, List<String>> e : this.ts.getSpringClassesMakingIsPresentChecks().entrySet()) {
                String k = e.getKey();
                if (id.getBuildtimeClasses().contains(k)) continue;
                System.out.println("[verification] The type " + k + " is making isPresent() calls in the static initializer, could be worth specifying build-time-initialization. It appears to be making isPresent() checks on " + e.getValue());
            }
        }
    }

    public void registerInitializationDescriptor(InitializationDescriptor initializationDescriptor) {
        List<String> runtimePackages;
        List<String> buildtimePackages;
        List<String> runtimeClasses;
        List<String> buildtimeClasses = initializationDescriptor.getBuildtimeClasses();
        if (buildtimeClasses.size() != 0) {
            buildtimeClasses.stream().map(c -> this.cl.findClassByName(c, false)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{xva$0}));
        }
        if ((runtimeClasses = initializationDescriptor.getRuntimeClasses()).size() != 0) {
            runtimeClasses.stream().map(c -> this.cl.findClassByName(c, false)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
        }
        if ((buildtimePackages = initializationDescriptor.getBuildtimePackages()).size() != 0) {
            RuntimeClassInitialization.initializeAtBuildTime((String[])buildtimePackages.toArray(new String[0]));
        }
        if ((runtimePackages = initializationDescriptor.getRuntimePackages()).size() != 0) {
            RuntimeClassInitialization.initializeAtRunTime((String[])runtimePackages.toArray(new String[0]));
        }
    }
}

