/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.type.ProxyDescriptor;
import org.springframework.graalvm.type.ResourcesDescriptor;

public class RequestedConfigurationManager {
    private Map<String, Integer> requestedTypeAccesses = new HashMap<String, Integer>();
    private List<ProxyDescriptor> requestedProxies = new ArrayList<ProxyDescriptor>();
    private List<ResourcesDescriptor> requestedResources = new ArrayList<ResourcesDescriptor>();
    private List<InitializationDescriptor> requestedInitializations = new ArrayList<InitializationDescriptor>();

    public void requestTypeAccess(String type, Integer accessRequired) {
        if (type.indexOf("/") != -1) {
            throw new IllegalStateException("Only pass dotted names to request(), name was: " + type);
        }
        Integer existsAlready = this.requestedTypeAccesses.get(type);
        if (existsAlready != null) {
            this.requestedTypeAccesses.put(type, existsAlready | accessRequired);
        } else {
            this.requestedTypeAccesses.put(type, accessRequired);
        }
    }

    public void requestProxyDescriptors(List<ProxyDescriptor> proxyDescriptors) {
        this.requestedProxies.addAll(proxyDescriptors);
    }

    public void requestResourcesDescriptors(List<ResourcesDescriptor> resourcesDescriptors) {
        this.requestedResources.addAll(resourcesDescriptors);
    }

    public void requestInitializationDescriptors(List<InitializationDescriptor> initializationDescriptors) {
        this.requestedInitializations.addAll(initializationDescriptors);
    }

    public Set<Map.Entry<String, Integer>> getRequestedTypeAccesses() {
        return this.requestedTypeAccesses.entrySet();
    }

    public List<ProxyDescriptor> getRequestedProxies() {
        return this.requestedProxies;
    }

    public List<ResourcesDescriptor> getRequestedResources() {
        return this.requestedResources;
    }

    public List<InitializationDescriptor> getRequestedInitializations() {
        return this.requestedInitializations;
    }
}

