/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.domain.reflect.Flag;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;
import org.springframework.graalvm.domain.resources.ResourcesJsonMarshaller;
import org.springframework.graalvm.extension.ComponentProcessor;
import org.springframework.graalvm.extension.NativeImageContext;
import org.springframework.graalvm.extension.SpringFactoriesProcessor;
import org.springframework.graalvm.support.ConfigOptions;
import org.springframework.graalvm.support.DynamicProxiesHandler;
import org.springframework.graalvm.support.InitializationHandler;
import org.springframework.graalvm.support.Mode;
import org.springframework.graalvm.support.ReflectionHandler;
import org.springframework.graalvm.support.RequestedConfigurationManager;
import org.springframework.graalvm.support.SpringFeature;
import org.springframework.graalvm.support.Utils;
import org.springframework.graalvm.type.AccessBits;
import org.springframework.graalvm.type.AccessDescriptor;
import org.springframework.graalvm.type.CompilationHint;
import org.springframework.graalvm.type.Hint;
import org.springframework.graalvm.type.Method;
import org.springframework.graalvm.type.MissingTypeException;
import org.springframework.graalvm.type.ProxyDescriptor;
import org.springframework.graalvm.type.ResourcesDescriptor;
import org.springframework.graalvm.type.Type;
import org.springframework.graalvm.type.TypeSystem;

public class ResourcesHandler {
    private static final String enableAutoconfigurationKey = "org.springframework.boot.autoconfigure.EnableAutoConfiguration";
    private static final String propertySourceLoaderKey = "org.springframework.boot.env.PropertySourceLoader";
    private static final String managementContextConfigurationKey = "org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration";
    private TypeSystem ts;
    private ImageClassLoader cl;
    private ReflectionHandler reflectionHandler;
    private ResourcesRegistry resourcesRegistry;
    private DynamicProxiesHandler dynamicProxiesHandler;
    private InitializationHandler initializationHandler;

    public ResourcesHandler(ReflectionHandler reflectionHandler, DynamicProxiesHandler dynamicProxiesHandler, InitializationHandler initializationHandler) {
        this.reflectionHandler = reflectionHandler;
        this.dynamicProxiesHandler = dynamicProxiesHandler;
        this.initializationHandler = initializationHandler;
    }

    public org.springframework.graalvm.domain.resources.ResourcesDescriptor readStaticResourcesConfiguration() {
        try {
            InputStream s = this.getClass().getResourceAsStream("/resources.json");
            org.springframework.graalvm.domain.resources.ResourcesDescriptor resourcesDescriptor = ResourcesJsonMarshaller.read(s);
            return resourcesDescriptor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void register(Feature.BeforeAnalysisAccess access) {
        this.cl = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getImageClassLoader();
        this.ts = TypeSystem.get(this.cl.getClasspath());
        this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        org.springframework.graalvm.domain.resources.ResourcesDescriptor rd = this.readStaticResourcesConfiguration();
        if (ConfigOptions.isFunctionalMode() || ConfigOptions.isAnnotationMode() || ConfigOptions.isAgentMode()) {
            System.out.println("Registering statically declared resources - #" + rd.getPatterns().size() + " patterns");
            this.registerPatterns(rd);
            this.registerResourceBundles(rd);
        }
        if (ConfigOptions.isAnnotationMode() || ConfigOptions.isAgentMode()) {
            this.processSpringFactories();
        }
        if (!ConfigOptions.isInitMode()) {
            this.handleSpringConstantHints();
        }
        this.handleSpringConstantInitialiationHints();
        if (ConfigOptions.isAnnotationMode() || ConfigOptions.isAgentMode() || ConfigOptions.isFunctionalMode()) {
            this.handleSpringComponents();
        }
    }

    private void registerPatterns(org.springframework.graalvm.domain.resources.ResourcesDescriptor rd) {
        for (String pattern : rd.getPatterns()) {
            if (pattern.equals("META-INF/spring.factories")) continue;
            this.resourcesRegistry.addResources(pattern);
        }
    }

    private void registerResourceBundles(org.springframework.graalvm.domain.resources.ResourcesDescriptor rd) {
        System.out.println("Registering resources - #" + rd.getBundles().size() + " bundles");
        for (String bundle : rd.getBundles()) {
            try {
                ResourceBundle.getBundle(bundle);
                this.resourcesRegistry.addResourceBundles(bundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
    }

    private void handleSpringConstantHints() {
        List<CompilationHint> constantHints = this.ts.findActiveDefaultHints();
        SpringFeature.log("Registering fixed hints: " + constantHints);
        for (CompilationHint ch : constantHints) {
            if (!this.isHintValidForCurrentMode(ch)) continue;
            Map<String, AccessDescriptor> dependantTypes = ch.getDependantTypes();
            for (Map.Entry<String, AccessDescriptor> entry : dependantTypes.entrySet()) {
                SpringFeature.log("  fixed type registered " + entry.getKey());
                this.reflectionHandler.addAccess(entry.getKey(), null, null, true, AccessBits.getFlags(entry.getValue().getAccessBits()));
            }
            List<ProxyDescriptor> proxyDescriptors = ch.getProxyDescriptors();
            for (ProxyDescriptor pd : proxyDescriptors) {
                this.dynamicProxiesHandler.addProxy(pd);
            }
            List<ResourcesDescriptor> list = ch.getResourcesDescriptors();
            for (ResourcesDescriptor rd : list) {
                this.registerResourcesDescriptor(rd);
            }
        }
    }

    private void handleSpringConstantInitialiationHints() {
        List<CompilationHint> constantHints = this.ts.findHints("java.lang.Object");
        SpringFeature.log("Registering fixed initialization entries: ");
        for (CompilationHint ch : constantHints) {
            List<InitializationDescriptor> ids = ch.getInitializationDescriptors();
            for (InitializationDescriptor id : ids) {
                SpringFeature.log(" registering initialization descriptor: " + id);
                this.initializationHandler.registerInitializationDescriptor(id);
            }
        }
    }

    public void registerResourcesDescriptor(ResourcesDescriptor rd) {
        String[] patterns;
        for (String pattern : patterns = rd.getPatterns()) {
            if (rd.isBundle()) {
                try {
                    this.resourcesRegistry.addResourceBundles(pattern);
                }
                catch (MissingResourceException mre) {
                    SpringFeature.log("WARNING: resource bundle " + pattern + " could not be registered");
                }
                continue;
            }
            this.resourcesRegistry.addResources(pattern);
        }
    }

    public void handleSpringComponents() {
        NativeImageContextImpl context = new NativeImageContextImpl();
        Enumeration<URL> springComponents = this.fetchResources("META-INF/spring.components");
        ArrayList<String> alreadyProcessed = new ArrayList<String>();
        if (springComponents.hasMoreElements()) {
            this.log("Processing existing META-INF/spring.components files...");
            while (springComponents.hasMoreElements()) {
                URL springFactory = springComponents.nextElement();
                Properties p = new Properties();
                this.loadSpringFactoryFile(springFactory, p);
                if (ConfigOptions.isAgentMode()) {
                    this.processSpringComponentsHybrid(p, context);
                    continue;
                }
                if (ConfigOptions.isFunctionalMode()) {
                    this.processSpringComponentsFunc(p, context, alreadyProcessed);
                    continue;
                }
                this.processSpringComponents(p, context, alreadyProcessed);
            }
        } else {
            this.log("Found no META-INF/spring.components -> synthesizing one...");
            Properties p = this.synthesizeSpringComponents();
            if (ConfigOptions.isAgentMode()) {
                this.processSpringComponentsHybrid(p, context);
            } else if (ConfigOptions.isFunctionalMode()) {
                this.processSpringComponentsFunc(p, context, alreadyProcessed);
            } else {
                this.processSpringComponents(p, context, alreadyProcessed);
            }
        }
    }

    private Properties synthesizeSpringComponents() {
        Properties p = new Properties();
        List<Map.Entry<Type, List<Type>>> components = this.scanForSpringComponents();
        List<Map.Entry<Type, List<Type>>> filteredComponents = this.filterOutNestedTypes(components);
        for (Map.Entry<Type, List<Type>> filteredComponent : filteredComponents) {
            String k = filteredComponent.getKey().getDottedName();
            p.put(k, filteredComponent.getValue().stream().map(t -> t.getDottedName()).collect(Collectors.joining(",")));
        }
        System.out.println("Computed spring.components is ");
        System.out.println("vvv");
        for (Object k : p.keySet()) {
            System.out.println(k + "=" + p.getProperty((String)k));
        }
        System.out.println("^^^");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            p.store(baos, "");
            baos.close();
            byte[] bs = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bs);
            Resources.registerResource((String)"META-INF/spring.components", (InputStream)bais);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return p;
    }

    private void processSpringComponentsFunc(Properties p, NativeImageContext context, List<String> alreadyProcessed) {
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            Type keyType;
            String key = (String)keys.nextElement();
            String valueString = (String)p.get(key);
            if (valueString.equals("package-info") || !(keyType = this.ts.resolveDotted(key)).isAtConfiguration()) continue;
            this.checkAndRegisterConfigurationType(key);
        }
    }

    private void processSpringComponentsHybrid(Properties p, NativeImageContext context) {
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String valueString = (String)p.get(key);
            if (valueString.equals("package-info")) continue;
            Type keyType = this.ts.resolveDotted(key);
            if (keyType.isAtSpringBootApplication()) {
                System.out.println("hybrid: adding access to " + keyType + " since @SpringBootApplication");
                this.reflectionHandler.addAccess(key, Flag.allDeclaredMethods, Flag.allDeclaredFields, Flag.allDeclaredConstructors);
                this.resourcesRegistry.addResources(key.replace(".", "/") + ".class");
            }
            if (!keyType.isAtController()) continue;
            System.out.println("hybrid: Processing controller " + key);
            List<Method> mappings = keyType.getMethods(m -> m.isAtMapping());
            for (Method mapping : mappings) {
                for (int pi = 0; pi < mapping.getParameterCount(); ++pi) {
                    List<Type> parameterAnnotationTypes = mapping.getParameterAnnotationTypes(pi);
                    for (Type parameterAnnotationType : parameterAnnotationTypes) {
                        if (!parameterAnnotationType.hasAliasForMarkedMembers()) continue;
                        ArrayList<String> interfaces = new ArrayList<String>();
                        interfaces.add(parameterAnnotationType.getDottedName());
                        interfaces.add("org.springframework.core.annotation.SynthesizedAnnotation");
                        System.out.println("Adding dynamic proxy for " + interfaces);
                        this.dynamicProxiesHandler.addProxy(interfaces);
                    }
                }
            }
        }
    }

    private void processSpringComponents(Properties p, NativeImageContext context, List<String> alreadyProcessed) {
        List<ComponentProcessor> componentProcessors = this.ts.getComponentProcessors();
        Enumeration<Object> keys = p.keys();
        int registeredComponents = 0;
        RequestedConfigurationManager requestor = new RequestedConfigurationManager();
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        while (keys.hasMoreElements()) {
            boolean isComponent = false;
            String k = (String)keys.nextElement();
            String vs = (String)p.get(k);
            if (vs.equals("package-info") || alreadyProcessed.contains(k + ":" + vs)) continue;
            alreadyProcessed.add(k + ":" + vs);
            Type kType = this.ts.resolveDotted(k);
            SpringFeature.log("Registering Spring Component: " + k);
            ++registeredComponents;
            Map.Entry<Type, List<Type>> metaAnnotated = kType.getMetaComponentTaggedAnnotations();
            if (metaAnnotated != null) {
                for (Type t : metaAnnotated.getValue()) {
                    String name = t.getDottedName();
                    this.reflectionHandler.addAccess(name, Flag.allDeclaredMethods);
                    resourcesRegistry.addResources(name.replace(".", "/") + ".class");
                }
            }
            if (kType.isAtConfiguration()) {
                this.checkAndRegisterConfigurationType(k);
            } else {
                try {
                    this.reflectionHandler.addAccess(k, Flag.allDeclaredConstructors, Flag.allDeclaredMethods, Flag.allDeclaredClasses, Flag.allDeclaredFields);
                    resourcesRegistry.addResources(k.replace(".", "/") + ".class");
                    for (Type t : kType.getNestedTypes()) {
                        String n = t.getName().replace("/", ".");
                        this.reflectionHandler.addAccess(n, Flag.allDeclaredConstructors, Flag.allDeclaredMethods, Flag.allDeclaredClasses);
                        resourcesRegistry.addResources(t.getName() + ".class");
                    }
                    this.registerHierarchy(kType, requestor);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (kType != null && kType.isAtRepository()) {
                this.processRepository2(kType);
            }
            if (kType != null && kType.isAtResponseBody()) {
                this.processResponseBodyComponent(kType);
            }
            ArrayList<String> values = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(vs, ",");
            while (st.hasMoreElements()) {
                String tt = st.nextToken();
                values.add(tt);
                if (tt.equals("org.springframework.stereotype.Component")) {
                    isComponent = true;
                }
                try {
                    Type baseType = this.ts.resolveDotted(tt);
                    this.reflectionHandler.addAccess(tt, Flag.allDeclaredMethods);
                    resourcesRegistry.addResources(tt.replace(".", "/") + ".class");
                    for (Type t : baseType.getNestedTypes()) {
                        String n = t.getName().replace("/", ".");
                        this.reflectionHandler.addAccess(n, Flag.allDeclaredMethods);
                        resourcesRegistry.addResources(t.getName() + ".class");
                    }
                    this.registerHierarchy(baseType, requestor);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.out.println("Problems with value " + tt);
                }
            }
            if (isComponent && ConfigOptions.isVerifierOn()) {
                kType.verifyComponent();
            }
            for (ComponentProcessor componentProcessor : componentProcessors) {
                if (!componentProcessor.handle(context, k, values)) continue;
                componentProcessor.process(context, k, values);
            }
        }
        this.registerAllRequested(0, requestor);
        componentProcessors.forEach(ComponentProcessor::printSummary);
        System.out.println("Registered " + registeredComponents + " entries");
    }

    private void processResponseBodyComponent(Type t) {
        Collection<Type> returnTypes = t.collectAtMappingMarkedReturnTypes();
        SpringFeature.log("Found these return types from Mapped methods in " + t.getName() + " > " + returnTypes);
        for (Type returnType : returnTypes) {
            if (returnType == null) continue;
            this.reflectionHandler.addAccess(returnType.getDottedName(), Flag.allDeclaredMethods, Flag.allDeclaredConstructors, Flag.allDeclaredFields);
        }
    }

    private void processRepository2(Type r) {
        SpringFeature.log("Processing @oss.Repository annotated " + r.getDottedName());
        ArrayList<String> repositoryInterfaces = new ArrayList<String>();
        for (String s : r.getInterfacesStrings()) {
            repositoryInterfaces.add(s.replace("/", "."));
        }
        repositoryInterfaces.add("org.springframework.aop.SpringProxy");
        repositoryInterfaces.add("org.springframework.aop.framework.Advised");
        repositoryInterfaces.add("org.springframework.core.DecoratingProxy");
        this.dynamicProxiesHandler.addProxy(repositoryInterfaces);
    }

    public void registerHierarchy(Type type, RequestedConfigurationManager typesToMakeAccessible) {
        AccessBits accessRequired = AccessBits.forValue(Type.inferAccessRequired(type));
        this.registerHierarchyHelper(type, new HashSet<Type>(), typesToMakeAccessible, accessRequired);
    }

    private void registerHierarchyHelper(Type type, Set<Type> visited, RequestedConfigurationManager typesToMakeAccessible, AccessBits inferredRequiredAccess) {
        if (typesToMakeAccessible == null) {
            throw new IllegalStateException();
        }
        if (type == null || !visited.add(type)) {
            return;
        }
        if (type.isCondition()) {
            if (type.hasOnlySimpleConstructor()) {
                typesToMakeAccessible.requestTypeAccess(type.getDottedName(), inferredRequiredAccess.getValue());
            } else {
                typesToMakeAccessible.requestTypeAccess(type.getDottedName(), inferredRequiredAccess.getValue());
            }
        } else {
            typesToMakeAccessible.requestTypeAccess(type.getDottedName(), 13);
        }
        List<String> relatedTypes = type.getTypesInSignature();
        for (String relatedType : relatedTypes) {
            Type t = this.ts.resolveSlashed(relatedType, true);
            if (t == null) continue;
            this.registerHierarchyHelper(t, visited, typesToMakeAccessible, inferredRequiredAccess);
        }
    }

    public void processSpringFactories() {
        this.log("Processing META-INF/spring.factories files...");
        Enumeration<URL> springFactories = this.fetchResources("META-INF/spring.factories");
        while (springFactories.hasMoreElements()) {
            URL springFactory = springFactories.nextElement();
            this.processSpringFactory(this.ts, springFactory);
        }
    }

    private List<Map.Entry<Type, List<Type>>> filterOutNestedTypes(List<Map.Entry<Type, List<Type>>> springComponents) {
        ArrayList<Map.Entry<Type, List<Type>>> filtered = new ArrayList<Map.Entry<Type, List<Type>>>();
        ArrayList subtypesToRemove = new ArrayList();
        for (Map.Entry<Type, List<Type>> a : springComponents) {
            String type = a.getKey().getDottedName();
            subtypesToRemove.addAll(springComponents.stream().filter(e -> ((Type)e.getKey()).getDottedName().startsWith(type + "$")).collect(Collectors.toList()));
        }
        filtered.addAll(springComponents);
        filtered.removeAll(subtypesToRemove);
        return filtered;
    }

    private List<Map.Entry<Type, List<Type>>> scanForSpringComponents() {
        return this.findDirectoriesOrTargetDirJar(this.ts.getClasspath()).flatMap(this::findClasses).map(this::typenameOfClass).map(this::getStereoTypesOnType).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map.Entry<Type, List<Type>> getStereoTypesOnType(String slashedClassname) {
        return this.ts.resolveSlashed(slashedClassname).getRelevantStereotypes();
    }

    private String typenameOfClass(Path p) {
        return Utils.scanClass(p).getClassname();
    }

    private Stream<Path> findClasses(Path path) {
        ArrayList<Path> classfiles = new ArrayList<Path>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.walk(path, classfiles);
        } else {
            this.walkJar(path, classfiles);
        }
        return classfiles.stream();
    }

    private void walkJar(Path jarfile, ArrayList<Path> classfiles) {
        try {
            FileSystem jarfs = FileSystems.newFileSystem(jarfile, null);
            Iterable<Path> rootDirectories = jarfs.getRootDirectories();
            ClassCollectorFileVisitor x = new ClassCollectorFileVisitor();
            for (Path path : rootDirectories) {
                Files.walkFileTree(path, x);
            }
            classfiles.addAll(x.getClassFiles());
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem opening " + jarfile, e);
        }
    }

    private void walk(Path dir, ArrayList<Path> classfiles) {
        try {
            ClassCollectorFileVisitor x = new ClassCollectorFileVisitor();
            Files.walkFileTree(dir, x);
            classfiles.addAll(x.getClassFiles());
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem walking directory " + dir, e);
        }
    }

    private Stream<Path> findDirectoriesOrTargetDirJar(List<String> classpath) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (String classpathEntry : classpath) {
            File f = new File(classpathEntry);
            if (f.isDirectory()) {
                result.add(Paths.get(f.toURI()));
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".jar") || !f.getParent().endsWith(File.separator + "target")) continue;
            result.add(Paths.get(f.toURI()));
        }
        return result.stream();
    }

    private void registerTypeReferencedBySpringFactoriesKey(String s) {
        try {
            Type t = this.ts.resolveDotted(s, true);
            if (t != null) {
                String name = t.getDottedName();
                if (t.hasOnlySimpleConstructor()) {
                    this.reflectionHandler.addAccess(name, new String[][]{{"<init>"}}, null, false, new Flag[0]);
                } else {
                    this.reflectionHandler.addAccess(name, Flag.allDeclaredConstructors);
                }
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            System.out.println("spring.factories processing, problem adding access for key " + s + ": " + ncdfe.getMessage());
        }
    }

    private void processSpringFactory(TypeSystem ts, URL springFactory) {
        String existingRC;
        String propertySourceLoaderValues;
        List<SpringFactoriesProcessor> springFactoriesProcessors = ts.getSpringFactoryProcessors();
        ArrayList<String> forRemoval = new ArrayList<String>();
        Properties p = new Properties();
        this.loadSpringFactoryFile(springFactory, p);
        int excludedAutoConfigCount = 0;
        Enumeration<Object> factoryKeys = p.keys();
        boolean modified = false;
        if (!ConfigOptions.isAgentMode()) {
            Properties filteredProperties = new Properties();
            for (Map.Entry<Object, Object> factoriesEntry : p.entrySet()) {
                String key = (String)factoriesEntry.getKey();
                String valueString = (String)factoriesEntry.getValue();
                ArrayList<String> values = new ArrayList<String>();
                for (String value : valueString.split(",")) {
                    values.add(value);
                }
                for (SpringFactoriesProcessor springFactoriesProcessor : springFactoriesProcessors) {
                    if (!springFactoriesProcessor.filter(springFactory, key, values)) continue;
                    modified = true;
                }
                if (modified) {
                    filteredProperties.put(key, String.join((CharSequence)",", values));
                    continue;
                }
                filteredProperties.put(key, valueString);
            }
            p = filteredProperties;
        }
        factoryKeys = p.keys();
        if (!ConfigOptions.isAgentMode()) {
            while (factoryKeys.hasMoreElements()) {
                String k = (String)factoryKeys.nextElement();
                SpringFeature.log("Adding all the classes for this key: " + k);
                if (k.equals(enableAutoconfigurationKey) || k.equals(propertySourceLoaderKey) || k.equals(managementContextConfigurationKey)) continue;
                if (ts.shouldBeProcessed(k)) {
                    for (String v : p.getProperty(k).split(",")) {
                        this.registerTypeReferencedBySpringFactoriesKey(v);
                    }
                    continue;
                }
                SpringFeature.log("Skipping processing spring.factories key " + k + " due to missing guard types");
            }
        }
        if (!ConfigOptions.isAgentMode() && (propertySourceLoaderValues = (String)p.get(propertySourceLoaderKey)) != null) {
            ArrayList<String> propertySourceLoaders = new ArrayList<String>();
            for (String s : propertySourceLoaderValues.split(",")) {
                if (!s.equals("org.springframework.boot.env.YamlPropertySourceLoader") || !ConfigOptions.shouldRemoveYamlSupport()) {
                    this.registerTypeReferencedBySpringFactoriesKey(s);
                    propertySourceLoaders.add(s);
                    continue;
                }
                forRemoval.add(s);
            }
            System.out.println("Processing spring.factories - PropertySourceLoader lists #" + propertySourceLoaders.size() + " property source loaders");
            SpringFeature.log("These property source loaders are remaining in the PropertySourceLoader key value:");
            for (int c = 0; c < propertySourceLoaders.size(); ++c) {
                SpringFeature.log(c + 1 + ") " + (String)propertySourceLoaders.get(c));
            }
            p.put(propertySourceLoaderKey, String.join((CharSequence)",", propertySourceLoaders));
        }
        modified = this.processConfigurationsWithKey(p, managementContextConfigurationKey) || modified;
        String enableAutoConfigurationValues = (String)p.get(enableAutoconfigurationKey);
        if (enableAutoConfigurationValues != null) {
            ArrayList<String> configurations = new ArrayList<String>();
            for (String s : enableAutoConfigurationValues.split(",")) {
                configurations.add(s);
            }
            System.out.println("Processing spring.factories - EnableAutoConfiguration lists #" + configurations.size() + " configurations");
            for (String config : configurations) {
                if (this.checkAndRegisterConfigurationType(config) || !ConfigOptions.shouldRemoveUnusedAutoconfig()) continue;
                ++excludedAutoConfigCount;
                SpringFeature.log("Excluding auto-configuration " + config);
                forRemoval.add(config);
            }
            if (ConfigOptions.shouldRemoveUnusedAutoconfig()) {
                System.out.println("Excluding " + excludedAutoConfigCount + " auto-configurations from spring.factories file");
                configurations.removeAll(forRemoval);
                p.put(enableAutoconfigurationKey, String.join((CharSequence)",", configurations));
                SpringFeature.log("These configurations are remaining in the EnableAutoConfiguration key value:");
                for (int c = 0; c < configurations.size(); ++c) {
                    SpringFeature.log(c + 1 + ") " + (String)configurations.get(c));
                }
            }
        }
        if (forRemoval.size() > 0 && (existingRC = ts.findAnyResourceConfigIncludingSpringFactoriesPattern()) != null) {
            System.out.println("WARNING: unable to trim META-INF/spring.factories (for example to disable unused auto configurations) because an existing resource-config is directly including it: " + existingRC);
            return;
        }
        try {
            if (forRemoval.size() == 0 && !modified) {
                Resources.registerResource((String)"META-INF/spring.factories", (InputStream)springFactory.openStream());
            } else {
                SpringFeature.log("  removed " + forRemoval.size() + " classes");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                p.store(baos, "");
                baos.close();
                byte[] bs = baos.toByteArray();
                SpringFeature.log("The new spring.factories is: vvvvvvvvv");
                SpringFeature.log(new String(bs));
                SpringFeature.log("^^^^^^^^");
                ByteArrayInputStream bais = new ByteArrayInputStream(bs);
                Resources.registerResource((String)"META-INF/spring.factories", (InputStream)bais);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean processConfigurationsWithKey(Properties p, String configurationsKey) {
        boolean modified = false;
        ArrayList<String> inactiveConfigurations = new ArrayList<String>();
        String configurationsValue = (String)p.get(configurationsKey);
        if (configurationsValue != null) {
            List configurations = Stream.of(configurationsValue.split(",")).collect(Collectors.toList());
            for (String configuration : configurations) {
                if (this.checkAndRegisterConfigurationType(configuration) || !ConfigOptions.shouldRemoveUnusedAutoconfig()) continue;
                SpringFeature.log("Excluding auto-configuration (key=" + configurationsKey + ") =" + configuration);
                inactiveConfigurations.add(configuration);
            }
            if (ConfigOptions.shouldRemoveUnusedAutoconfig() && inactiveConfigurations.size() > 0) {
                int totalConfigurations = configurations.size();
                configurations.removeAll(inactiveConfigurations);
                p.put(configurationsKey, String.join((CharSequence)",", configurations));
                SpringFeature.log("Removed " + inactiveConfigurations.size() + " of the " + totalConfigurations + " configurations specified for the key " + configurationsKey);
                modified = true;
            }
        }
        return modified;
    }

    private void loadSpringFactoryFile(URL springFactory, Properties p) {
        try (InputStream is = springFactory.openStream();){
            p.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load spring.factories", e);
        }
    }

    private boolean checkAndRegisterConfigurationType(String name) {
        return this.processType(name, new HashSet<String>());
    }

    private boolean processType(String config, Set<String> visited) {
        SpringFeature.log("\n\nProcessing configuration type " + config);
        Type resolvedConfigType = this.ts.resolveDotted(config, true);
        if (resolvedConfigType == null) {
            SpringFeature.log("Configuration type " + config + " is missing - presuming stripped out - considered failed validation");
            return false;
        }
        boolean b = this.processType(resolvedConfigType, visited, 0);
        SpringFeature.log("Configuration type " + config + " has " + (b ? "passed" : "failed") + " validation");
        return b;
    }

    private boolean registerSpecific(String typename, Integer typeKind, RequestedConfigurationManager rcm) {
        Type t = this.ts.resolveDotted(typename, true);
        if (t == null) {
            SpringFeature.log("WARNING: Unable to resolve specific type: " + typename);
            return false;
        }
        boolean importRegistrarOrSelector = false;
        try {
            importRegistrarOrSelector = t.isImportRegistrar() || t.isImportSelector();
        }
        catch (MissingTypeException mte) {
            return false;
        }
        if (importRegistrarOrSelector) {
            rcm.requestTypeAccess(typename, 6);
        } else {
            if (AccessBits.isResourceAccessRequired(typeKind)) {
                rcm.requestTypeAccess(typename, 1);
                rcm.requestTypeAccess(typename, typeKind);
            } else {
                rcm.requestTypeAccess(typename, typeKind);
            }
            if (t.isAtConfiguration()) {
                this.registerHierarchy(t, rcm);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processType(Type type, Set<String> visited, int depth) {
        List<Object> hints;
        Set<String> missingAnnotationTypes;
        SpringFeature.log(this.spaces(depth) + "Analyzing " + type.getDottedName());
        if (ConfigOptions.shouldRemoveJmxSupport() && type.getDottedName().toLowerCase().contains("jmx")) {
            return false;
        }
        Set<String> missingTypes = this.ts.findMissingTypesInHierarchyOfThisType(type);
        if (!missingTypes.isEmpty()) {
            SpringFeature.log(this.spaces(depth) + "for " + type.getName() + " missing types are " + missingTypes);
            if (ConfigOptions.shouldRemoveUnusedAutoconfig()) {
                return false;
            }
        }
        if (!(missingAnnotationTypes = this.ts.resolveCompleteFindMissingAnnotationTypes(type)).isEmpty()) {
            SpringFeature.log(this.spaces(depth) + "for " + type.getName() + " missing annotation types are " + missingAnnotationTypes);
        }
        if (ConfigOptions.isIgnoreHintsOnExcludedConfig() && type.isAtConfiguration() && this.isIgnored(type)) {
            SpringFeature.log("INFO: skipping hints on " + type.getName() + " because it is excluded in this application");
            return true;
        }
        boolean passesTests = true;
        RequestedConfigurationManager accessRequestor = new RequestedConfigurationManager();
        List<Object> list = hints = passesTests ? type.getHints() : Collections.emptyList();
        if (hints.size() != 0) {
            SpringFeature.log(this.spaces(depth) + hints.size() + " hints on " + type.getDottedName() + " are: ");
            for (int h = 0; h < hints.size(); ++h) {
                SpringFeature.log(this.spaces(depth) + (h + 1) + ") " + hints.get(h));
            }
        } else {
            SpringFeature.log(this.spaces(depth) + "no hints on " + type.getName());
        }
        ArrayList<Type> toFollow = new ArrayList<Type>();
        if (!hints.isEmpty()) {
            block5: for (Hint hint : hints) {
                Map<String, Integer> map;
                Map<String, AccessDescriptor> map2;
                SpringFeature.log(this.spaces(depth) + "processing hint " + hint);
                boolean hintExplicitReferencesValidInCurrentMode = this.isHintValidForCurrentMode(hint);
                if (hintExplicitReferencesValidInCurrentMode && (map2 = hint.getSpecificTypes()).size() > 0) {
                    SpringFeature.log(this.spaces(depth) + "attempting registration of " + map2.size() + " specific types");
                    for (Map.Entry<String, Object> entry : map2.entrySet()) {
                        String specificTypeName = entry.getKey();
                        if (!this.registerSpecific(specificTypeName, ((AccessDescriptor)entry.getValue()).getAccessBits(), accessRequestor)) {
                            if (!hint.isSkipIfTypesMissing()) continue;
                            passesTests = false;
                            if (!ConfigOptions.shouldRemoveUnusedAutoconfig()) continue;
                            break;
                        }
                        if (!hint.isFollow()) continue;
                        SpringFeature.log(this.spaces(depth) + "will follow specific type reference " + specificTypeName);
                        toFollow.add(this.ts.resolveDotted(specificTypeName));
                    }
                }
                if ((map = hint.getInferredTypes()).size() > 0) {
                    SpringFeature.log(this.spaces(depth) + "attempting registration of " + map.size() + " inferred types");
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        boolean exists;
                        String s = entry.getKey();
                        Type t = this.ts.resolveDotted(s, true);
                        boolean bl = exists = t != null;
                        if (!exists) {
                            SpringFeature.log(this.spaces(depth) + "inferred type " + s + " not found");
                        }
                        if (exists) {
                            accessRequestor.requestTypeAccess(s, (Integer)entry.getValue());
                            if (!hint.isFollow()) continue;
                            SpringFeature.log(this.spaces(depth) + "will follow " + t);
                            toFollow.add(t);
                            continue;
                        }
                        if (!hint.isSkipIfTypesMissing() || depth != 0 && !this.isNestedConfiguration(type)) continue;
                        passesTests = false;
                        if (!ConfigOptions.shouldRemoveUnusedAutoconfig()) continue;
                        break block5;
                    }
                }
                List<Type> annotationChain = hint.getAnnotationChain();
                this.registerAnnotationChain(depth, accessRequestor, annotationChain);
                if (!hintExplicitReferencesValidInCurrentMode) continue;
                accessRequestor.requestProxyDescriptors(hint.getProxyDescriptors());
                accessRequestor.requestResourcesDescriptors(hint.getResourceDescriptors());
                accessRequestor.requestInitializationDescriptors(hint.getInitializationDescriptors());
            }
        }
        if (!type.checkConditionalOnWebApplication() && (depth == 0 || this.isNestedConfiguration(type))) {
            passesTests = false;
        }
        String configNameDotted = type.getDottedName();
        visited.add(type.getName());
        if (passesTests || !ConfigOptions.shouldRemoveUnusedAutoconfig()) {
            void var11_14;
            if (type.isImportSelector()) {
                accessRequestor.requestTypeAccess(configNameDotted, Type.inferAccessRequired(type) | 1);
            } else if (type.isCondition()) {
                accessRequestor.requestTypeAccess(configNameDotted, 7);
            } else {
                accessRequestor.requestTypeAccess(configNameDotted, 15);
            }
            this.registerHierarchy(type, accessRequestor);
            Type type2 = type.getSuperclass();
            while (var11_14 != null && !var11_14.getName().equals("java/lang/Object") && visited.add(var11_14.getName())) {
                boolean b = this.processType((Type)var11_14, visited, depth + 1);
                if (!b) {
                    SpringFeature.log(this.spaces(depth) + "WARNING: whilst processing type " + type.getName() + " superclass " + var11_14.getName() + " verification failed");
                }
                Type type3 = var11_14.getSuperclass();
            }
        }
        List<String> list2 = type.getImportedConfigurations();
        for (String string : list2) {
            toFollow.add(this.ts.resolveSlashed(Type.fromLdescriptorToSlashed(string)));
        }
        if (passesTests || !ConfigOptions.shouldRemoveUnusedAutoconfig()) {
            if (type.isAtConfiguration()) {
                List<Method> atBeanMethods;
                List<Method> methodsWithAtBean;
                List<Type> boaTypes = type.getAutoConfigureBeforeOrAfter();
                if (boaTypes.size() != 0) {
                    SpringFeature.log(this.spaces(depth) + "registering " + boaTypes.size() + " @AutoConfigureBefore/After references");
                }
                Iterator iterator = boaTypes.iterator();
                while (iterator.hasNext()) {
                    Type t = (Type)iterator.next();
                    accessRequestor.requestTypeAccess(t.getDottedName(), 2);
                }
                int n = type.getMethodCount();
                int n2 = n - (methodsWithAtBean = type.getMethodsWithAtBean()).size();
                if (n2 != 0) {
                    SpringFeature.log(this.spaces(depth) + "WARNING: Methods unnecessarily being exposed by reflection on this config type " + type.getName() + " = " + n2 + " (total methods including @Bean ones:" + n + ")");
                }
                if ((atBeanMethods = type.getMethodsWithAtBean()).size() != 0) {
                    SpringFeature.log(this.spaces(depth) + "processing " + atBeanMethods.size() + " @Bean methods");
                }
                for (Method atBeanMethod : atBeanMethods) {
                    Type returnType = atBeanMethod.getReturnType();
                    if (returnType == null) continue;
                    accessRequestor.requestTypeAccess(returnType.getDottedName(), 6);
                    if (!ConfigOptions.isSkipAtBeanHintProcessing()) {
                        List<Hint> methodHints = atBeanMethod.getHints();
                        SpringFeature.log(this.spaces(depth) + "hints on method " + atBeanMethod + ":\n" + methodHints);
                        for (Hint hint : methodHints) {
                            SpringFeature.log(this.spaces(depth) + "processing hint " + hint);
                            Map<String, AccessDescriptor> specificNames = hint.getSpecificTypes();
                            SpringFeature.log(this.spaces(depth) + "attempting registration of " + specificNames.size() + " specific types");
                            for (Map.Entry<String, AccessDescriptor> entry : specificNames.entrySet()) {
                                this.registerSpecific(entry.getKey(), entry.getValue().getAccessBits(), accessRequestor);
                            }
                            Map<String, Integer> inferredTypes = hint.getInferredTypes();
                            SpringFeature.log(this.spaces(depth) + "attempting registration of " + inferredTypes.size() + " inferred types");
                            for (Map.Entry<String, Integer> inferredType : inferredTypes.entrySet()) {
                                boolean exists;
                                String s = inferredType.getKey();
                                Type t = this.ts.resolveDotted(s, true);
                                boolean bl = exists = t != null;
                                if (!exists) {
                                    SpringFeature.log(this.spaces(depth) + "inferred type " + s + " not found (whilst processing @Bean method " + atBeanMethod + ")");
                                } else {
                                    SpringFeature.log(this.spaces(depth) + "inferred type " + s + " found, will get accessibility " + inferredType.getValue() + " (whilst processing @Bean method " + atBeanMethod + ")");
                                }
                                if (exists) {
                                    accessRequestor.requestTypeAccess(s, inferredType.getValue());
                                    if (!hint.isFollow()) continue;
                                    toFollow.add(t);
                                    continue;
                                }
                                if (!hint.isSkipIfTypesMissing()) continue;
                                passesTests = false;
                            }
                            if (ConfigOptions.isFunctionalMode()) continue;
                            List<Type> list3 = hint.getAnnotationChain();
                            this.registerAnnotationChain(depth, accessRequestor, list3);
                        }
                    }
                    List<Type> annotationsOnMethod = atBeanMethod.getAnnotationTypes();
                    for (Type annotationOnMethod : annotationsOnMethod) {
                        accessRequestor.requestTypeAccess(annotationOnMethod.getDottedName(), 11);
                    }
                }
            }
            for (Type type4 : toFollow) {
                boolean shouldFollow = this.existingReflectionConfigContains(type4.getDottedName());
                if (ConfigOptions.isAgentMode() && type4.isAtConfiguration() && !shouldFollow) {
                    System.out.println("hybrid: Not following " + type4.getDottedName() + " from " + type.getName() + " - not mentioned in existing reflect configuration");
                    continue;
                }
                try {
                    boolean bl = this.processType(type4, visited, depth + 1);
                    if (bl) continue;
                    SpringFeature.log(this.spaces(depth) + "followed " + type4.getName() + " and it failed validation");
                }
                catch (MissingTypeException missingTypeException) {
                    SpringFeature.log("Unable to completely process followed type " + type4.getName() + ": " + missingTypeException.getMessage());
                }
            }
            for (InitializationDescriptor initializationDescriptor : accessRequestor.getRequestedInitializations()) {
                this.initializationHandler.registerInitializationDescriptor(initializationDescriptor);
            }
            for (ProxyDescriptor proxyDescriptor : accessRequestor.getRequestedProxies()) {
                this.dynamicProxiesHandler.addProxy(proxyDescriptor);
            }
            for (ResourcesDescriptor resourcesDescriptor : accessRequestor.getRequestedResources()) {
                this.registerResourcesDescriptor(resourcesDescriptor);
            }
            this.registerAllRequested(depth, accessRequestor);
        }
        if (passesTests || !ConfigOptions.shouldRemoveUnusedAutoconfig()) {
            List<Type> nestedTypes = type.getNestedTypes();
            for (Type t : nestedTypes) {
                if (!visited.add(t.getName()) || !t.isAtConfiguration() && !t.isConditional() && !t.isMetaImportAnnotated() && !t.isComponent()) continue;
                try {
                    boolean bl = this.processType(t, visited, depth + 1);
                    if (bl) continue;
                    SpringFeature.log(this.spaces(depth) + "verification of nested type " + t.getName() + " failed");
                }
                catch (MissingTypeException missingTypeException) {
                    SpringFeature.log("Unable to completely process nested type " + t.getName() + ": " + missingTypeException.getMessage());
                }
            }
        }
        return passesTests;
    }

    private void registerAllRequested(int depth, RequestedConfigurationManager accessRequestor) {
        for (Map.Entry<String, Integer> accessRequest : accessRequestor.getRequestedTypeAccesses()) {
            String dname = accessRequest.getKey();
            int requestedAccess = accessRequest.getValue();
            if (dname.equals("org.springframework.boot.autoconfigure.web.ServerProperties$Jetty") && !this.ts.canResolve("org/eclipse/jetty/webapp/WebAppContext")) {
                System.out.println("Reducing access on " + dname + " because WebAppContext not around");
                requestedAccess = 2;
            }
            if (dname.equals("org.springframework.boot.autoconfigure.web.ServerProperties$Undertow") && !this.ts.canResolve("io/undertow/Undertow")) {
                System.out.println("Reducing access on " + dname + " because Undertow not around");
                requestedAccess = 2;
            }
            if (dname.equals("org.springframework.boot.autoconfigure.web.ServerProperties$Tomcat") && !this.ts.canResolve("org/apache/catalina/startup/Tomcat")) {
                System.out.println("Reducing access on " + dname + " because Tomcat not around");
                requestedAccess = 2;
            }
            if (dname.equals("org.springframework.boot.autoconfigure.web.ServerProperties$Netty") && !this.ts.canResolve("reactor/netty/http/server/HttpServer")) {
                System.out.println("Reducing access on " + dname + " because HttpServer not around");
                requestedAccess = 2;
            }
            if (this.reflectionHandler.getConstantData().hasClassDescriptor(dname)) {
                System.out.println("This is in the constant data, does it need to stay in there? " + dname + "  (dynamically requested access is " + requestedAccess + ")");
            }
            SpringFeature.log(this.spaces(depth) + "making this accessible: " + dname + "   " + AccessBits.toString(requestedAccess));
            Flag[] flags = AccessBits.getFlags(requestedAccess);
            Type rt = this.ts.resolveDotted(dname, true);
            if (ConfigOptions.isFunctionalMode() && (rt.isAtConfiguration() || rt.isConditional() || rt.isCondition() || rt.isImportSelector() || rt.isImportRegistrar())) continue;
            if (flags != null && flags.length == 1 && flags[0] == Flag.allDeclaredConstructors) {
                Type resolvedType = this.ts.resolveDotted(dname, true);
                if (resolvedType != null && resolvedType.hasOnlySimpleConstructor()) {
                    this.reflectionHandler.addAccess(dname, new String[][]{{"<init>"}}, null, true, new Flag[0]);
                } else {
                    this.reflectionHandler.addAccess(dname, null, null, true, flags);
                }
            } else {
                this.reflectionHandler.addAccess(dname, null, null, true, flags);
            }
            if (!AccessBits.isResourceAccessRequired(requestedAccess)) continue;
            this.resourcesRegistry.addResources(dname.replace(".", "/").replace("$", ".").replace("[", "\\[").replace("]", "\\]") + ".class");
        }
    }

    private boolean isHintValidForCurrentMode(Hint hint) {
        Mode currentMode = ConfigOptions.getMode();
        return hint.applyToFunctional() || currentMode != Mode.FUNCTIONAL;
    }

    private boolean isHintValidForCurrentMode(CompilationHint hint) {
        Mode currentMode = ConfigOptions.getMode();
        return hint.applyToFunctional() || currentMode != Mode.FUNCTIONAL;
    }

    private boolean isIgnored(Type configurationType) {
        List<String> excludedAutoConfig = this.ts.getExcludedAutoConfigurations();
        return excludedAutoConfig.contains(configurationType.getDottedName());
    }

    private boolean existingReflectionConfigContains(String s) {
        Map<String, ReflectionDescriptor> reflectionConfigurationsOnClasspath = this.ts.getReflectionConfigurationsOnClasspath();
        for (ReflectionDescriptor rd : reflectionConfigurationsOnClasspath.values()) {
            if (!rd.hasClassDescriptor(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedConfiguration(Type type) {
        boolean b = type.isAtConfiguration() && type.getEnclosingType() != null;
        return b;
    }

    private void registerAnnotationChain(int depth, RequestedConfigurationManager tar, List<Type> annotationChain) {
        SpringFeature.log(this.spaces(depth) + "attempting registration of " + annotationChain.size() + " elements of annotation chain");
        for (int i = 0; i < annotationChain.size(); ++i) {
            boolean beingReflectedUponInIncomingConfiguration;
            Type t = annotationChain.get(i);
            if (i == 0 && ConfigOptions.isAgentMode() && !(beingReflectedUponInIncomingConfiguration = this.existingReflectionConfigContains(t.getDottedName()))) {
                System.out.println("HYBRID: IGNORE: We could skip this " + t.getDottedName());
                break;
            }
            tar.requestTypeAccess(t.getDottedName(), Type.inferAccessRequired(t));
        }
    }

    private Enumeration<URL> fetchResources(String resource) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resource);
            return resources;
        }
        catch (IOException e1) {
            return Collections.enumeration(Collections.emptyList());
        }
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    private String spaces(int depth) {
        return "                                                  ".substring(0, depth * 2);
    }

    static class ClassCollectorFileVisitor
    implements FileVisitor<Path> {
        private List<Path> collector = new ArrayList<Path>();

        ClassCollectorFileVisitor() {
        }

        List<Path> getClassFiles() {
            return this.collector;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileName().toString().endsWith(".class")) {
                this.collector.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    class NativeImageContextImpl
    implements NativeImageContext {
        private final HashMap<String, Flag[]> reflectiveFlags = new LinkedHashMap<String, Flag[]>();

        NativeImageContextImpl() {
        }

        @Override
        public boolean addProxy(List<String> interfaces) {
            ResourcesHandler.this.dynamicProxiesHandler.addProxy(interfaces);
            return true;
        }

        @Override
        public boolean addProxy(String ... interfaces) {
            if (interfaces != null) {
                ResourcesHandler.this.dynamicProxiesHandler.addProxy(Arrays.asList(interfaces));
            }
            return true;
        }

        @Override
        public TypeSystem getTypeSystem() {
            return ResourcesHandler.this.ts;
        }

        @Override
        public void addReflectiveAccess(String key, Flag ... flags) {
            ResourcesHandler.this.reflectionHandler.addAccess(key, flags);
            this.reflectiveFlags.put(key, flags);
        }

        @Override
        public boolean hasReflectionConfigFor(String key) {
            return this.reflectiveFlags.containsKey(key);
        }

        @Override
        public void initializeAtBuildTime(Type type) {
            try {
                RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{Class.forName(type.getDottedName())});
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Unexpected - type " + type.getDottedName() + " cannot be found!", cnfe);
            }
        }

        @Override
        public Set<String> addReflectiveAccessHierarchy(String typename, int accessBits) {
            Type type = ResourcesHandler.this.ts.resolveDotted(typename, true);
            TreeSet<String> added = new TreeSet<String>();
            this.registerHierarchy(type, added, accessBits);
            return added;
        }

        private void registerHierarchy(Type type, Set<String> visited, int accessBits) {
            String typename = type.getDottedName();
            if (visited.add(typename)) {
                this.addReflectiveAccess(typename, AccessBits.getFlags(accessBits));
                List<String> relatedTypes = type.getTypesInSignature();
                for (String relatedType : relatedTypes) {
                    Type t = ResourcesHandler.this.ts.resolveSlashed(relatedType, true);
                    if (t == null) continue;
                    this.registerHierarchy(t, visited, accessBits);
                }
            }
        }

        @Override
        public void log(String message) {
            SpringFeature.log(message);
        }
    }
}

