/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.hosted.DynamicProxyFeature;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.boot.SpringBootVersion;
import org.springframework.graalvm.support.ConfigOptions;
import org.springframework.graalvm.support.DynamicProxiesHandler;
import org.springframework.graalvm.support.InitializationHandler;
import org.springframework.graalvm.support.ReflectionHandler;
import org.springframework.graalvm.support.ResourcesHandler;

@AutomaticFeature
public class SpringFeature
implements Feature {
    private ReflectionHandler reflectionHandler;
    private DynamicProxiesHandler dynamicProxiesHandler;
    private ResourcesHandler resourcesHandler;
    private InitializationHandler initializationHandler;
    private static final String banner = "   ____         _             _____              ___   ____  ___\n  / __/__  ____(_)__  ___ _  / ___/______ ____ _/ / | / /  |/  /\n _\\ \\/ _ \\/ __/ / _ \\/ _ `/ / (_ / __/ _ `/ _ `/ /| |/ / /|_/ / \n/___/ .__/_/ /_/_//_/\\_, /  \\___/_/  \\_,_/\\_,_/_/ |___/_/  /_/  \n   /_/__     __  _  /___/                                       \n  / |/ /__ _/ /_(_)  _____ \n /    / _ `/ __/ / |/ / -_)\n/_/|_/\\_,_/\\__/_/|___/\\__/ \n                           ";

    public SpringFeature() {
        System.out.println(banner);
        if (!ConfigOptions.isVerbose()) {
            System.out.println("Use -Dspring.native.verbose=true on native-image call to see more detailed information from the feature");
        }
        this.reflectionHandler = new ReflectionHandler();
        this.dynamicProxiesHandler = new DynamicProxiesHandler();
        this.initializationHandler = new InitializationHandler();
        this.resourcesHandler = new ResourcesHandler(this.reflectionHandler, this.dynamicProxiesHandler, this.initializationHandler);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return true;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        ArrayList<Class<? extends Feature>> fs = new ArrayList<Class<? extends Feature>>();
        fs.add(DynamicProxyFeature.class);
        fs.add(ResourcesFeature.class);
        fs.add(ReflectionFeature.class);
        return fs;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        String springBootVersion = SpringBootVersion.getVersion();
        if (springBootVersion != null && (double)Float.parseFloat(springBootVersion.substring(0, 3)) < 2.4) {
            String message = "Spring GraalVM Native requires Spring Boot 2.4.0-M2 or above";
            if (ConfigOptions.shouldFailOnVersionCheck()) {
                throw new VersionCheckException(message);
            }
            System.out.println("Warning: " + message);
        }
        ConfigOptions.ensureModeInitialized(access);
        if (ConfigOptions.isAnnotationMode() || ConfigOptions.isAgentMode()) {
            this.reflectionHandler.register(access);
            this.dynamicProxiesHandler.register(access);
        }
        if (ConfigOptions.isFunctionalMode()) {
            this.reflectionHandler.registerFunctional(access);
        }
        if (ConfigOptions.isAgentMode()) {
            this.reflectionHandler.registerHybrid(access);
            this.dynamicProxiesHandler.registerHybrid(access);
        }
        if (ConfigOptions.isInitMode()) {
            this.reflectionHandler.registerAgent(access);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.initializationHandler.register(access);
        this.resourcesHandler.register(access);
        if (ConfigOptions.isAnnotationMode() || ConfigOptions.isFunctionalMode() || ConfigOptions.isAgentMode()) {
            System.out.println("Number of types dynamically registered for reflective access: #" + this.reflectionHandler.getTypesRegisteredForReflectiveAccessCount());
            this.reflectionHandler.dump();
        }
    }

    public static void log(String msg) {
        if (ConfigOptions.isVerbose()) {
            System.out.println(msg);
        }
    }

    static class VersionCheckException
    extends IllegalStateException {
        public VersionCheckException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

