/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.List;
import org.springframework.graalvm.type.AccessBits;
import org.springframework.graalvm.type.FieldDescriptor;
import org.springframework.graalvm.type.MethodDescriptor;

public class AccessDescriptor {
    private Integer accessBits;
    private List<MethodDescriptor> methodDescriptors;
    private List<FieldDescriptor> fieldDescriptors;

    public AccessDescriptor(Integer accessBits, List<MethodDescriptor> mds, List<FieldDescriptor> fds) {
        this.accessBits = accessBits;
        this.methodDescriptors = mds;
        this.fieldDescriptors = fds;
    }

    public Integer getAccessBits() {
        return this.accessBits;
    }

    public List<MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public boolean noMembersSpecified() {
        return this.methodDescriptors.isEmpty() && this.fieldDescriptors.isEmpty();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AccessDescriptor:bits=" + AccessBits.toString(this.accessBits));
        if (this.methodDescriptors != null && !this.methodDescriptors.isEmpty()) {
            s.append(",md=" + this.methodDescriptors);
        }
        if (this.fieldDescriptors != null && !this.fieldDescriptors.isEmpty()) {
            s.append(",fd=" + this.fieldDescriptors);
        }
        return s.toString();
    }
}

