/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.graalvm.type.Lazy;
import org.springframework.graalvm.type.Type;
import org.springframework.graalvm.type.TypeSystem;
import sbg.asm.signature.SignatureReader;
import sbg.asm.tree.AnnotationNode;
import sbg.asm.tree.FieldNode;

public class Field {
    private FieldNode node;
    private TypeSystem typeSystem;
    private Lazy<List<Type>> annotations;

    public Field(FieldNode node, TypeSystem typeSystem) {
        this.node = node;
        this.typeSystem = typeSystem;
        this.annotations = Lazy.of(this::resolveAnnotations);
    }

    public List<Type> getAnnotationTypes() {
        return this.annotations.get();
    }

    private List<Type> resolveAnnotations() {
        ArrayList<Type> results = null;
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) continue;
                if (results == null) {
                    results = new ArrayList<Type>();
                }
                results.add(annotationType);
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public List<String> getTypesInSignature() {
        if (this.node.signature == null) {
            String s = this.node.desc;
            if (s.endsWith(";")) {
                return Collections.singletonList(Type.fromLdescriptorToSlashed(s));
            }
            return Collections.singletonList(null);
        }
        SignatureReader reader = new SignatureReader(this.node.signature);
        Type.TypeCollector tc = new Type.TypeCollector();
        reader.accept(tc);
        return tc.getTypes();
    }

    public String getName() {
        return this.node.name;
    }
}

