/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.List;
import java.util.Map;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.type.AccessBits;
import org.springframework.graalvm.type.AccessDescriptor;
import org.springframework.graalvm.type.ProxyDescriptor;
import org.springframework.graalvm.type.ResourcesDescriptor;
import org.springframework.graalvm.type.Type;

public class Hint {
    private List<Type> annotationChain;
    private boolean skipIfTypesMissing;
    private boolean follow;
    private Map<String, AccessDescriptor> specificTypes;
    private Map<String, Integer> inferredTypes;
    private List<ProxyDescriptor> proxyDescriptors;
    private List<ResourcesDescriptor> resourcesDescriptors;
    private List<InitializationDescriptor> initializationDescriptors;
    private boolean applyToFunctional;

    public Hint(List<Type> annotationChain, boolean skipIfTypesMissing, boolean follow, Map<String, AccessDescriptor> specificTypes, Map<String, Integer> inferredTypes, List<ProxyDescriptor> proxyDescriptors, List<ResourcesDescriptor> resourcesDescriptors, List<InitializationDescriptor> initializationDescriptors, boolean applyToFunctional) {
        this.annotationChain = annotationChain;
        this.skipIfTypesMissing = skipIfTypesMissing;
        this.follow = follow;
        this.specificTypes = specificTypes;
        this.inferredTypes = inferredTypes;
        this.proxyDescriptors = proxyDescriptors;
        this.resourcesDescriptors = resourcesDescriptors;
        this.initializationDescriptors = initializationDescriptors;
        this.applyToFunctional = applyToFunctional;
    }

    public List<Type> getAnnotationChain() {
        return this.annotationChain;
    }

    public boolean isSkipIfTypesMissing() {
        return this.skipIfTypesMissing;
    }

    public boolean isFollow() {
        return this.follow;
    }

    public Map<String, AccessDescriptor> getSpecificTypes() {
        return this.specificTypes;
    }

    public Map<String, Integer> getInferredTypes() {
        return this.inferredTypes;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Hint{");
        s.append(this.shortChain());
        s.append(",skipIfTypesMissing=").append(this.skipIfTypesMissing);
        s.append(",follow=").append(this.follow);
        s.append(",specificTypes=").append(this.shortenWithAD(this.specificTypes));
        s.append(",inferredTypes=").append(this.shorten(this.inferredTypes));
        s.append(",resourcesDescriptors=").append(this.resourcesDescriptors);
        s.append(",initializationDescriptors=").append(this.initializationDescriptors);
        s.append("}");
        return s.toString();
    }

    private String shortenWithAD(Map<String, AccessDescriptor> types) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        s.append("[");
        for (Map.Entry<String, AccessDescriptor> entry : types.entrySet()) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.shorten(entry.getKey())).append(":").append(entry.getValue().toString());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    private String shorten(Map<String, Integer> types) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        s.append("[");
        for (Map.Entry<String, Integer> entry : types.entrySet()) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.shorten(entry.getKey())).append(":").append(AccessBits.toString(entry.getValue()));
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    public String shortChain() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (int i = 0; i < this.annotationChain.size(); ++i) {
            Type t = this.annotationChain.get(i);
            if (i > 0) {
                s.append(",");
            }
            s.append(this.shorten(t.getDottedName()));
        }
        s.append("]");
        return s.toString();
    }

    private String shorten(String dname) {
        StringBuilder s = new StringBuilder();
        boolean hasDot = dname.contains(".");
        while (dname.contains(".")) {
            s.append(dname.charAt(0));
            dname = dname.substring(dname.indexOf(".") + 1);
        }
        if (hasDot) {
            s.append(".");
        }
        s.append(dname);
        return s.toString();
    }

    public List<ResourcesDescriptor> getResourceDescriptors() {
        return this.resourcesDescriptors;
    }

    public List<ProxyDescriptor> getProxyDescriptors() {
        return this.proxyDescriptors;
    }

    public boolean applyToFunctional() {
        return this.applyToFunctional;
    }

    public List<InitializationDescriptor> getInitializationDescriptors() {
        return this.initializationDescriptors;
    }
}

