/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import sbg.asm.ClassReader;
import sbg.asm.ClassVisitor;
import sbg.asm.MethodVisitor;

class IsPresentDetectionVisitor
extends ClassVisitor {
    private String classname;
    private boolean containsIsPresentChecksInStaticInitializer = false;
    private List<String> typesCheckedInIsPresentCalls = new ArrayList<String>();

    public static List<String> run(InputStream inputStream) {
        try {
            IsPresentDetectionVisitor node = new IsPresentDetectionVisitor(458752);
            ClassReader reader = new ClassReader(inputStream);
            reader.accept(node, 2);
            return node.containsIsPresentChecksInStaticInitializer ? node.typesCheckedInIsPresentCalls : null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IsPresentDetectionVisitor(int api) {
        super(api);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classname = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return new ClinitVisitor(this.api);
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    class ClinitVisitor
    extends MethodVisitor {
        private int state;
        private String mostRecentlyLoadedString;

        public ClinitVisitor(int api) {
            super(api);
            this.state = 0;
        }

        @Override
        public void visitLdcInsn(Object value) {
            if (value instanceof String) {
                this.mostRecentlyLoadedString = (String)value;
                this.state = 1;
            }
            super.visitLdcInsn(value);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean itface) {
            if (opcode == 184 && owner.equals("org/springframework/util/ClassUtils") && name.equals("isPresent") && descriptor.equals("(Ljava/lang/String;Ljava/lang/ClassLoader;)Z")) {
                IsPresentDetectionVisitor.this.containsIsPresentChecksInStaticInitializer = true;
                if (this.state == 1) {
                    IsPresentDetectionVisitor.this.typesCheckedInIsPresentCalls.add(this.mostRecentlyLoadedString);
                    this.state = 0;
                }
            } else {
                super.visitMethodInsn(opcode, owner, name, descriptor, itface);
            }
        }
    }
}

