/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

class Lazy<T>
implements Supplier<T> {
    private static final Lazy<?> EMPTY = new Lazy<Object>(() -> null, null, true);
    private final Supplier<? extends T> supplier;
    private T value = null;
    private boolean resolved = false;

    private Lazy(Supplier<? extends T> supplier) {
        this(supplier, null, false);
    }

    public Lazy(Supplier<? extends T> supplier, T value, boolean resolved) {
        this.supplier = supplier;
        this.value = value;
        this.resolved = resolved;
    }

    public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
        return new Lazy<T>(supplier);
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<Object>(() -> value);
    }

    public static <T> Lazy<T> empty() {
        return EMPTY;
    }

    @Override
    public T get() {
        T value = this.getNullable();
        if (value == null) {
            throw new IllegalStateException("Expected lazy evaluation to yield a non-null value but got null!");
        }
        return value;
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.getNullable());
    }

    public Lazy<T> or(Supplier<? extends T> supplier) {
        return Lazy.of(() -> this.orElseGet(supplier));
    }

    public Lazy<T> or(T value) {
        return Lazy.of(() -> this.orElse(value));
    }

    public T orElse(T value) {
        T nullable = this.getNullable();
        return nullable == null ? value : nullable;
    }

    private T orElseGet(Supplier<? extends T> supplier) {
        T value = this.getNullable();
        return value == null ? supplier.get() : value;
    }

    public <S> Lazy<S> map(Function<? super T, ? extends S> function) {
        return Lazy.of(() -> function.apply((T)this.get()));
    }

    public <S> Lazy<S> flatMap(Function<? super T, Lazy<? extends S>> function) {
        return Lazy.of(() -> ((Lazy)function.apply((T)this.get())).get());
    }

    public T getNullable() {
        T value = this.value;
        if (this.resolved) {
            return value;
        }
        this.value = value = this.supplier.get();
        this.resolved = true;
        return value;
    }
}

