/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.springframework.graalvm.support.SpringFeature;
import org.springframework.graalvm.type.Hint;
import org.springframework.graalvm.type.Pair;
import org.springframework.graalvm.type.Type;
import org.springframework.graalvm.type.TypeSystem;
import sbg.asm.signature.SignatureReader;
import sbg.asm.signature.SignatureVisitor;
import sbg.asm.tree.AnnotationNode;
import sbg.asm.tree.MethodNode;

public class Method {
    private MethodNode mn;
    private TypeSystem typeSystem;

    public Method(MethodNode mn, TypeSystem ts) {
        this.mn = mn;
        this.typeSystem = ts;
    }

    public String toString() {
        return this.mn.name + this.mn.desc;
    }

    public String getName() {
        return this.mn.name;
    }

    public String getDesc() {
        return this.mn.desc;
    }

    public List<Hint> getHints() {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) {
                    SpringFeature.log("Couldn't resolve " + an.desc + " annotation type whilst searching for hints on " + this.getName());
                    continue;
                }
                Stack<Type> s = new Stack<Type>();
                annotationType.collectHints(an, hints, new HashSet<AnnotationNode>(), s);
            }
        }
        return hints.size() == 0 ? Collections.emptyList() : hints;
    }

    public List<Type> getParameterAnnotationTypes(int parameterIndex) {
        List<AnnotationNode> pas;
        ArrayList<Type> results = null;
        if (this.mn.visibleParameterAnnotations != null && parameterIndex < this.mn.visibleParameterAnnotations.length && (pas = this.mn.visibleParameterAnnotations[parameterIndex]) != null) {
            for (AnnotationNode an : pas) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) continue;
                if (results == null) {
                    results = new ArrayList<Type>();
                }
                results.add(annotationType);
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public List<Type> getAnnotationTypes() {
        ArrayList<Type> results = null;
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) continue;
                if (results == null) {
                    results = new ArrayList<Type>();
                }
                results.add(annotationType);
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public Set<Type> getSignatureTypes() {
        return this.getSignatureTypes(false);
    }

    public Set<Type> getSignatureTypes(boolean returnTypeOnly) {
        HashSet<Type> signatureTypes;
        block8: {
            block7: {
                signatureTypes = new HashSet<Type>();
                if (this.mn.signature != null) break block7;
                sbg.asm.Type methodType = sbg.asm.Type.getMethodType(this.mn.desc);
                sbg.asm.Type returnType = methodType.getReturnType();
                Type t = null;
                if (returnType.getDescriptor().length() != 1) {
                    t = this.typeSystem.resolve(methodType.getReturnType(), true);
                    if (t == null) {
                        SpringFeature.log("Can't resolve the type used in this @Bean method: " + this.mn.name + this.mn.desc + ": " + methodType.getDescriptor());
                    } else {
                        signatureTypes.add(t);
                    }
                }
                if (returnTypeOnly) break block8;
                for (sbg.asm.Type at : methodType.getArgumentTypes()) {
                    if (at.getDescriptor().length() == 1) continue;
                    t = this.typeSystem.resolve(methodType.getReturnType(), true);
                    if (t == null) {
                        SpringFeature.log("Can't resolve the type used in this @Bean method: " + this.mn.name + this.mn.desc + ": " + at.getDescriptor());
                        continue;
                    }
                    signatureTypes.add(t);
                }
                break block8;
            }
            SignatureReader reader = new SignatureReader(this.mn.signature);
            TypesFromSignatureCollector tc = new TypesFromSignatureCollector(returnTypeOnly);
            reader.accept(tc);
            Set<String> collectedTypes = tc.getTypes();
            for (String s : collectedTypes) {
                Type t = this.typeSystem.resolveDotted(s, true);
                if (t == null) {
                    SpringFeature.log("Can't resolve the type used in this @Bean method: " + this.mn.name + this.mn.desc + ": " + s);
                    continue;
                }
                signatureTypes.add(t);
            }
        }
        return signatureTypes;
    }

    public Type getReturnType() {
        sbg.asm.Type methodType = sbg.asm.Type.getMethodType(this.mn.desc);
        Type returnType = this.typeSystem.resolve(methodType.getReturnType(), true);
        return returnType;
    }

    public List<Type> getParameterTypes() {
        ArrayList<Type> results = null;
        sbg.asm.Type[] parameterTypes = sbg.asm.Type.getArgumentTypes(this.mn.desc);
        if (parameterTypes != null) {
            for (sbg.asm.Type t : parameterTypes) {
                if (results == null) {
                    results = new ArrayList<Type>();
                }
                results.add(this.typeSystem.resolve(t, true));
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public boolean isAtMapping() {
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                if (an.desc.equals("Lorg/springframework/web/bind/annotation/Mapping;")) {
                    return true;
                }
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                boolean metaUsage = annotationType.isMetaAnnotated(Type.fromLdescriptorToSlashed("Lorg/springframework/web/bind/annotation/Mapping;"));
                if (!metaUsage) continue;
                return true;
            }
        }
        return false;
    }

    public int getParameterCount() {
        return this.mn.parameters == null ? 0 : this.mn.parameters.size();
    }

    public boolean hasAliasForAnnotation() {
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                if (!an.desc.equals("Lorg/springframework/core/annotation/AliasFor;")) continue;
                return true;
            }
        }
        return false;
    }

    public Pair<String, Boolean> getAliasForSummary() {
        AnnotationNode aliasForAnnotation = this.getAliasForAnnotation();
        if (aliasForAnnotation != null) {
            List<Object> values = aliasForAnnotation.values;
            boolean namedAttribute = false;
            String targetAnnotationType = null;
            block9: for (int i = 0; i < values.size(); i += 2) {
                switch ((String)values.get(i)) {
                    case "value": 
                    case "attribute": {
                        namedAttribute = true;
                        continue block9;
                    }
                    case "annotation": {
                        targetAnnotationType = ((sbg.asm.Type)values.get(i + 1)).getClassName();
                    }
                }
            }
            return Pair.of(targetAnnotationType, namedAttribute);
        }
        return null;
    }

    private AnnotationNode getAliasForAnnotation() {
        if (this.mn.visibleAnnotations != null) {
            for (AnnotationNode an : this.mn.visibleAnnotations) {
                if (!an.desc.equals("Lorg/springframework/core/annotation/AliasFor;")) continue;
                return an;
            }
        }
        return null;
    }

    public boolean hasAnnotations() {
        return this.mn.visibleAnnotations != null;
    }

    static class TypesFromSignatureCollector
    extends SignatureVisitor {
        Set<String> types = null;
        private boolean returnTypeOnly;
        private boolean captureTypes = false;

        public TypesFromSignatureCollector(boolean returnTypeOnly) {
            super(458752);
            this.returnTypeOnly = returnTypeOnly;
            if (!returnTypeOnly) {
                this.captureTypes = true;
            }
        }

        @Override
        public SignatureVisitor visitReturnType() {
            if (this.returnTypeOnly) {
                this.captureTypes = true;
            }
            return super.visitReturnType();
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            if (this.returnTypeOnly) {
                this.captureTypes = false;
            }
            return super.visitExceptionType();
        }

        @Override
        public SignatureVisitor visitParameterType() {
            if (this.returnTypeOnly) {
                this.captureTypes = false;
            }
            return super.visitParameterType();
        }

        @Override
        public void visitClassType(String name) {
            if (this.captureTypes) {
                if (this.types == null) {
                    this.types = new HashSet<String>();
                }
                this.types.add(name);
            }
        }

        public Set<String> getTypes() {
            if (this.types == null) {
                return Collections.emptySet();
            }
            return this.types;
        }
    }
}

