/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.extension.InitializationInfo;
import org.springframework.graalvm.extension.InitializationInfos;
import org.springframework.graalvm.extension.InitializationTime;
import org.springframework.graalvm.extension.NativeImageHint;
import org.springframework.graalvm.extension.NativeImageHints;
import org.springframework.graalvm.extension.ProxyInfo;
import org.springframework.graalvm.extension.ProxyInfos;
import org.springframework.graalvm.extension.ResourcesInfo;
import org.springframework.graalvm.extension.ResourcesInfos;
import org.springframework.graalvm.extension.TypeInfo;
import org.springframework.graalvm.extension.TypeInfos;
import org.springframework.graalvm.support.ConfigOptions;
import org.springframework.graalvm.support.SpringFeature;
import org.springframework.graalvm.type.CompilationHint;
import org.springframework.graalvm.type.Field;
import org.springframework.graalvm.type.FieldDescriptor;
import org.springframework.graalvm.type.Hint;
import org.springframework.graalvm.type.Lazy;
import org.springframework.graalvm.type.Method;
import org.springframework.graalvm.type.MethodDescriptor;
import org.springframework.graalvm.type.MissingTypeException;
import org.springframework.graalvm.type.Pair;
import org.springframework.graalvm.type.ProxyDescriptor;
import org.springframework.graalvm.type.ResourcesDescriptor;
import org.springframework.graalvm.type.TypeSystem;
import sbg.asm.signature.SignatureReader;
import sbg.asm.signature.SignatureVisitor;
import sbg.asm.tree.AnnotationNode;
import sbg.asm.tree.ClassNode;
import sbg.asm.tree.FieldNode;
import sbg.asm.tree.InnerClassNode;
import sbg.asm.tree.MethodNode;

public class Type {
    public static final String AtResponseBody = "Lorg/springframework/web/bind/annotation/ResponseBody;";
    public static final String AtMapping = "Lorg/springframework/web/bind/annotation/Mapping;";
    public static final String AtTransactional = "Lorg/springframework/transaction/annotation/Transactional;";
    public static final String AtJavaxTransactional = "Ljavax/transaction/Transactional;";
    public static final String AtBean = "Lorg/springframework/context/annotation/Bean;";
    public static final String AtConditionalOnClass = "Lorg/springframework/boot/autoconfigure/condition/ConditionalOnClass;";
    public static final String AtConditionalOnMissingBean = "Lorg/springframework/boot/autoconfigure/condition/ConditionalOnMissingBean;";
    public static final String AtConfiguration = "Lorg/springframework/context/annotation/Configuration;";
    public static final String AtImportAutoConfiguration = "Lorg/springframework/boot/autoconfigure/ImportAutoConfiguration;";
    public static final String AtConfigurationProperties = "Lorg/springframework/boot/context/properties/ConfigurationProperties;";
    public static final String AtSpringBootApplication = "Lorg/springframework/boot/autoconfigure/SpringBootApplication;";
    public static final String AtController = "Lorg/springframework/stereotype/Controller;";
    public static final String AtRepository = "Lorg/springframework/stereotype/Repository;";
    public static final String AtEnableConfigurationProperties = "Lorg/springframework/boot/context/properties/EnableConfigurationProperties;";
    public static final String AtImports = "Lorg/springframework/context/annotation/Import;";
    public static final String AtComponent = "Lorg/springframework/stereotype/Component;";
    public static final String BeanFactoryPostProcessor = "Lorg/springframework/beans/factory/config/BeanFactoryPostProcessor;";
    public static final String ImportBeanDefinitionRegistrar = "Lorg/springframework/context/annotation/ImportBeanDefinitionRegistrar;";
    public static final String ImportSelector = "Lorg/springframework/context/annotation/ImportSelector;";
    public static final String ApplicationListener = "Lorg/springframework/context/ApplicationListener;";
    public static final String AtAliasFor = "Lorg/springframework/core/annotation/AliasFor;";
    public static final String Condition = "Lorg/springframework/context/annotation/Condition;";
    public static final Type MISSING = new Type(null, null, 0);
    public static final Type[] NO_INTERFACES = new Type[0];
    protected static Set<String> validBoxing = new HashSet<String>();
    private TypeSystem typeSystem;
    private ClassNode node;
    private Type[] interfaces;
    private String name;
    private String dottedName;
    private int dimensions = 0;
    private final Lazy<List<Field>> fields;
    private final Lazy<List<Method>> methods;
    private final Lazy<List<Type>> annotations;
    public static final List<Type> NO_ANNOTATIONS;

    private Type(TypeSystem typeSystem, ClassNode node, int dimensions) {
        this.typeSystem = typeSystem;
        this.node = node;
        this.dimensions = dimensions;
        if (node != null) {
            this.name = node.name;
            for (int i = 0; i < dimensions; ++i) {
                this.name = this.name + "[]";
            }
            this.dottedName = this.name.replace("/", ".");
            this.fields = Lazy.of(this::resolveFields);
            this.methods = Lazy.of(this::resolveMethods);
            this.annotations = Lazy.of(this::resolveAnnotations);
        } else {
            this.fields = Lazy.empty();
            this.methods = Lazy.empty();
            this.annotations = Lazy.empty();
        }
    }

    public static Type forClassNode(TypeSystem typeSystem, ClassNode node, int dimensions) {
        return new Type(typeSystem, node, dimensions);
    }

    public String getName() {
        return this.name;
    }

    public String getDottedName() {
        return this.dottedName;
    }

    public Type getSuperclass() {
        if (this.dimensions > 0) {
            return this.typeSystem.resolveSlashed("java/lang/Object");
        }
        if (this.node.superName == null) {
            return null;
        }
        return this.typeSystem.resolveSlashed(this.node.superName);
    }

    public String toString() {
        return "Type:" + this.getName();
    }

    public Type[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.dimensions != 0) {
                this.interfaces = new Type[]{this.typeSystem.resolveSlashed("java/lang/Cloneable"), this.typeSystem.resolveSlashed("java/io/Serializable")};
            } else {
                List<String> itfs = this.node.interfaces;
                if (itfs.size() == 0) {
                    this.interfaces = NO_INTERFACES;
                } else {
                    ArrayList<Type> interfacesOnClasspath = new ArrayList<Type>();
                    for (int i = 0; i < itfs.size(); ++i) {
                        Type t = this.typeSystem.resolveSlashed(itfs.get(i));
                        interfacesOnClasspath.add(t);
                    }
                    this.interfaces = interfacesOnClasspath.toArray(new Type[interfacesOnClasspath.size()]);
                }
            }
        }
        return this.interfaces;
    }

    public boolean isPartOfDomain(String packageName) {
        return this.belongsToPackage(packageName, true);
    }

    public boolean belongsToPackage(String packageName, boolean orPartOfSubPackage) {
        return orPartOfSubPackage ? this.dottedName.startsWith(packageName) : this.getPackageName().equals(packageName);
    }

    public String getPackageName() {
        return this.dottedName.substring(0, this.dottedName.indexOf(46));
    }

    public List<String> getInterfacesStrings() {
        if (this.dimensions != 0) {
            ArrayList<String> itfs = new ArrayList<String>();
            itfs.add("java/lang/Cloneable");
            itfs.add("java/io/Serializable");
            return itfs;
        }
        return this.node.interfaces;
    }

    public String getSuperclassString() {
        return this.dimensions > 0 ? "java/lang/Object" : this.node.superName;
    }

    public List<String> getTypesInSignature() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        if (this.node.signature == null) {
            ArrayList<String> ls = new ArrayList<String>();
            if (this.node.superName != null) {
                ls.add(this.node.superName);
            }
            if (this.node.interfaces != null) {
                ls.addAll(this.node.interfaces);
            }
            return ls;
        }
        SignatureReader reader = new SignatureReader(this.node.signature);
        TypeCollector tc = new TypeCollector();
        reader.accept(tc);
        return tc.getTypes();
    }

    public boolean extendsClass(String clazzname) {
        for (Type superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!superclass.getDescriptor().equals(clazzname)) continue;
            return true;
        }
        return false;
    }

    public boolean implementsInterface(String interfaceName) {
        Type[] interfacesToCheck;
        for (Type interfaceToCheck : interfacesToCheck = this.getInterfaces()) {
            if (interfaceToCheck == null) continue;
            if (interfaceToCheck.getName().equals(interfaceName)) {
                return true;
            }
            if (!interfaceToCheck.implementsInterface(interfaceName)) continue;
            return true;
        }
        for (Type superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!superclass.implementsInterface(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public List<Method> getMethodsWithAnnotation(String string) {
        return this.dimensions > 0 ? Collections.emptyList() : this.node.methods.stream().filter(m -> this.hasAnnotation((MethodNode)m, string)).map(m -> this.wrap((MethodNode)m)).collect(Collectors.toList());
    }

    public List<Method> getMethodsWithAnnotationName(String string, boolean checkMetaUsage) {
        return this.getMethodsWithAnnotation("L" + string.replace(".", "/") + ";", checkMetaUsage);
    }

    public List<Method> getMethodsWithAnnotation(String string, boolean checkMetaUsage) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList();
        if (this.node.methods != null) {
            for (MethodNode mn : this.node.methods) {
                if (!this.hasAnnotation(mn, string, checkMetaUsage)) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(this.wrap(mn));
            }
        }
        return results == null ? Collections.emptyList() : results;
    }

    public List<Method> getMethods() {
        return this.methods.get();
    }

    private List<Method> resolveMethods() {
        return this.dimensions > 0 ? Collections.emptyList() : this.node.methods.stream().map(m -> this.wrap((MethodNode)m)).collect(Collectors.toList());
    }

    public List<Field> getFields() {
        return this.fields.get();
    }

    private List<Field> resolveFields() {
        return this.dimensions > 0 ? Collections.emptyList() : this.node.fields.stream().map(it -> new Field((FieldNode)it, this.typeSystem)).collect(Collectors.toList());
    }

    public List<Method> getMethodsWithAtBean() {
        return this.getMethodsWithAnnotation(AtBean);
    }

    private Method wrap(MethodNode mn) {
        return new Method(mn, this.typeSystem);
    }

    private boolean hasAnnotation(MethodNode m, String string) {
        List<AnnotationNode> visibleAnnotations = m.visibleAnnotations;
        Optional findAny = visibleAnnotations == null ? Optional.empty() : visibleAnnotations.stream().filter(a -> a.desc.equals(string)).findFirst();
        return findAny.isPresent();
    }

    public boolean hasAnnotation(String lAnnotationDescriptor, boolean checkMetaUsage) {
        HashSet<String> seen = new HashSet<String>();
        return this.hasAnnotationHelper(lAnnotationDescriptor, checkMetaUsage, seen);
    }

    private boolean hasAnnotationHelper(String lAnnotationDescriptor, boolean checkMetaUsage, Set<String> seen) {
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                boolean b;
                Type t;
                if (an.desc.equals(lAnnotationDescriptor)) {
                    return true;
                }
                if (!checkMetaUsage || !seen.add(lAnnotationDescriptor) || (t = this.typeSystem.Lresolve(an.desc)) == null || !(b = t.hasAnnotationHelper(lAnnotationDescriptor, checkMetaUsage, seen))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnnotation(MethodNode mn, String lAnnotationDescriptor, boolean checkMetaUsage) {
        if (checkMetaUsage) {
            return this.findMetaAnnotationUsage(this.toAnnotations(mn.visibleAnnotations), lAnnotationDescriptor);
        }
        List<AnnotationNode> vAnnotations = mn.visibleAnnotations;
        if (vAnnotations != null) {
            for (AnnotationNode an : vAnnotations) {
                if (!an.desc.equals(lAnnotationDescriptor)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Type> toAnnotations(List<AnnotationNode> visibleAnnotations) {
        if (visibleAnnotations == null) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        for (AnnotationNode an : visibleAnnotations) {
            result.add(this.typeSystem.Lresolve(an.desc));
        }
        return result;
    }

    private boolean findMetaAnnotationUsage(List<Type> toSearch, String lAnnotationDescriptor) {
        return this.findMetaAnnotationUsageHelper(toSearch, lAnnotationDescriptor, new HashSet<String>());
    }

    private boolean findMetaAnnotationUsageHelper(List<Type> toSearch, String lAnnotationDescriptor, Set<String> seen) {
        if (toSearch == null) {
            return false;
        }
        for (Type an : toSearch) {
            boolean isMetaAnnotated;
            if (an.getDescriptor().equals(lAnnotationDescriptor)) {
                return true;
            }
            if (!seen.add(an.getName()) || !(isMetaAnnotated = this.findMetaAnnotationUsageHelper(an.getAnnotations(), lAnnotationDescriptor, seen))) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(Type other) {
        boolean b;
        Type[] interfaces;
        if (other.isPrimitiveType() && validBoxing.contains(this.getName() + other.getName())) {
            return true;
        }
        if (this == other) {
            return true;
        }
        if (this.getName().equals("Ljava/lang/Object;")) {
            return true;
        }
        for (Type intface : interfaces = other.getInterfaces()) {
            boolean b2 = this.isAssignableFrom(intface);
            if (!b2) continue;
            return true;
        }
        Type superclass = other.getSuperclass();
        return superclass != null && (b = this.isAssignableFrom(superclass));
    }

    private boolean isPrimitiveType() {
        return false;
    }

    public boolean isInterface() {
        return this.dimensions > 0 ? false : Modifier.isInterface(this.node.access);
    }

    public Map<String, String> getAnnotationValuesInHierarchy(String LdescriptorLookingFor) {
        if (this.dimensions > 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> collector = new HashMap<String, String>();
        this.getAnnotationValuesInHierarchy(LdescriptorLookingFor, new ArrayList<String>(), collector);
        return collector;
    }

    public void getAnnotationValuesInHierarchy(String lookingFor, List<String> seen, Map<String, String> collector) {
        if (this.dimensions > 0) {
            return;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode anno : this.node.visibleAnnotations) {
                if (seen.contains(anno.desc)) continue;
                seen.add(anno.desc);
                if (anno.desc.equals(lookingFor)) {
                    List<Object> os = anno.values;
                    for (int i = 0; i < os.size(); i += 2) {
                        collector.put(os.get(i).toString(), os.get(i + 1).toString());
                    }
                }
                try {
                    Type resolve = this.typeSystem.Lresolve(anno.desc);
                    resolve.getAnnotationValuesInHierarchy(lookingFor, seen, collector);
                }
                catch (MissingTypeException missingTypeException) {}
            }
        }
    }

    public boolean hasAnnotationInHierarchy(String lookingFor) {
        if (this.dimensions > 0) {
            return false;
        }
        return this.hasAnnotationInHierarchy(lookingFor, new ArrayList<String>());
    }

    public boolean hasAnnotationInHierarchy(String lookingFor, List<String> seen) {
        if (this.dimensions > 0) {
            return false;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode anno : this.node.visibleAnnotations) {
                if (seen.contains(anno.desc)) continue;
                seen.add(anno.desc);
                if (anno.desc.equals(lookingFor)) {
                    return true;
                }
                try {
                    Type resolve = this.typeSystem.Lresolve(anno.desc);
                    if (!resolve.hasAnnotationInHierarchy(lookingFor, seen)) continue;
                    return true;
                }
                catch (MissingTypeException missingTypeException) {
                }
            }
        }
        return false;
    }

    public boolean isCondition() {
        if (this.dimensions > 0) {
            return false;
        }
        try {
            return this.implementsInterface(Type.fromLdescriptorToSlashed(Condition));
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    private boolean isEventListener() {
        try {
            return this.implementsInterface("org/springframework/context/event/EventListenerFactory");
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    public boolean isAtImport() {
        return this.dimensions > 0 ? false : this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtImports));
    }

    public boolean isAtConfiguration() {
        if (this.dimensions > 0) {
            return false;
        }
        return this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtConfiguration), new HashSet<String>());
    }

    public boolean isAtSpringBootApplication() {
        return this.dimensions > 0 ? false : this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtSpringBootApplication), new HashSet<String>());
    }

    public boolean isAtController() {
        return this.dimensions > 0 ? false : this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtController), new HashSet<String>());
    }

    public boolean isAbstractNestedCondition() {
        if (this.dimensions > 0) {
            return false;
        }
        return this.extendsClass("Lorg/springframework/boot/autoconfigure/condition/AbstractNestedCondition;");
    }

    public boolean isMetaAnnotated(String slashedTypeDescriptor) {
        if (this.dimensions > 0) {
            return false;
        }
        return this.isMetaAnnotated(slashedTypeDescriptor, new HashSet<String>());
    }

    private boolean isMetaAnnotated(String slashedTypeDescriptor, Set<String> seen) {
        if (this.dimensions > 0) {
            return false;
        }
        for (Type t : this.getAnnotations()) {
            if (t == null) continue;
            String tname = t.getName();
            if (tname.equals(slashedTypeDescriptor)) {
                return true;
            }
            if (seen.contains(tname)) continue;
            seen.add(tname);
            if (!t.isMetaAnnotated(slashedTypeDescriptor, seen)) continue;
            return true;
        }
        return false;
    }

    public List<String> findConditionalOnMissingBeanValue() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<String> findAnnotationValue = this.findAnnotationValue(AtConditionalOnMissingBean, false);
        if (findAnnotationValue == null && this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(AtConditionalOnMissingBean)) continue;
                System.out.println("??? found nothing on this @COC annotated thing " + this.getName());
            }
        }
        return findAnnotationValue;
    }

    public List<String> findConditionalOnClassValue() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<String> findAnnotationValue = this.findAnnotationValue(AtConditionalOnClass, false);
        if (findAnnotationValue == null && this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(AtConditionalOnClass)) continue;
                System.out.println("??? found nothing on this @COC annotated thing " + this.getName());
            }
        }
        return findAnnotationValue;
    }

    public List<String> findEnableConfigurationPropertiesValue() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<String> values = this.findAnnotationValue(AtEnableConfigurationProperties, false);
        return values;
    }

    public Map<String, List<String>> findImports() {
        if (this.dimensions > 0) {
            return Collections.emptyMap();
        }
        return this.findAnnotationValueWithHostAnnotation(AtImports, true, new HashSet<String>());
    }

    public List<String> findAnnotationValue(String annotationType, boolean searchMeta) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        return this.findAnnotationValue(annotationType, searchMeta, new HashSet<String>());
    }

    public Map<String, List<String>> findAnnotationValueWithHostAnnotation(String annotationType, boolean searchMeta, Set<String> visited) {
        if (this.dimensions > 0) {
            return Collections.emptyMap();
        }
        if (!visited.add(this.getName())) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> collectedResults = new LinkedHashMap<String, List<String>>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<Object> values;
                if (!an.desc.equals(annotationType) || (values = an.values) == null) continue;
                for (int i = 0; i < values.size(); i += 2) {
                    if (!values.get(i).equals("value")) continue;
                    List importedReferences = ((List)values.get(i + 1)).stream().map(t -> t.getDescriptor()).collect(Collectors.toList());
                    collectedResults.put(this.getName().replace("/", "."), importedReferences);
                }
            }
            if (searchMeta) {
                for (AnnotationNode an : this.node.visibleAnnotations) {
                    Type annoType = null;
                    try {
                        annoType = this.typeSystem.Lresolve(an.desc);
                    }
                    catch (MissingTypeException mte) {
                        System.out.println("SBG: WARNING: Unable to find " + an.desc + " skipping...");
                        continue;
                    }
                    collectedResults.putAll(annoType.findAnnotationValueWithHostAnnotation(annotationType, searchMeta, visited));
                }
            }
        }
        return collectedResults;
    }

    public List<String> findAnnotationValue(String annotationType, boolean searchMeta, Set<String> visited) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        if (!visited.add(this.getName())) {
            return Collections.emptyList();
        }
        ArrayList<String> collectedResults = new ArrayList<String>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<Object> values;
                if (!an.desc.equals(annotationType) || (values = an.values) == null) continue;
                for (int i = 0; i < values.size(); i += 2) {
                    if (!values.get(i).equals("value")) continue;
                    return ((List)values.get(i + 1)).stream().map(t -> t.getDescriptor()).collect(Collectors.toCollection(() -> collectedResults));
                }
            }
            if (searchMeta) {
                for (AnnotationNode an : this.node.visibleAnnotations) {
                    Type annoType = this.typeSystem.Lresolve(an.desc);
                    collectedResults.addAll(annoType.findAnnotationValue(annotationType, searchMeta, visited));
                }
            }
        }
        return collectedResults;
    }

    public List<Type> getAnnotations() {
        return this.annotations.get();
    }

    private List<Type> resolveAnnotations() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        List<Type> annotations = new ArrayList<Type>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                try {
                    annotations.add(this.typeSystem.Lresolve(an.desc));
                }
                catch (MissingTypeException missingTypeException) {}
            }
        }
        if (annotations.size() == 0) {
            annotations = NO_ANNOTATIONS;
        }
        return annotations;
    }

    public Type findAnnotation(Type searchType) {
        if (this.dimensions > 0) {
            return null;
        }
        List<Type> annos = this.getAnnotations();
        for (Type anno : annos) {
            if (!anno.equals(searchType)) continue;
            return anno;
        }
        return null;
    }

    public Map.Entry<Type, List<Type>> getRelevantStereotypes() {
        if (this.dimensions > 0) {
            return null;
        }
        ArrayList<Type> relevantAnnotations = new ArrayList<Type>();
        this.collectRelevantStereotypes(this, new HashSet<Type>(), relevantAnnotations);
        List<Type> types = this.getJavaxAnnotations();
        for (Type t : types) {
            if (relevantAnnotations.contains(t)) continue;
            relevantAnnotations.add(t);
        }
        if (!relevantAnnotations.isEmpty()) {
            return new AbstractMap.SimpleImmutableEntry<Type, List<Type>>(this, relevantAnnotations);
        }
        return null;
    }

    private void collectRelevantStereotypes(Type type, Set<Type> seen, List<Type> collector) {
        if (type == null || type.dimensions > 0 || !seen.add(type)) {
            return;
        }
        List<Type> ts = type.getAnnotatedElementsInHierarchy(a -> a.desc.equals("Lorg/springframework/stereotype/Indexed;"));
        for (Type t : ts) {
            if (collector.contains(t)) continue;
            collector.add(t);
        }
        for (Type inttype : type.getInterfaces()) {
            this.collectRelevantStereotypes(inttype, seen, collector);
        }
        this.collectRelevantStereotypes(type.getSuperclass(), seen, collector);
    }

    public Map.Entry<Type, List<Type>> getMetaComponentTaggedAnnotations() {
        if (this.dimensions > 0) {
            return null;
        }
        ArrayList<Type> relevantAnnotations = new ArrayList<Type>();
        List<Type> indexedTypesInHierachy = this.getAnnotatedElementsInHierarchy(a -> a.desc.equals(AtComponent), true);
        for (Type t : indexedTypesInHierachy) {
            if (!t.isAnnotation()) continue;
            relevantAnnotations.add(t);
        }
        if (!relevantAnnotations.isEmpty()) {
            return new AbstractMap.SimpleImmutableEntry<Type, List<Type>>(this, relevantAnnotations);
        }
        return null;
    }

    List<Type> getJavaxAnnotations() {
        return this.getJavaxAnnotations(new HashSet<String>());
    }

    private boolean isAnnotated(String Ldescriptor) {
        if (this.dimensions > 0) {
            return false;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (!an.desc.equals(Ldescriptor)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Type> getAnnotatedElementsInHierarchy(Predicate<AnnotationNode> p) {
        return this.getAnnotatedElementsInHierarchy(p, new HashSet<String>(), false);
    }

    private List<Type> getAnnotatedElementsInHierarchy(Predicate<AnnotationNode> p, boolean includeInterim) {
        return this.getAnnotatedElementsInHierarchy(p, new HashSet<String>(), includeInterim);
    }

    private List<Type> getAnnotatedElementsInHierarchy(Predicate<AnnotationNode> p, Set<String> seen, boolean includeInterim) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> results = new ArrayList<Type>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                boolean match = p.test(an);
                if (!match && !seen.add(an.desc)) continue;
                if (match) {
                    results.add(this);
                    continue;
                }
                Type annoType = this.typeSystem.Lresolve(an.desc, true);
                if (annoType == null) continue;
                List<Type> ts = annoType.getAnnotatedElementsInHierarchy(p, seen, includeInterim);
                if (ts.size() != 0 && includeInterim) {
                    results.add(this);
                }
                results.addAll(ts);
            }
        }
        return results.size() > 0 ? results : Collections.emptyList();
    }

    private List<Type> getJavaxAnnotations(Set<String> seen) {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annoType;
                if (!seen.add(an.desc) || (annoType = this.typeSystem.Lresolve(an.desc, true)) == null) continue;
                if (annoType.getDottedName().startsWith("javax.")) {
                    result.add(annoType);
                    continue;
                }
                List<Type> ts = annoType.getJavaxAnnotations(seen);
                result.addAll(ts);
            }
        }
        return result;
    }

    public List<Type> getNestedTypes() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = null;
        List<InnerClassNode> innerClasses = this.node.innerClasses;
        for (InnerClassNode inner : innerClasses) {
            if (inner.outerName == null || !inner.outerName.equals(this.getName()) || inner.name.equals(this.getName())) continue;
            Type t = this.typeSystem.resolve(inner.name);
            if (result == null) {
                result = new ArrayList<Type>();
            }
            result.add(t);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public String getDescriptor() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            s.append("[");
        }
        s.append("L").append(this.node.name.replace(".", "/")).append(";");
        return s.toString();
    }

    public List<Hint> getHints() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Hint> hints = new ArrayList<Hint>();
        List<CompilationHint> hintx = this.typeSystem.findHints(this.getName());
        if (hintx.size() != 0) {
            ArrayList<Type> s = new ArrayList<Type>();
            s.add(this);
            for (CompilationHint hintxx : hintx) {
                hints.add(new Hint((List<Type>)s, hintxx.skipIfTypesMissing, hintxx.follow, hintxx.getDependantTypes(), Collections.emptyMap(), hintxx.getProxyDescriptors(), hintxx.getResourcesDescriptors(), hintxx.getInitializationDescriptors(), hintxx.applyToFunctional()));
            }
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) {
                    SpringFeature.log("Couldn't resolve " + an.desc + " annotation type whilst searching for hints on " + this.getName());
                    continue;
                }
                Stack<Type> s = new Stack<Type>();
                s.push(this);
                annotationType.collectHints(an, hints, new HashSet<AnnotationNode>(), s);
            }
        }
        try {
            if (this.isImportSelector() && hints.size() == 0) {
                if (ConfigOptions.areMissingSelectorHintsAnError()) {
                    throw new IllegalStateException("No access hint found for import selector: " + this.getDottedName());
                }
                System.out.println("WARNING: No access hint found for import selector: " + this.getDottedName());
            }
        }
        catch (MissingTypeException mte) {
            System.out.println("Unable to determine if type " + this.getName() + " is import selector - can't fully resolve hierarchy - ignoring");
        }
        return hints.size() == 0 ? Collections.emptyList() : hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectHints(AnnotationNode an, List<Hint> hints, Set<AnnotationNode> visited, Stack<Type> annotationChain) {
        if (!visited.add(an)) {
            return;
        }
        try {
            annotationChain.push(this);
            List<CompilationHint> hints2 = this.typeSystem.findHints(an.desc);
            if (hints2.size() != 0) {
                List<String> typesCollectedFromAnnotation = this.collectTypes(an);
                if (an.desc.equals(AtEnableConfigurationProperties)) {
                    this.addInners(typesCollectedFromAnnotation);
                }
                for (CompilationHint hints2a : hints2) {
                    hints.add(new Hint(new ArrayList<Type>(annotationChain), hints2a.skipIfTypesMissing, hints2a.follow, hints2a.getDependantTypes(), this.asMap(typesCollectedFromAnnotation, hints2a.skipIfTypesMissing), hints2a.getProxyDescriptors(), hints2a.getResourcesDescriptors(), hints2a.getInitializationDescriptors(), hints2a.applyToFunctional()));
                }
            }
            if (this.node.visibleAnnotations != null) {
                for (AnnotationNode an2 : this.node.visibleAnnotations) {
                    Type annotationType = this.typeSystem.Lresolve(an2.desc, true);
                    if (annotationType == null) {
                        SpringFeature.log("Couldn't resolve " + an2.desc + " annotation type whilst searching for hints on " + this.getName());
                        continue;
                    }
                    annotationType.collectHints(an2, hints, visited, annotationChain);
                }
            }
        }
        finally {
            annotationChain.pop();
        }
    }

    private void addInners(List<String> propertiesTypes) {
        ArrayList<String> extras = new ArrayList<String>();
        for (String propertiesType : propertiesTypes) {
            Type type = this.typeSystem.Lresolve(propertiesType, true);
            if (type == null) continue;
            List<Type> nestedTypes = type.getNestedTypes();
            for (Type nestedType : nestedTypes) {
                extras.add(nestedType.getDescriptor());
            }
        }
        propertiesTypes.addAll(extras);
    }

    private Map<String, Integer> asMap(List<String> typesCollectedFromAnnotation, boolean usingForVisibilityCheck) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String t : typesCollectedFromAnnotation) {
            Type type = this.typeSystem.Lresolve(t, true);
            int ar = -1;
            ar = usingForVisibilityCheck ? 2 : Type.inferAccessRequired(type);
            map.put(Type.fromLdescriptorToDotted(t), ar);
        }
        return map;
    }

    private Type[] getMemberTypes() {
        if (this.dimensions > 0) {
            return new Type[0];
        }
        ArrayList<Type> result = new ArrayList<Type>();
        List<InnerClassNode> nestMembers = this.node.innerClasses;
        if (nestMembers != null) {
            for (InnerClassNode icn : nestMembers) {
                if (!icn.name.startsWith(this.getName() + "$")) continue;
                result.add(this.typeSystem.resolveSlashed(icn.name));
            }
            System.out.println(this.getName() + " has inners " + nestMembers.stream().map(f -> "oo=" + this.getDescriptor() + "::o=" + f.outerName + "::n=" + f.name + "::in=" + f.innerName).collect(Collectors.joining(",")) + "  >> " + result);
        }
        return result.toArray(new Type[0]);
    }

    private List<CompilationHint> findCompilationHintHelper(HashSet<Type> visited) {
        if (!visited.add(this)) {
            return null;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<CompilationHint> compilationHints = this.typeSystem.findHints(an.desc);
                if (compilationHints.size() != 0) {
                    return compilationHints;
                }
                Type resolvedAnnotation = this.typeSystem.Lresolve(an.desc);
                compilationHints = resolvedAnnotation.findCompilationHintHelper(visited);
                if (compilationHints.size() == 0) continue;
                return compilationHints;
            }
        }
        return null;
    }

    private List<String> collectTypes(AnnotationNode an) {
        List<Object> values = an.values;
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                if (!values.get(i).equals("value")) continue;
                Object object = values.get(i + 1);
                ArrayList<String> importedReferences = null;
                if (object instanceof List) {
                    importedReferences = ((List)object).stream().map(t -> t.getDescriptor()).collect(Collectors.toList());
                } else {
                    importedReferences = new ArrayList<String>();
                    importedReferences.add(((sbg.asm.Type)object).getDescriptor());
                }
                return importedReferences;
            }
        }
        return Collections.emptyList();
    }

    public boolean isImportSelector() {
        try {
            return this.implementsInterface(Type.fromLdescriptorToSlashed(ImportSelector));
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    public boolean isApplicationListener() {
        try {
            return this.implementsInterface(Type.fromLdescriptorToSlashed(ApplicationListener));
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    public boolean isBeanFactoryPostProcessor() {
        try {
            return this.implementsInterface(Type.fromLdescriptorToSlashed(BeanFactoryPostProcessor));
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    public boolean isImportRegistrar() {
        try {
            return this.implementsInterface(Type.fromLdescriptorToSlashed(ImportBeanDefinitionRegistrar));
        }
        catch (MissingTypeException mte) {
            return false;
        }
    }

    public static String fromLdescriptorToSlashed(String Ldescriptor) {
        int dims = 0;
        int p = 0;
        if (Ldescriptor.startsWith("[")) {
            while (Ldescriptor.charAt(p) == '[') {
                ++p;
                ++dims;
            }
        }
        StringBuilder r = new StringBuilder();
        r.append(Ldescriptor.substring(p + 1, Ldescriptor.length() - 1));
        for (int i = 0; i < dims; ++i) {
            r.append("[]");
        }
        return r.toString();
    }

    public static String fromLdescriptorToDotted(String Ldescriptor) {
        return Type.fromLdescriptorToSlashed(Ldescriptor).replace("/", ".");
    }

    private List<CompilationHint> findCompilationHint(Type annotationType) {
        String descriptor = "L" + annotationType.getName().replace(".", "/") + ";";
        List<CompilationHint> hints = this.typeSystem.findHints(descriptor);
        if (hints.size() != 0) {
            return hints;
        }
        return annotationType.findCompilationHintHelper(new HashSet<Type>());
    }

    public void collectMissingAnnotationTypesHelper(Set<String> missingAnnotationTypes, HashSet<Type> visited) {
        if (this.dimensions > 0) {
            return;
        }
        if (!visited.add(this)) {
            return;
        }
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                Type annotationType = this.typeSystem.Lresolve(an.desc, true);
                if (annotationType == null) {
                    missingAnnotationTypes.add(an.desc.substring(0, an.desc.length() - 1).replace("/", "."));
                    continue;
                }
                annotationType.collectMissingAnnotationTypesHelper(missingAnnotationTypes, visited);
            }
        }
    }

    public int getMethodCount() {
        return this.node.methods.size();
    }

    public boolean isAnnotation() {
        if (this.dimensions > 0) {
            return false;
        }
        return (this.node.access & 0x2000) != 0;
    }

    public List<Type> getAutoConfigureBeforeOrAfter() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> result = new ArrayList<Type>();
        for (AnnotationNode an : this.node.visibleAnnotations) {
            List<Object> values;
            if (!an.desc.equals("Lorg/springframework/boot/autoconfigure/AutoConfigureAfter;") && !an.desc.equals("Lorg/springframework/boot/autoconfigure/AutoConfigureBefore;") || (values = an.values) == null) continue;
            for (int i = 0; i < values.size(); i += 2) {
                if (!values.get(i).equals("value")) continue;
                List types = (List)values.get(i + 1);
                for (sbg.asm.Type type : types) {
                    Type t = this.typeSystem.Lresolve(type.getDescriptor(), true);
                    if (t == null) continue;
                    result.add(t);
                }
            }
        }
        return result;
    }

    public boolean hasOnlySimpleConstructor() {
        if (this.dimensions > 0) {
            return false;
        }
        boolean hasCtor = false;
        List<MethodNode> methods = this.node.methods;
        for (MethodNode mn : methods) {
            if (!mn.name.equals("<init>")) continue;
            if (mn.desc.equals("()V")) {
                hasCtor = true;
                continue;
            }
            return false;
        }
        return hasCtor;
    }

    public List<CompilationHint> unpackConfigurationHints() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        ArrayList<CompilationHint> hints = null;
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                if (Type.fromLdescriptorToDotted(an.desc).equals(NativeImageHint.class.getName())) {
                    CompilationHint hint = this.fromConfigurationHintToCompilationHint(an);
                    if (hints == null) {
                        hints = new ArrayList<CompilationHint>();
                    }
                    hints.add(hint);
                    continue;
                }
                if (!Type.fromLdescriptorToDotted(an.desc).equals(NativeImageHints.class.getName())) continue;
                List<CompilationHint> chints = this.fromConfigurationHintsToCompilationHints(an);
                if (hints == null) {
                    hints = new ArrayList();
                }
                hints.addAll(chints);
            }
        }
        return hints == null ? Collections.emptyList() : hints;
    }

    private CompilationHint fromConfigurationHintToCompilationHint(AnnotationNode an) {
        CompilationHint ch = new CompilationHint();
        List<Object> values = an.values;
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                Boolean b;
                String key = (String)values.get(i);
                Object value = values.get(i + 1);
                if (key.equals("trigger")) {
                    ch.setTargetType(((sbg.asm.Type)value).getClassName());
                    continue;
                }
                if (key.equals("applyToFunctional")) {
                    ch.setApplyToFunctional((Boolean)value);
                    continue;
                }
                if (key.equals("typeInfos")) {
                    this.processTypeInfoList(ch, value);
                    continue;
                }
                if (key.equals("importInfos")) {
                    this.processImportInfos(ch, value);
                    continue;
                }
                if (key.equals("proxyInfos")) {
                    this.processProxyInfo(ch, value);
                    continue;
                }
                if (key.equals("resourcesInfos")) {
                    this.processResourcesInfos(ch, value);
                    continue;
                }
                if (key.equals("initializationInfos")) {
                    this.processInitializationInfos(ch, value);
                    continue;
                }
                if (key.equals("abortIfTypesMissing")) {
                    b = (Boolean)value;
                    ch.setAbortIfTypesMissing(b);
                    continue;
                }
                if (key.equals("follow")) {
                    b = (Boolean)value;
                    ch.setFollow(b);
                    continue;
                }
                if (key.equals("extractTypesFromAttributes")) continue;
                System.out.println("annotation " + key + "=" + value + "(" + value.getClass() + ")");
            }
        }
        if (ch.getTargetType() == null) {
            ch.setTargetType("java.lang.Object");
        }
        return ch;
    }

    private void processResourcesInfos(CompilationHint ch, Object value) {
        List resourcesInfos = (List)value;
        for (AnnotationNode resourcesInfo : resourcesInfos) {
            this.unpackResourcesInfo(resourcesInfo, ch);
        }
    }

    private void processInitializationInfos(CompilationHint ch, Object value) {
        List initializationInfos = (List)value;
        for (AnnotationNode initializationInfo : initializationInfos) {
            this.unpackInitializationInfo(initializationInfo, ch);
        }
    }

    private void processTypeInfoList(CompilationHint ch, Object value) {
        List typeInfos = (List)value;
        for (AnnotationNode typeInfo : typeInfos) {
            this.unpackTypeInfo(typeInfo, ch);
        }
    }

    private void processFieldInfoList(List<FieldDescriptor> fds, Object value) {
        List fieldInfos = (List)value;
        for (AnnotationNode fieldInfo : fieldInfos) {
            this.unpackFieldInfo(fieldInfo, fds);
        }
    }

    private void processMethodInfoList(List<MethodDescriptor> mds, Object value) {
        List methodInfos = (List)value;
        for (AnnotationNode methodInfo : methodInfos) {
            this.unpackMethodInfo(methodInfo, mds);
        }
    }

    private void processProxyInfo(CompilationHint ch, Object value) {
        List proxyInfos = (List)value;
        for (AnnotationNode proxyInfo : proxyInfos) {
            this.unpackProxyInfo(proxyInfo, ch);
        }
    }

    private void processImportInfos(CompilationHint ch, Object value) {
        ArrayList importInfos = (ArrayList)value;
        for (sbg.asm.Type importInfo : importInfos) {
            String className = importInfo.getClassName();
            Type resolvedImportInfo = this.typeSystem.resolveDotted(className, true);
            if (resolvedImportInfo == null) {
                throw new IllegalStateException("Cannot find importInfos referenced type: " + className);
            }
            ClassNode node = resolvedImportInfo.getClassNode();
            if (node.visibleAnnotations == null) continue;
            for (AnnotationNode an : node.visibleAnnotations) {
                String annotationClassname = Type.fromLdescriptorToDotted(an.desc);
                if (annotationClassname.equals(TypeInfo.class.getName())) {
                    this.unpackTypeInfo(an, ch);
                    continue;
                }
                if (annotationClassname.equals(TypeInfos.class.getName())) {
                    this.processTypeInfosList(ch, an);
                    continue;
                }
                if (annotationClassname.equals(ResourcesInfo.class.getName())) {
                    this.unpackResourcesInfo(an, ch);
                    continue;
                }
                if (annotationClassname.equals(ResourcesInfos.class.getName())) {
                    this.processRepeatableInfosList(an, anno -> this.unpackResourcesInfo((AnnotationNode)anno, ch));
                    continue;
                }
                if (annotationClassname.equals(ProxyInfo.class.getName())) {
                    this.unpackProxyInfo(an, ch);
                    continue;
                }
                if (annotationClassname.equals(ProxyInfos.class.getName())) {
                    this.processRepeatableInfosList(an, anno -> this.unpackProxyInfo((AnnotationNode)anno, ch));
                    continue;
                }
                if (annotationClassname.equals(InitializationInfo.class.getName())) {
                    this.unpackInitializationInfo(an, ch);
                    continue;
                }
                if (!annotationClassname.equals(InitializationInfos.class.getName())) continue;
                this.processRepeatableInfosList(an, anno -> this.unpackInitializationInfo((AnnotationNode)anno, ch));
            }
        }
    }

    ClassNode getClassNode() {
        return this.node;
    }

    private void unpackTypeInfo(AnnotationNode typeInfo, CompilationHint ch) {
        List<Object> values = typeInfo.values;
        ArrayList types = new ArrayList();
        ArrayList typeNames = new ArrayList();
        int accessRequired = -1;
        ArrayList<MethodDescriptor> mds = new ArrayList<MethodDescriptor>();
        ArrayList<FieldDescriptor> fds = new ArrayList<FieldDescriptor>();
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("types")) {
                types = (ArrayList)value;
                continue;
            }
            if (key.equals("access")) {
                accessRequired = (Integer)value;
                continue;
            }
            if (key.equals("typeNames")) {
                typeNames = (ArrayList)value;
                continue;
            }
            if (key.equals("methods")) {
                this.processMethodInfoList(mds, value);
                continue;
            }
            if (!key.equals("fields")) continue;
            this.processFieldInfoList(fds, value);
        }
        for (sbg.asm.Type type : types) {
            ch.addDependantType(type.getClassName(), (Integer)(accessRequired == -1 ? this.inferAccessRequired(type) : accessRequired), mds, fds);
        }
        for (String typeName : typeNames) {
            Type resolvedType = this.typeSystem.resolveName(typeName, true);
            if (resolvedType == null) continue;
            ch.addDependantType(typeName, (Integer)(accessRequired == -1 ? Type.inferAccessRequired(resolvedType) : accessRequired), mds, fds);
        }
    }

    private void unpackFieldInfo(AnnotationNode fieldInfo, List<FieldDescriptor> fds) {
        List<Object> values = fieldInfo.values;
        String name = null;
        boolean allowUnsafeAccess = false;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("allowUnsafeAccess")) {
                allowUnsafeAccess = (Boolean)value;
                continue;
            }
            if (!key.equals("name")) continue;
            name = (String)value;
        }
        fds.add(new FieldDescriptor(name, allowUnsafeAccess));
    }

    private void unpackMethodInfo(AnnotationNode methodInfo, List<MethodDescriptor> mds) {
        List<Object> values = methodInfo.values;
        ArrayList parameterTypes = new ArrayList();
        String name = null;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("parameterTypes")) {
                parameterTypes = (ArrayList)value;
                continue;
            }
            if (!key.equals("name")) continue;
            name = (String)value;
        }
        boolean unresolvable = false;
        ArrayList<String> resolvedParameterTypes = new ArrayList<String>();
        for (sbg.asm.Type ptype : parameterTypes) {
            String typeName = ptype.getClassName();
            Type resolvedType = this.typeSystem.resolveName(typeName, true);
            if (resolvedType != null) {
                resolvedParameterTypes.add(typeName);
                continue;
            }
            unresolvable = true;
        }
        if (unresolvable) {
            StringBuilder message = new StringBuilder();
            for (sbg.asm.Type ptype : parameterTypes) {
                message.append(ptype.getClassName()).append(" ");
            }
            SpringFeature.log("Unable to fully resolve method " + name + "(" + message.toString().trim() + ")");
        } else {
            mds.add(new MethodDescriptor(name, resolvedParameterTypes));
        }
    }

    private void unpackProxyInfo(AnnotationNode typeInfo, CompilationHint ch) {
        List<Object> values = typeInfo.values;
        ArrayList types = new ArrayList();
        ArrayList typeNames = new ArrayList();
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("types")) {
                types = (ArrayList)value;
                continue;
            }
            if (!key.equals("typeNames")) continue;
            typeNames = (ArrayList)value;
        }
        ArrayList<String> proxyTypes = new ArrayList<String>();
        boolean typeMissing = false;
        for (sbg.asm.Type type : types) {
            String typeName = type.getClassName();
            Type resolvedType = this.typeSystem.resolveName(typeName, true);
            if (resolvedType != null) {
                proxyTypes.add(typeName);
                continue;
            }
            typeMissing = true;
        }
        for (String typeName : typeNames) {
            Type resolvedType = this.typeSystem.resolveName(typeName, true);
            if (resolvedType != null) {
                proxyTypes.add(typeName);
                continue;
            }
            typeMissing = true;
        }
        if (!typeMissing) {
            ch.addProxyDescriptor(new ProxyDescriptor(proxyTypes.toArray(new String[0])));
        }
    }

    private void unpackResourcesInfo(AnnotationNode typeInfo, CompilationHint ch) {
        List<Object> values = typeInfo.values;
        List patterns = null;
        Boolean isBundle = null;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("patterns")) {
                patterns = (ArrayList)value;
                continue;
            }
            if (!key.equals("isBundle")) continue;
            isBundle = (Boolean)value;
        }
        ch.addResourcesDescriptor(new ResourcesDescriptor(patterns.toArray(new String[0]), isBundle == null ? false : isBundle));
    }

    private void unpackInitializationInfo(AnnotationNode typeInfo, CompilationHint ch) {
        List<Object> values = typeInfo.values;
        ArrayList types = new ArrayList();
        ArrayList typeNames = new ArrayList();
        ArrayList packageNames = new ArrayList();
        InitializationTime initTime = null;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (key.equals("types")) {
                types = (ArrayList)value;
                continue;
            }
            if (key.equals("typeNames")) {
                typeNames = (ArrayList)value;
                continue;
            }
            if (key.equals("packageNames")) {
                packageNames = (ArrayList)value;
                continue;
            }
            if (!key.equals("initTime")) continue;
            initTime = InitializationTime.valueOf(((String[])value)[1]);
        }
        for (sbg.asm.Type type : types) {
            String typeName = type.getClassName();
            typeNames.add(typeName);
        }
        InitializationDescriptor id = new InitializationDescriptor();
        if (initTime == InitializationTime.BUILD) {
            for (String typeName : typeNames) {
                id.addBuildtimeClass(typeName);
            }
            for (String packageName : packageNames) {
                id.addBuildtimePackage(packageName);
            }
        } else {
            for (String typeName : typeNames) {
                id.addRuntimeClass(typeName);
            }
            for (String packageName : packageNames) {
                id.addRuntimePackage(packageName);
            }
        }
        ch.addInitializationDescriptor(id);
    }

    private int inferAccessRequired(sbg.asm.Type type) {
        Type t = this.typeSystem.resolve(type, true);
        return Type.inferAccessRequired(t);
    }

    public boolean isConfigurationProperties() {
        return this.dimensions > 0 ? false : this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtConfigurationProperties), new HashSet<String>());
    }

    public static int inferAccessRequired(Type t) {
        if (t == null) {
            return 31;
        }
        if (t.isAtConfiguration() || t.isMetaImportAnnotated()) {
            return 31;
        }
        if (t.isImportSelector()) {
            return 7;
        }
        if (t.isImportRegistrar()) {
            return 6;
        }
        if (t.isBeanFactoryPostProcessor()) {
            return 15;
        }
        if (t.isArray()) {
            return 2;
        }
        if (t.isConfigurationProperties()) {
            return 14;
        }
        if (t.isCondition()) {
            return 6;
        }
        if (t.isComponent() || t.isApplicationListener()) {
            return 31;
        }
        return 30;
    }

    private List<CompilationHint> fromConfigurationHintsToCompilationHints(AnnotationNode an) {
        ArrayList<CompilationHint> chs = new ArrayList<CompilationHint>();
        List<Object> values = an.values;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (!key.equals("value")) continue;
            List annotationNodes = (List)value;
            for (int j = 0; j < annotationNodes.size(); ++j) {
                chs.add(this.fromConfigurationHintToCompilationHint((AnnotationNode)annotationNodes.get(j)));
            }
        }
        return chs;
    }

    private void processTypeInfosList(CompilationHint ch, AnnotationNode an) {
        List<Object> values = an.values;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (!key.equals("value")) continue;
            List annotationNodes = (List)value;
            for (int j = 0; j < annotationNodes.size(); ++j) {
                this.unpackTypeInfo((AnnotationNode)annotationNodes.get(j), ch);
            }
        }
    }

    private void processRepeatableInfosList(AnnotationNode an, Consumer<AnnotationNode> c) {
        List<Object> values = an.values;
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            if (!key.equals("value")) continue;
            List annotationNodes = (List)value;
            for (int j = 0; j < annotationNodes.size(); ++j) {
                c.accept((AnnotationNode)annotationNodes.get(j));
            }
        }
    }

    public List<CompilationHint> getCompilationHints() {
        if (this.dimensions > 0) {
            return Collections.emptyList();
        }
        return this.unpackConfigurationHints();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public boolean isTransactional() {
        return this.isAnnotated(AtTransactional) || this.isAnnotated(AtJavaxTransactional);
    }

    public boolean hasTransactionalMethods() {
        List<Method> methodsWithAtTransactional = this.getMethodsWithAnnotation(AtTransactional);
        if (methodsWithAtTransactional.size() > 0) {
            return true;
        }
        List<Method> methodsWithAtJavaxTransactional = this.getMethodsWithAnnotation(AtJavaxTransactional);
        return methodsWithAtJavaxTransactional.size() > 0;
    }

    public boolean isAnnotatedInHierarchy(String anno) {
        if (this.isAnnotated(AtTransactional)) {
            return true;
        }
        List<Method> methodsWithAnnotation = this.getMethodsWithAnnotation(anno);
        if (methodsWithAnnotation.size() != 0) {
            return true;
        }
        Type superclass = this.getSuperclass();
        if (superclass != null && superclass.isAnnotatedInHierarchy(anno)) {
            return true;
        }
        Type[] intfaces = this.getInterfaces();
        if (intfaces != null) {
            for (Type intface : intfaces) {
                if (!intface.isAnnotatedInHierarchy(anno)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> collectTypeParameterNames() {
        return null;
    }

    public boolean isAtRepository() {
        return this.isAnnotated(AtRepository);
    }

    public boolean isAtResponseBody() {
        boolean b = this.hasAnnotation(AtResponseBody, true);
        return b;
    }

    public Collection<Type> collectAtMappingMarkedReturnTypes() {
        LinkedHashSet<Type> returnTypes = new LinkedHashSet<Type>();
        List<Method> methodsWithAnnotation = this.getMethodsWithAnnotation(AtMapping, true);
        for (Method m : methodsWithAnnotation) {
            returnTypes.add(m.getReturnType());
        }
        return returnTypes;
    }

    public String findTypeParameterInSupertype(String supertype, int typeParameterNumber) {
        if (this.node.signature == null) {
            return null;
        }
        SignatureReader reader = new SignatureReader(this.node.signature);
        TypeParamFinder tpm = new TypeParamFinder(supertype);
        reader.accept(tpm);
        return tpm.getTypeParameter(typeParameterNumber);
    }

    public String fetchReactiveCrudRepositoryType() {
        return this.findTypeParameterInSupertype("org.springframework.data.repository.reactive.ReactiveCrudRepository", 0);
    }

    public String fetchCrudRepositoryType() {
        return this.findTypeParameterInSupertype("org.springframework.data.repository.CrudRepository", 0);
    }

    public String fetchJpaRepositoryType() {
        return this.findTypeParameterInSupertype("org.springframework.data.jpa.repository.JpaRepository", 0);
    }

    public void verifyComponent() {
        this.verifyProxyBeanMethodsSetting();
    }

    private void verifyProxyBeanMethodsSetting() {
        List<Method> methodsWithAtBean = this.getMethodsWithAtBean();
        if (methodsWithAtBean.size() != 0) {
            List<AnnotationNode> annos = this.collectAnnotations();
            annos = this.filterAnnotations(annos, an -> {
                Type annotationType = this.typeSystem.Lresolve(an.desc);
                return annotationType.hasMethod("proxyBeanMethods");
            });
            boolean atLeastSetFalseSomewhere = false;
            for (AnnotationNode anode : annos) {
                Boolean value;
                if (!this.hasValue(anode, "proxyBeanMethods") || (value = (Boolean)this.getValue(anode, "proxyBeanMethods")).booleanValue()) continue;
                atLeastSetFalseSomewhere = true;
            }
            if (!atLeastSetFalseSomewhere) {
                System.out.println("[verification] Warning: component " + this.getDottedName() + " does not specify annotation value proxyBeanMethods=false to avoid CGLIB proxies");
            }
        }
    }

    private Object getValue(AnnotationNode anode, String name) {
        List<Object> values = anode.values;
        for (int i = 0; i < values.size(); i += 2) {
            if (!values.get(i).toString().equals(name)) continue;
            return values.get(i + 1);
        }
        return new IllegalStateException("Attribute " + name + " not set on the specified annotation, precede this call to getValue() with a hasValue() check");
    }

    private boolean hasValue(AnnotationNode node, String name) {
        List<Object> values = node.values;
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                if (!values.get(i).toString().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMethod(String methodName) {
        List<MethodNode> methods = this.node.methods;
        for (MethodNode method : methods) {
            if (!method.name.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private List<AnnotationNode> filterAnnotations(List<AnnotationNode> input, Predicate<AnnotationNode> filter) {
        return input.stream().filter(filter).collect(Collectors.toList());
    }

    private List<AnnotationNode> collectAnnotations() {
        ArrayList<AnnotationNode> resultsHolder = new ArrayList<AnnotationNode>();
        this.collectAnnotationsHelper(resultsHolder, new HashSet<String>());
        return resultsHolder;
    }

    private void collectAnnotationsHelper(List<AnnotationNode> collector, Set<String> seen) {
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode anno : this.node.visibleAnnotations) {
                if (!seen.add(anno.desc)) continue;
                collector.add(anno);
                Type annotationType = this.typeSystem.Lresolve(anno.desc);
                annotationType.collectAnnotationsHelper(collector, seen);
            }
        }
    }

    public List<Method> getMethods(Predicate<Method> predicate) {
        return this.dimensions > 0 ? Collections.emptyList() : this.node.methods.stream().map(m -> this.wrap((MethodNode)m)).filter(m -> predicate.test((Method)m)).collect(Collectors.toList());
    }

    public boolean equals(Object that) {
        return that instanceof Type && ((Type)that).name.equals(this.name) && ((Type)that).dimensions == this.dimensions && ((Type)that).node.equals(this.node);
    }

    public int hashCode() {
        return this.node.hashCode() * 37;
    }

    public Type getEnclosingType() {
        String n = this.getDottedName();
        int idx = n.lastIndexOf("$");
        if (idx == -1) {
            return null;
        }
        Type t = this.typeSystem.resolveDotted(n.substring(0, idx), true);
        if (t == null) {
            return null;
        }
        return t;
    }

    public boolean checkConditionalOnWebApplication() {
        if (this.node.visibleAnnotations != null) {
            for (AnnotationNode an : this.node.visibleAnnotations) {
                List<Object> values;
                if (!an.desc.equals("Lorg/springframework/boot/autoconfigure/condition/ConditionalOnWebApplication;") || (values = an.values) == null) continue;
                for (int i = 0; i < values.size(); i += 2) {
                    if (!values.get(i).equals("type")) continue;
                    String webApplicationType = ((String[])values.get(i + 1))[1];
                    if (webApplicationType.equals("SERVLET")) {
                        return this.typeSystem.resolveDotted("org.springframework.web.context.support.GenericWebApplicationContext", true) != null;
                    }
                    if (!webApplicationType.equals("REACTIVE")) continue;
                    return this.typeSystem.resolveDotted("org.springframework.web.reactive.HandlerResult", true) != null;
                }
            }
        }
        return true;
    }

    public boolean hasAliasForMarkedMembers() {
        for (Method m : this.getMethods()) {
            if (!m.hasAliasForAnnotation()) continue;
            return true;
        }
        return false;
    }

    public void collectAliasReferencedMetas(Set<String> collector) {
        boolean usesLocalAliases = false;
        for (Method m : this.getMethods()) {
            Pair<String, Boolean> aliasForInfo = m.getAliasForSummary();
            if (aliasForInfo == null) continue;
            String relatedMetaAnnotation = aliasForInfo.getA();
            if (relatedMetaAnnotation == null) {
                usesLocalAliases |= aliasForInfo.getB().booleanValue();
                continue;
            }
            collector.add(relatedMetaAnnotation);
        }
        if (usesLocalAliases) {
            collector.add(this.getDottedName());
        }
    }

    public boolean isMetaImportAnnotated() {
        return this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtImports));
    }

    public boolean isComponent() {
        return this.isMetaAnnotated(Type.fromLdescriptorToSlashed(AtComponent));
    }

    public boolean isConditional() {
        return this.implementsInterface("org/springframework/context/annotation/Condition") || this.isMetaAnnotated("org/springframework/context/annotation/Conditional");
    }

    public void collectAnnotations(List<Type> collector, Predicate<Type> filter) {
        if (!this.isAnnotation()) {
            throw new IllegalStateException(this.getDottedName() + " is not an annotation");
        }
        this.walkAnnotation(collector, filter, new HashSet<Type>());
    }

    private void walkAnnotation(List<Type> collector, Predicate<Type> filter, Set<Type> seen) {
        if (!seen.add(this)) {
            return;
        }
        if (filter.test(this)) {
            collector.add(this);
        }
        List<Type> annotations = this.getAnnotations();
        for (Type annotation : annotations) {
            annotation.walkAnnotation(collector, filter, seen);
        }
    }

    public Field getField(String name) {
        for (Field field : this.fields.get()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List<String> getImportedConfigurations() {
        List<String> importedConfigurations = this.findAnnotationValueWithHostAnnotation(AtImportAutoConfiguration, false, new HashSet<String>()).get(this.getDottedName());
        return importedConfigurations == null ? Collections.emptyList() : importedConfigurations;
    }

    static {
        validBoxing.add("Ljava/lang/Byte;B");
        validBoxing.add("Ljava/lang/Character;C");
        validBoxing.add("Ljava/lang/Double;D");
        validBoxing.add("Ljava/lang/Float;F");
        validBoxing.add("Ljava/lang/Integer;I");
        validBoxing.add("Ljava/lang/Long;J");
        validBoxing.add("Ljava/lang/Short;S");
        validBoxing.add("Ljava/lang/Boolean;Z");
        validBoxing.add("BLjava/lang/Byte;");
        validBoxing.add("CLjava/lang/Character;");
        validBoxing.add("DLjava/lang/Double;");
        validBoxing.add("FLjava/lang/Float;");
        validBoxing.add("ILjava/lang/Integer;");
        validBoxing.add("JLjava/lang/Long;");
        validBoxing.add("SLjava/lang/Short;");
        validBoxing.add("ZLjava/lang/Boolean;");
        NO_ANNOTATIONS = Collections.emptyList();
    }

    static class TypeParamFinder
    extends SignatureVisitor {
        String typeparameter;
        List<String> types = null;
        private String supertype;
        private boolean nextIsBoundType = false;
        private boolean collectTypeParams = false;
        private List<String> typeParams = new ArrayList<String>();

        public TypeParamFinder(String supertype) {
            super(458752);
            this.supertype = supertype.replace(".", "/");
        }

        public String getTypeParameter(int typeParameterNumber) {
            if (typeParameterNumber >= this.typeParams.size()) {
                return null;
            }
            return this.typeParams.get(typeParameterNumber).replace("/", ".");
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            this.nextIsBoundType = true;
            this.collectTypeParams = false;
            return super.visitSuperclass();
        }

        @Override
        public SignatureVisitor visitInterface() {
            this.nextIsBoundType = true;
            this.collectTypeParams = false;
            return super.visitInterface();
        }

        @Override
        public void visitClassType(String name) {
            if (this.nextIsBoundType && name.equals(this.supertype)) {
                this.collectTypeParams = true;
            } else if (this.collectTypeParams) {
                this.typeParams.add(name);
            }
            super.visitClassType(name);
            this.nextIsBoundType = false;
        }
    }

    static class TypeCollector
    extends SignatureVisitor {
        List<String> types = null;

        public TypeCollector() {
            super(458752);
        }

        @Override
        public void visitClassType(String name) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(name);
        }

        public List<String> getTypes() {
            if (this.types == null) {
                return Collections.emptyList();
            }
            return this.types;
        }
    }
}

