/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Map;
import org.springframework.graalvm.substitutions.OnlyIfPresent;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.support.DefaultClientCodecConfigurer;
import org.springframework.http.codec.support.DefaultServerCodecConfigurer;

@TargetClass(className="org.springframework.http.codec.CodecConfigurerFactory", onlyWith={OnlyIfPresent.class})
final class Target_CodecConfigurerFactory {
    @Delete
    private static String DEFAULT_CONFIGURERS_PATH;
    @Delete
    private static Map<Class<?>, Class<?>> defaultCodecConfigurers;

    Target_CodecConfigurerFactory() {
    }

    @Substitute
    public static <T extends CodecConfigurer> T create(Class<T> ifc) {
        if (ifc == ClientCodecConfigurer.class) {
            return (T)new DefaultClientCodecConfigurer();
        }
        if (ifc == ServerCodecConfigurer.class) {
            return (T)new DefaultServerCodecConfigurer();
        }
        throw new IllegalStateException("No default codec configurer found for " + ifc);
    }
}

