/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.http.config.HttpAdapterParsingUtils;
import org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HttpOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpRequestExecutingMessageHandler.class);
        HttpAdapterParsingUtils.configureUrlConstructorArg(element, parserContext, builder);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"encode-uri");
        HttpAdapterParsingUtils.setHttpMethodOrExpression(element, parserContext, builder);
        String restTemplate = element.getAttribute("rest-template");
        if (StringUtils.hasText((String)restTemplate)) {
            HttpAdapterParsingUtils.verifyNoRestTemplateAttributes(element, parserContext);
            builder.addConstructorArgReference(restTemplate);
        } else {
            for (String referenceAttributeName : HttpAdapterParsingUtils.REST_TEMPLATE_REFERENCE_ATTRIBUTES) {
                IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)referenceAttributeName);
            }
        }
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        String mappedResponseHeaders = element.getAttribute("mapped-response-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders) || StringUtils.hasText((String)mappedResponseHeaders)) {
                parserContext.getReaderContext().error("Neither 'mappped-request-headers' or 'mapped-response-headers' attributes are allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
                return null;
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.support.DefaultHttpHeaderMapper");
            headerMapperBuilder.setFactoryMethod("outboundMapper");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"outboundHeaderNames");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-response-headers", (String)"inboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-request-payload", (String)"extractPayload");
        HttpAdapterParsingUtils.setExpectedResponseOrExpression(element, parserContext, builder);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        HttpAdapterParsingUtils.configureUriVariableExpressions(builder, element);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"transfer-cookies");
        return builder;
    }
}

