/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.http.converter.MultipartAwareFormHttpMessageConverter;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.json.JacksonJsonUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerMapping;

public abstract class HttpRequestHandlingEndpointSupport
extends MessagingGatewaySupport
implements OrderlyShutdownCapable {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent((String)"com.sun.syndication.feed.WireFeed", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static final List<HttpMethod> nonReadableBodyHttpMethods = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS);
    private final List<HttpMessageConverter<?>> defaultMessageConverters = new ArrayList();
    private volatile List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private volatile RequestMapping requestMapping = new RequestMapping();
    private volatile Class<?> requestPayloadType = null;
    private volatile boolean convertersMerged;
    private volatile boolean mergeWithDefaultConverters = false;
    private volatile HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.inboundMapper();
    private final boolean expectReply;
    private volatile boolean extractReplyPayload = true;
    private volatile MultipartResolver multipartResolver;
    private volatile Expression payloadExpression;
    private volatile Map<String, Expression> headerExpressions;
    private volatile boolean shuttingDown;
    private final AtomicInteger activeCount = new AtomicInteger();

    public HttpRequestHandlingEndpointSupport() {
        this(true);
    }

    public HttpRequestHandlingEndpointSupport(boolean expectReply) {
        this.expectReply = expectReply;
        this.defaultMessageConverters.add(new MultipartAwareFormHttpMessageConverter());
        this.defaultMessageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.defaultMessageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.defaultMessageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        SourceHttpMessageConverter sourceConverter = new SourceHttpMessageConverter();
        this.defaultMessageConverters.add((HttpMessageConverter<?>)sourceConverter);
        if (jaxb2Present) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'Jaxb2RootElementHttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        }
        if (JacksonJsonUtils.isJackson2Present()) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'MappingJackson2HttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        } else if (JacksonJsonUtils.isJacksonPresent()) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new MappingJacksonHttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'MappingJacksonHttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        }
        if (romePresent) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'AtomFeedHttpMessageConverter' was added to the 'defaultMessageConverters'.");
                this.logger.debug((Object)"'RssChannelHttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        }
    }

    protected boolean isExpectReply() {
        return this.expectReply;
    }

    @Deprecated
    public void setPath(String path) {
        this.requestMapping.setPathPatterns(path);
    }

    @Deprecated
    String getPath() {
        Object[] pathPatterns = this.requestMapping.getPathPatterns();
        return !ObjectUtils.isEmpty((Object[])pathPatterns) ? pathPatterns[0] : null;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.noNullElements((Object[])messageConverters.toArray(), (String)"'messageConverters' must not contain null entries");
        ArrayList localConverters = new ArrayList(messageConverters);
        if (this.mergeWithDefaultConverters) {
            localConverters.addAll(this.defaultMessageConverters);
            this.convertersMerged = true;
        }
        this.messageConverters = localConverters;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        this.mergeWithDefaultConverters = mergeWithDefaultConverters;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setRequestMapping(RequestMapping requestMapping) {
        Assert.notNull((Object)requestMapping, (String)"requestMapping must not be null");
        this.requestMapping = requestMapping;
    }

    public final RequestMapping getRequestMapping() {
        return this.requestMapping;
    }

    @Deprecated
    public void setSupportedMethods(HttpMethod ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported method is required");
        this.requestMapping.setMethods(supportedMethods);
    }

    public void setRequestPayloadType(Class<?> requestPayloadType) {
        this.requestPayloadType = requestPayloadType;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public String getComponentType() {
        return this.expectReply ? "http:inbound-gateway" : "http:inbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        block5: {
            super.onInit();
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.multipartResolver == null && beanFactory != null) {
                try {
                    MultipartResolver multipartResolver = (MultipartResolver)beanFactory.getBean("multipartResolver", MultipartResolver.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Using MultipartResolver [" + multipartResolver + "]"));
                    }
                    this.multipartResolver = multipartResolver;
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling will be supported.");
                }
            }
        }
        if (this.messageConverters.size() == 0 || this.mergeWithDefaultConverters && !this.convertersMerged) {
            this.messageConverters.addAll(this.defaultMessageConverters);
        }
        this.validateSupportedMethods();
    }

    protected final Message<?> doHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (this.isShuttingDown()) {
            return this.createServiceUnavailableResponse();
        }
        return this.actualDoHandleRequest(servletRequest, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message<?> actualDoHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.activeCount.incrementAndGet();
        try {
            Map matrixVariables;
            Map pathVariables;
            ServletServerHttpRequest request = this.prepareRequest(servletRequest);
            Object requestBody = null;
            if (this.isReadable(request)) {
                requestBody = this.extractRequestBody(request);
            }
            HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)request.getHeaders());
            StandardEvaluationContext evaluationContext = this.createEvaluationContext();
            evaluationContext.setRootObject((Object)httpEntity);
            evaluationContext.setVariable("requestAttributes", (Object)RequestContextHolder.currentRequestAttributes());
            MultiValueMap<String, String> requestParams = this.convertParameterMap(servletRequest.getParameterMap());
            evaluationContext.setVariable("requestParams", requestParams);
            evaluationContext.setVariable("requestHeaders", (Object)new ServletServerHttpRequest(servletRequest).getHeaders());
            Object[] requestCookies = servletRequest.getCookies();
            if (!ObjectUtils.isEmpty((Object[])requestCookies)) {
                HashMap<String, Object> cookies = new HashMap<String, Object>(requestCookies.length);
                for (Object requestCookie : requestCookies) {
                    cookies.put(requestCookie.getName(), requestCookie);
                }
                evaluationContext.setVariable("cookies", cookies);
            }
            if (!CollectionUtils.isEmpty((Map)(pathVariables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapped path variables: " + pathVariables));
                }
                evaluationContext.setVariable("pathVariables", (Object)pathVariables);
            }
            if (!CollectionUtils.isEmpty((Map)(matrixVariables = (Map)servletRequest.getAttribute(HandlerMapping.class.getName() + ".matrixVariables")))) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapped matrix variables: " + matrixVariables));
                }
                evaluationContext.setVariable("matrixVariables", (Object)matrixVariables);
            }
            Map headers = this.headerMapper.toHeaders((Object)request.getHeaders());
            Object payload = null;
            if (this.payloadExpression != null) {
                payload = this.payloadExpression.getValue((EvaluationContext)evaluationContext);
            }
            if (!CollectionUtils.isEmpty(this.headerExpressions)) {
                for (String headerName : this.headerExpressions.keySet()) {
                    Expression headerExpression = this.headerExpressions.get(headerName);
                    Object headerValue = headerExpression.getValue((EvaluationContext)evaluationContext);
                    if (headerValue == null) continue;
                    headers.put(headerName, headerValue);
                }
            }
            if (payload == null) {
                payload = requestBody != null ? requestBody : requestParams;
            }
            MessageBuilder messageBuilder = null;
            messageBuilder = payload instanceof Message ? MessageBuilder.fromMessage((Message)((Message)payload)).copyHeadersIfAbsent(headers) : MessageBuilder.withPayload(payload).copyHeaders(headers);
            Message message = messageBuilder.setHeader("http_requestUrl", (Object)request.getURI().toString()).setHeader("http_requestMethod", (Object)request.getMethod().toString()).setHeader("http_userPrincipal", (Object)servletRequest.getUserPrincipal()).build();
            Message reply = null;
            if (this.expectReply) {
                reply = this.sendAndReceiveMessage(message);
            } else {
                this.send(message);
            }
            Message message2 = reply;
            return message2;
        }
        finally {
            this.postProcessRequest(servletRequest);
            this.activeCount.decrementAndGet();
        }
    }

    private Message<?> createServiceUnavailableResponse() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Endpoint is shutting down; returning status " + HttpStatus.SERVICE_UNAVAILABLE));
        }
        return MessageBuilder.withPayload((Object)"Endpoint is shutting down").setHeader("http_statusCode", (Object)HttpStatus.SERVICE_UNAVAILABLE).build();
    }

    protected final Object setupResponseAndConvertReply(ServletServerHttpResponse response, Message<?> replyMessage) {
        this.headerMapper.fromHeaders(replyMessage.getHeaders(), (Object)response.getHeaders());
        HttpStatus httpStatus = this.resolveHttpStatusFromHeaders(replyMessage.getHeaders());
        if (httpStatus != null) {
            response.setStatusCode(httpStatus);
        }
        Object reply = replyMessage;
        if (this.extractReplyPayload) {
            reply = replyMessage.getPayload();
        }
        return reply;
    }

    private ServletServerHttpRequest prepareRequest(HttpServletRequest servletRequest) {
        if (servletRequest instanceof MultipartHttpServletRequest) {
            return new MultipartHttpInputMessage((MultipartHttpServletRequest)servletRequest);
        }
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(servletRequest)) {
            return new MultipartHttpInputMessage(this.multipartResolver.resolveMultipart(servletRequest));
        }
        return new ServletServerHttpRequest(servletRequest);
    }

    private boolean isReadable(ServletServerHttpRequest request) {
        return !CollectionUtils.containsInstance(nonReadableBodyHttpMethods, (Object)request.getMethod()) && request.getHeaders().getContentType() != null;
    }

    private void postProcessRequest(HttpServletRequest request) {
        if (this.multipartResolver != null && request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    private MultiValueMap<String, String> convertParameterMap(Map<String, String[]> parameterMap) {
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            for (String value : values = entry.getValue()) {
                convertedMap.add((Object)entry.getKey(), (Object)value);
            }
        }
        return convertedMap;
    }

    private Object extractRequestBody(ServletServerHttpRequest request) throws IOException {
        MediaType contentType = request.getHeaders().getContentType();
        Class<Object> expectedType = this.requestPayloadType;
        if (expectedType == null) {
            expectedType = "text".equals(contentType.getType()) ? String.class : byte[].class;
        }
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (!converter.canRead(expectedType, contentType)) continue;
            return converter.read(expectedType, (HttpInputMessage)request);
        }
        throw new MessagingException("Could not convert request: no suitable HttpMessageConverter found for expected type [" + expectedType.getName() + "] and content type [" + contentType + "]");
    }

    private HttpStatus resolveHttpStatusFromHeaders(MessageHeaders headers) {
        Object httpStatusFromHeader = headers.get((Object)"http_statusCode");
        HttpStatus httpStatus = null;
        if (httpStatusFromHeader instanceof HttpStatus) {
            httpStatus = (HttpStatus)httpStatusFromHeader;
        } else if (httpStatusFromHeader instanceof Integer) {
            httpStatus = HttpStatus.valueOf((int)((Integer)httpStatusFromHeader));
        } else if (httpStatusFromHeader instanceof String) {
            httpStatus = HttpStatus.valueOf((int)Integer.parseInt((String)httpStatusFromHeader));
        }
        return httpStatus;
    }

    protected StandardEvaluationContext createEvaluationContext() {
        return ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    private void validateSupportedMethods() {
        if (this.requestPayloadType != null && CollectionUtils.containsAny(nonReadableBodyHttpMethods, Arrays.asList(this.requestMapping.getMethods())) && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The 'requestPayloadType' attribute will have no relevance for one of the specified HTTP methods '" + nonReadableBodyHttpMethods + "'"));
        }
    }

    protected void doStart() {
        this.shuttingDown = false;
        super.doStart();
    }

    protected boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return this.activeCount.get();
    }

    public int afterShutdown() {
        return this.activeCount.get();
    }
}

