/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.dsl;

import java.net.URI;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.http.dsl.HttpControllerEndpointSpec;
import org.springframework.integration.http.dsl.HttpMessageHandlerSpec;
import org.springframework.integration.http.dsl.HttpRequestHandlerEndpointSpec;
import org.springframework.integration.http.dsl.ReactiveHttpMessageHandlerSpec;
import org.springframework.integration.http.inbound.HttpRequestHandlingController;
import org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

public final class Http {
    public static HttpMessageHandlerSpec outboundChannelAdapter(URI uri) {
        return Http.outboundChannelAdapter(uri, null);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(String uri) {
        return Http.outboundChannelAdapter(uri, null);
    }

    public static <P> HttpMessageHandlerSpec outboundChannelAdapter(Function<Message<P>, ?> uriFunction) {
        return Http.outboundChannelAdapter((Expression)new FunctionExpression(uriFunction));
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(Expression uriExpression) {
        return Http.outboundChannelAdapter(uriExpression, null);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(URI uri, RestTemplate restTemplate) {
        return (HttpMessageHandlerSpec)((Object)new HttpMessageHandlerSpec(uri, restTemplate).expectReply(false));
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(String uri, RestTemplate restTemplate) {
        return (HttpMessageHandlerSpec)((Object)new HttpMessageHandlerSpec(uri, restTemplate).expectReply(false));
    }

    public static <P> HttpMessageHandlerSpec outboundChannelAdapter(Function<Message<P>, ?> uriFunction, RestTemplate restTemplate) {
        return Http.outboundChannelAdapter((Expression)new FunctionExpression(uriFunction), restTemplate);
    }

    public static HttpMessageHandlerSpec outboundChannelAdapter(Expression uriExpression, RestTemplate restTemplate) {
        return (HttpMessageHandlerSpec)((Object)new HttpMessageHandlerSpec(uriExpression, restTemplate).expectReply(false));
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(URI uri) {
        return Http.outboundReactiveChannelAdapter(uri, null);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(String uri) {
        return Http.outboundReactiveChannelAdapter(uri, null);
    }

    public static <P> ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(Function<Message<P>, ?> uriFunction) {
        return Http.outboundReactiveChannelAdapter((Expression)new FunctionExpression(uriFunction));
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(Expression uriExpression) {
        return Http.outboundReactiveChannelAdapter(uriExpression, null);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(URI uri, WebClient webClient) {
        return (ReactiveHttpMessageHandlerSpec)((Object)new ReactiveHttpMessageHandlerSpec(uri, webClient).expectReply(false));
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(String uri, WebClient webClient) {
        return (ReactiveHttpMessageHandlerSpec)((Object)new ReactiveHttpMessageHandlerSpec(uri, webClient).expectReply(false));
    }

    public static <P> ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(Function<Message<P>, ?> uriFunction, WebClient webClient) {
        return Http.outboundReactiveChannelAdapter((Expression)new FunctionExpression(uriFunction), webClient);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveChannelAdapter(Expression uriExpression, WebClient webClient) {
        return (ReactiveHttpMessageHandlerSpec)((Object)new ReactiveHttpMessageHandlerSpec(uriExpression, webClient).expectReply(false));
    }

    public static HttpMessageHandlerSpec outboundGateway(URI uri) {
        return Http.outboundGateway(uri, null);
    }

    public static HttpMessageHandlerSpec outboundGateway(String uri) {
        return Http.outboundGateway(uri, null);
    }

    public static <P> HttpMessageHandlerSpec outboundGateway(Function<Message<P>, ?> uriFunction) {
        return Http.outboundGateway((Expression)new FunctionExpression(uriFunction));
    }

    public static HttpMessageHandlerSpec outboundGateway(Expression uriExpression) {
        return Http.outboundGateway(uriExpression, null);
    }

    public static HttpMessageHandlerSpec outboundGateway(URI uri, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uri, restTemplate);
    }

    public static HttpMessageHandlerSpec outboundGateway(String uri, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uri, restTemplate);
    }

    public static <P> HttpMessageHandlerSpec outboundGateway(Function<Message<P>, ?> uriFunction, RestTemplate restTemplate) {
        return Http.outboundGateway((Expression)new FunctionExpression(uriFunction), restTemplate);
    }

    public static HttpMessageHandlerSpec outboundGateway(Expression uriExpression, RestTemplate restTemplate) {
        return new HttpMessageHandlerSpec(uriExpression, restTemplate);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveGateway(URI uri) {
        return Http.outboundReactiveGateway(uri, null);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveGateway(String uri) {
        return Http.outboundReactiveGateway(uri, null);
    }

    public static <P> ReactiveHttpMessageHandlerSpec outboundReactiveGateway(Function<Message<P>, ?> uriFunction) {
        return Http.outboundReactiveGateway((Expression)new FunctionExpression(uriFunction));
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveGateway(Expression uriExpression) {
        return Http.outboundReactiveGateway(uriExpression, null);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveGateway(URI uri, WebClient webClient) {
        return new ReactiveHttpMessageHandlerSpec(uri, webClient);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveGateway(String uri, WebClient webClient) {
        return new ReactiveHttpMessageHandlerSpec(uri, webClient);
    }

    public static <P> ReactiveHttpMessageHandlerSpec outboundReactiveGateway(Function<Message<P>, ?> uriFunction, WebClient webClient) {
        return Http.outboundReactiveGateway((Expression)new FunctionExpression(uriFunction), webClient);
    }

    public static ReactiveHttpMessageHandlerSpec outboundReactiveGateway(Expression uriExpression, WebClient webClient) {
        return new ReactiveHttpMessageHandlerSpec(uriExpression, webClient);
    }

    public static HttpControllerEndpointSpec inboundControllerAdapter(String viewName, String ... path) {
        Assert.isTrue((boolean)StringUtils.hasText((String)viewName), (String)"View name must not be empty");
        return Http.inboundControllerAdapter((Expression)new LiteralExpression(viewName), path);
    }

    public static HttpControllerEndpointSpec inboundControllerAdapter(Expression viewExpression, String ... path) {
        HttpRequestHandlingController controller = new HttpRequestHandlingController(false);
        controller.setViewExpression(viewExpression);
        return new HttpControllerEndpointSpec(controller, path);
    }

    public static HttpControllerEndpointSpec inboundControllerGateway(String viewName, String ... path) {
        Assert.isTrue((boolean)StringUtils.hasText((String)viewName), (String)"View name must not be empty");
        return Http.inboundControllerGateway((Expression)new LiteralExpression(viewName), path);
    }

    public static HttpControllerEndpointSpec inboundControllerGateway(Expression viewExpression, String ... path) {
        HttpRequestHandlingController controller = new HttpRequestHandlingController();
        controller.setViewExpression(viewExpression);
        return new HttpControllerEndpointSpec(controller, path);
    }

    public static HttpRequestHandlerEndpointSpec inboundChannelAdapter(String ... path) {
        HttpRequestHandlingMessagingGateway httpInboundChannelAdapter = new HttpRequestHandlingMessagingGateway(false);
        return new HttpRequestHandlerEndpointSpec(httpInboundChannelAdapter, path);
    }

    public static HttpRequestHandlerEndpointSpec inboundGateway(String ... path) {
        return new HttpRequestHandlerEndpointSpec(new HttpRequestHandlingMessagingGateway(), path);
    }

    private Http() {
    }
}

