/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.dsl;

import java.net.URI;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.dsl.BaseHttpMessageHandlerSpec;
import org.springframework.integration.http.outbound.ReactiveHttpRequestExecutingMessageHandler;
import org.springframework.web.reactive.function.client.WebClient;

public class ReactiveHttpMessageHandlerSpec
extends BaseHttpMessageHandlerSpec<ReactiveHttpMessageHandlerSpec, ReactiveHttpRequestExecutingMessageHandler> {
    private final WebClient webClient;

    ReactiveHttpMessageHandlerSpec(URI uri, WebClient webClient) {
        this((Expression)new ValueExpression((Object)uri), webClient);
    }

    ReactiveHttpMessageHandlerSpec(String uri, WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
    }

    ReactiveHttpMessageHandlerSpec(Expression uriExpression, WebClient webClient) {
        super(new ReactiveHttpRequestExecutingMessageHandler(uriExpression, webClient));
        this.webClient = webClient;
    }

    @Override
    protected boolean isClientSet() {
        return this.webClient != null;
    }
}

