/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.http.converter.MultipartAwareFormHttpMessageConverter;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.json.JacksonJsonUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerMapping;

public abstract class HttpRequestHandlingEndpointSupport
extends MessagingGatewaySupport
implements OrderlyShutdownCapable {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static final boolean romeToolsPresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.atom.Feed", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static final List<HttpMethod> nonReadableBodyHttpMethods = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS);
    private final List<HttpMessageConverter<?>> defaultMessageConverters = new ArrayList();
    private final boolean expectReply;
    private volatile List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private volatile RequestMapping requestMapping = new RequestMapping();
    private volatile CrossOrigin crossOrigin;
    private volatile Class<?> requestPayloadType = null;
    private volatile boolean convertersMerged;
    private volatile boolean mergeWithDefaultConverters = false;
    private volatile HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.inboundMapper();
    private volatile boolean extractReplyPayload = true;
    private volatile MultipartResolver multipartResolver;
    private volatile Expression payloadExpression;
    private volatile Map<String, Expression> headerExpressions;
    private volatile Expression statusCodeExpression;
    private volatile EvaluationContext evaluationContext;
    private final AtomicInteger activeCount = new AtomicInteger();

    public HttpRequestHandlingEndpointSupport() {
        this(true);
    }

    public HttpRequestHandlingEndpointSupport(boolean expectReply) {
        super(expectReply);
        this.expectReply = expectReply;
        this.defaultMessageConverters.add(new MultipartAwareFormHttpMessageConverter());
        this.defaultMessageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.defaultMessageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.defaultMessageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        SourceHttpMessageConverter sourceConverter = new SourceHttpMessageConverter();
        this.defaultMessageConverters.add((HttpMessageConverter<?>)sourceConverter);
        if (jaxb2Present) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'Jaxb2RootElementHttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        }
        if (JacksonJsonUtils.isJackson2Present()) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'MappingJackson2HttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        }
        if (romeToolsPresent) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"'AtomFeedHttpMessageConverter' was added to the 'defaultMessageConverters'.");
                this.logger.debug((Object)"'RssChannelHttpMessageConverter' was added to the 'defaultMessageConverters'.");
            }
        }
    }

    protected boolean isExpectReply() {
        return this.expectReply;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.noNullElements((Object[])messageConverters.toArray(), (String)"'messageConverters' must not contain null entries");
        ArrayList localConverters = new ArrayList(messageConverters);
        if (this.mergeWithDefaultConverters) {
            localConverters.addAll(this.defaultMessageConverters);
            this.convertersMerged = true;
        }
        this.messageConverters = localConverters;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        this.mergeWithDefaultConverters = mergeWithDefaultConverters;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setRequestMapping(RequestMapping requestMapping) {
        Assert.notNull((Object)requestMapping, (String)"requestMapping must not be null");
        this.requestMapping = requestMapping;
    }

    public final RequestMapping getRequestMapping() {
        return this.requestMapping;
    }

    public void setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
    }

    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    public void setRequestPayloadType(Class<?> requestPayloadType) {
        this.requestPayloadType = requestPayloadType;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public void setStatusCodeExpressionString(String statusCodeExpression) {
        this.setStatusCodeExpression(EXPRESSION_PARSER.parseExpression(statusCodeExpression));
    }

    public void setStatusCodeExpression(Expression statusCodeExpression) {
        this.statusCodeExpression = statusCodeExpression;
    }

    public String getComponentType() {
        return this.expectReply ? "http:inbound-gateway" : "http:inbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        block6: {
            super.onInit();
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.multipartResolver == null && beanFactory != null) {
                try {
                    MultipartResolver multipartResolver = (MultipartResolver)beanFactory.getBean("multipartResolver", MultipartResolver.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Using MultipartResolver [" + multipartResolver + "]"));
                    }
                    this.multipartResolver = multipartResolver;
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling will be supported.");
                }
            }
        }
        if (this.messageConverters.size() == 0 || this.mergeWithDefaultConverters && !this.convertersMerged) {
            this.messageConverters.addAll(this.defaultMessageConverters);
        }
        this.validateSupportedMethods();
        if (this.statusCodeExpression != null) {
            this.evaluationContext = this.createEvaluationContext();
        }
    }

    protected final Message<?> doHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (this.isRunning()) {
            return this.actualDoHandleRequest(servletRequest, servletResponse);
        }
        return this.createServiceUnavailableResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Message<?> actualDoHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.activeCount.incrementAndGet();
        try {
            Message reply;
            block21: {
                void var13_21;
                Map matrixVariables;
                Map pathVariables;
                ServletServerHttpRequest request = this.prepareRequest(servletRequest);
                Object requestBody = null;
                if (this.isReadable(request)) {
                    requestBody = this.extractRequestBody(request);
                }
                HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)request.getHeaders());
                StandardEvaluationContext evaluationContext = this.createEvaluationContext();
                evaluationContext.setRootObject((Object)httpEntity);
                evaluationContext.setVariable("requestAttributes", (Object)RequestContextHolder.currentRequestAttributes());
                MultiValueMap<String, String> requestParams = this.convertParameterMap(servletRequest.getParameterMap());
                evaluationContext.setVariable("requestParams", requestParams);
                evaluationContext.setVariable("requestHeaders", (Object)new ServletServerHttpRequest(servletRequest).getHeaders());
                Object[] requestCookies = servletRequest.getCookies();
                if (!ObjectUtils.isEmpty((Object[])requestCookies)) {
                    HashMap<String, Object> cookies = new HashMap<String, Object>(requestCookies.length);
                    for (Object object : requestCookies) {
                        cookies.put(object.getName(), object);
                    }
                    evaluationContext.setVariable("cookies", cookies);
                }
                if (!CollectionUtils.isEmpty((Map)(pathVariables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Mapped path variables: " + pathVariables));
                    }
                    evaluationContext.setVariable("pathVariables", (Object)pathVariables);
                }
                if (!CollectionUtils.isEmpty((Map)(matrixVariables = (Map)servletRequest.getAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE)))) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Mapped matrix variables: " + matrixVariables));
                    }
                    evaluationContext.setVariable("matrixVariables", (Object)matrixVariables);
                }
                Map headers = this.headerMapper.toHeaders((Object)request.getHeaders());
                Object payload = null;
                if (this.payloadExpression != null) {
                    payload = this.payloadExpression.getValue((EvaluationContext)evaluationContext);
                }
                if (!CollectionUtils.isEmpty(this.headerExpressions)) {
                    for (Map.Entry<String, Expression> entry : this.headerExpressions.entrySet()) {
                        String headerName = entry.getKey();
                        Expression headerExpression = entry.getValue();
                        Object headerValue = headerExpression.getValue((EvaluationContext)evaluationContext);
                        if (headerValue == null) continue;
                        headers.put(headerName, headerValue);
                    }
                }
                if (payload == null) {
                    payload = requestBody != null ? requestBody : requestParams;
                }
                Object var13_18 = null;
                if (payload instanceof Message) {
                    AbstractIntegrationMessageBuilder abstractIntegrationMessageBuilder = this.getMessageBuilderFactory().fromMessage((Message)payload).copyHeadersIfAbsent(headers);
                } else {
                    AbstractIntegrationMessageBuilder abstractIntegrationMessageBuilder = this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers);
                }
                Message message = var13_21.setHeader("http_requestUrl", (Object)request.getURI().toString()).setHeader("http_requestMethod", (Object)request.getMethod().toString()).setHeader("http_userPrincipal", (Object)servletRequest.getUserPrincipal()).build();
                reply = null;
                if (this.expectReply) {
                    try {
                        reply = this.sendAndReceiveMessage(message);
                    }
                    catch (MessageTimeoutException e) {
                        if (this.statusCodeExpression != null) {
                            reply = this.getMessageBuilderFactory().withPayload((Object)e.getMessage()).setHeader("http_statusCode", (Object)this.evaluateHttpStatus()).build();
                            break block21;
                        }
                        reply = this.getMessageBuilderFactory().withPayload((Object)e.getMessage()).setHeader("http_statusCode", (Object)HttpStatus.INTERNAL_SERVER_ERROR).build();
                    }
                } else {
                    this.send(message);
                }
            }
            Message message = reply;
            return message;
        }
        finally {
            this.postProcessRequest(servletRequest);
            this.activeCount.decrementAndGet();
        }
    }

    private Message<?> createServiceUnavailableResponse() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Endpoint is stopped; returning status " + HttpStatus.SERVICE_UNAVAILABLE));
        }
        return this.getMessageBuilderFactory().withPayload((Object)"Endpoint is stopped").setHeader("http_statusCode", (Object)HttpStatus.SERVICE_UNAVAILABLE).build();
    }

    protected final Object setupResponseAndConvertReply(ServletServerHttpResponse response, Message<?> replyMessage) {
        this.headerMapper.fromHeaders(replyMessage.getHeaders(), (Object)response.getHeaders());
        HttpStatus httpStatus = this.resolveHttpStatusFromHeaders(replyMessage.getHeaders());
        if (httpStatus != null) {
            response.setStatusCode(httpStatus);
        }
        Object reply = replyMessage;
        if (this.extractReplyPayload) {
            reply = replyMessage.getPayload();
        }
        return reply;
    }

    protected void setStatusCodeIfNeeded(ServletServerHttpResponse response) {
        HttpStatus httpStatus;
        if (this.statusCodeExpression != null && (httpStatus = this.evaluateHttpStatus()) != null) {
            response.setStatusCode(httpStatus);
        }
    }

    private HttpStatus evaluateHttpStatus() {
        if (this.evaluationContext == null) {
            this.evaluationContext = this.createEvaluationContext();
        }
        Object value = this.statusCodeExpression.getValue(this.evaluationContext);
        return this.buildHttpStatus(value);
    }

    private ServletServerHttpRequest prepareRequest(HttpServletRequest servletRequest) {
        if (servletRequest instanceof MultipartHttpServletRequest) {
            return new MultipartHttpInputMessage((MultipartHttpServletRequest)servletRequest);
        }
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(servletRequest)) {
            return new MultipartHttpInputMessage(this.multipartResolver.resolveMultipart(servletRequest));
        }
        return new ServletServerHttpRequest(servletRequest);
    }

    private boolean isReadable(ServletServerHttpRequest request) {
        return !CollectionUtils.containsInstance(nonReadableBodyHttpMethods, (Object)request.getMethod());
    }

    private void postProcessRequest(HttpServletRequest request) {
        if (this.multipartResolver != null && request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    private MultiValueMap<String, String> convertParameterMap(Map<String, String[]> parameterMap) {
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            for (String value : values = entry.getValue()) {
                convertedMap.add((Object)entry.getKey(), (Object)value);
            }
        }
        return convertedMap;
    }

    private Object extractRequestBody(ServletServerHttpRequest request) throws IOException {
        Class<Object> expectedType;
        MediaType contentType = request.getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        if ((expectedType = this.requestPayloadType) == null) {
            expectedType = "text".equals(contentType.getType()) ? String.class : byte[].class;
        }
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (!converter.canRead(expectedType, contentType)) continue;
            return converter.read(expectedType, (HttpInputMessage)request);
        }
        throw new MessagingException("Could not convert request: no suitable HttpMessageConverter found for expected type [" + expectedType.getName() + "] and content type [" + contentType + "]");
    }

    private HttpStatus resolveHttpStatusFromHeaders(MessageHeaders headers) {
        Object httpStatusFromHeader = headers.get((Object)"http_statusCode");
        return this.buildHttpStatus(httpStatusFromHeader);
    }

    private HttpStatus buildHttpStatus(Object httpStatusValue) {
        HttpStatus httpStatus = null;
        if (httpStatusValue instanceof HttpStatus) {
            httpStatus = (HttpStatus)httpStatusValue;
        } else if (httpStatusValue instanceof Integer) {
            httpStatus = HttpStatus.valueOf((int)((Integer)httpStatusValue));
        } else if (httpStatusValue instanceof String) {
            httpStatus = HttpStatus.valueOf((int)Integer.parseInt((String)httpStatusValue));
        }
        return httpStatus;
    }

    protected StandardEvaluationContext createEvaluationContext() {
        return ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    private void validateSupportedMethods() {
        if (this.requestPayloadType != null && CollectionUtils.containsAny(nonReadableBodyHttpMethods, Arrays.asList(this.requestMapping.getMethods())) && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The 'requestPayloadType' attribute will have no relevance for one of the specified HTTP methods '" + nonReadableBodyHttpMethods + "'"));
        }
    }

    public int beforeShutdown() {
        this.stop();
        return this.activeCount.get();
    }

    public int afterShutdown() {
        return this.activeCount.get();
    }
}

