/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.lang.reflect.Type;
import java.net.URI;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientException;
import reactor.core.publisher.Mono;

public class ReactiveHttpRequestExecutingMessageHandler
extends AbstractHttpRequestExecutingMessageHandler {
    private final WebClient webClient;

    public ReactiveHttpRequestExecutingMessageHandler(URI uri) {
        this((Expression)new ValueExpression((Object)uri));
    }

    public ReactiveHttpRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public ReactiveHttpRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public ReactiveHttpRequestExecutingMessageHandler(String uri, WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public ReactiveHttpRequestExecutingMessageHandler(Expression uriExpression, WebClient webClient) {
        super(uriExpression);
        this.webClient = webClient == null ? WebClient.create() : webClient;
        this.setAsync(true);
    }

    public String getComponentType() {
        return this.isExpectReply() ? "http:outbound-reactive-gateway" : "http:outbound-reactive-channel-adapter";
    }

    @Override
    protected Object exchange(URI uri, HttpMethod httpMethod, HttpEntity<?> httpRequest, Object expectedResponseType, Message<?> requestMessage) {
        WebClient.UriSpec uriSpec;
        switch (httpMethod) {
            case GET: {
                uriSpec = this.webClient.get();
                break;
            }
            case HEAD: {
                uriSpec = this.webClient.head();
                break;
            }
            case POST: {
                uriSpec = this.webClient.post();
                break;
            }
            case PUT: {
                uriSpec = this.webClient.put();
                break;
            }
            case PATCH: {
                uriSpec = this.webClient.patch();
                break;
            }
            case DELETE: {
                uriSpec = this.webClient.delete();
                break;
            }
            case OPTIONS: {
                uriSpec = this.webClient.options();
                break;
            }
            case TRACE: {
                throw new UnsupportedOperationException("WebClient doesn't support the TRACE HTTP method");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported HTTP method");
            }
        }
        WebClient.HeaderSpec spec = uriSpec.uri(uri).headers(httpRequest.getHeaders());
        Mono responseMono = httpRequest.hasBody() ? spec.exchange(BodyInserters.fromObject((Object)httpRequest.getBody())) : spec.exchange();
        if (this.isExpectReply()) {
            ResolvableType responseType = expectedResponseType instanceof ParameterizedTypeReference ? ResolvableType.forType((Type)((ParameterizedTypeReference)expectedResponseType).getType()) : (expectedResponseType != null ? ResolvableType.forClass((Class)((Class)expectedResponseType)) : null);
            return responseMono.map(response -> new ResponseEntity(responseType != null ? ((Mono)response.body(BodyExtractors.toMono((ResolvableType)responseType))).block() : null, (MultiValueMap)response.headers().asHttpHeaders(), response.statusCode())).map(this::getReply);
        }
        responseMono.doOnNext(response -> {
            HttpStatus httpStatus = response.statusCode();
            if (httpStatus.is4xxClientError() || httpStatus.is5xxServerError()) {
                throw new WebClientException("ClientResponse has erroneous status code: " + httpStatus.value() + " " + httpStatus.getReasonPhrase());
            }
        }).subscribe(v -> {}, ex -> this.sendErrorMessage((Message)requestMessage, (Throwable)ex));
        return null;
    }
}

