/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveHttpInboundEndpoint
extends BaseHttpInboundEndpoint
implements WebHandler {
    private static final MediaType MEDIA_TYPE_APPLICATION_ALL = new MediaType("application");
    private ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
    private RequestedContentTypeResolver requestedContentTypeResolver = new HeaderContentTypeResolver();
    private ReactiveAdapterRegistry adapterRegistry = new ReactiveAdapterRegistry();

    public ReactiveHttpInboundEndpoint() {
        this(true);
    }

    public ReactiveHttpInboundEndpoint(boolean expectReply) {
        super(expectReply);
    }

    public void setCodecConfigurer(ServerCodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"'codecConfigurer' must not be null");
        this.codecConfigurer = codecConfigurer;
    }

    public void setRequestedContentTypeResolver(RequestedContentTypeResolver requestedContentTypeResolver) {
        Assert.notNull((Object)requestedContentTypeResolver, (String)"'requestedContentTypeResolver' must not be null");
        this.requestedContentTypeResolver = requestedContentTypeResolver;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)adapterRegistry, (String)"'adapterRegistry' must not be null");
        this.adapterRegistry = adapterRegistry;
    }

    @Override
    public String getComponentType() {
        return super.getComponentType().replaceFirst("(http:)", "$1reactive-");
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return Mono.defer(() -> {
            if (this.isRunning()) {
                return this.doHandle(exchange);
            }
            return this.serviceUnavailableResponse(exchange);
        });
    }

    private Mono<Void> doHandle(ServerWebExchange exchange) {
        return this.extractRequestBody(exchange).doOnSubscribe(s -> this.activeCount.incrementAndGet()).map(body -> new HttpEntity(body, (MultiValueMap)exchange.getRequest().getHeaders())).map(entity -> this.buildMessage((HttpEntity<?>)entity, exchange)).flatMap(requestMessage -> {
            if (this.expectReply) {
                return this.sendAndReceiveMessageReactive(requestMessage).flatMap(replyMessage -> this.populateResponse(exchange, (Message<?>)replyMessage));
            }
            this.send(requestMessage);
            return this.setStatusCode(exchange);
        }).doOnTerminate((e, t) -> this.activeCount.decrementAndGet());
    }

    private <T> Mono<T> extractRequestBody(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        if (this.isReadable((HttpRequest)request)) {
            Class resolvedType;
            MediaType contentType = request.getHeaders().getContentType() == null ? MediaType.APPLICATION_OCTET_STREAM : request.getHeaders().getContentType();
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
                return exchange.getFormData();
            }
            if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
                return exchange.getMultipartData();
            }
            ResolvableType bodyType = this.getRequestPayloadType();
            if (bodyType == null) {
                bodyType = "text".equals(contentType.getType()) ? ResolvableType.forClass(String.class) : ResolvableType.forClass(byte[].class);
            }
            ReactiveAdapter adapter = (resolvedType = bodyType.resolve()) != null ? this.adapterRegistry.getAdapter(resolvedType) : null;
            ResolvableType elementType = adapter != null ? bodyType.getGeneric(new int[0]) : bodyType;
            HttpMessageReader httpMessageReader = this.codecConfigurer.getReaders().stream().filter(reader -> reader.canRead(elementType, contentType)).findFirst().orElseThrow(() -> new UnsupportedMediaTypeStatusException("Could not convert request: no suitable HttpMessageReader found for expected type [" + elementType + "] and content type [" + contentType + "]"));
            Map readHints = Collections.emptyMap();
            if (adapter != null && adapter.isMultiValue()) {
                Flux flux = httpMessageReader.read(bodyType, elementType, request, response, readHints);
                return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
            }
            Mono mono = httpMessageReader.readMono(bodyType, elementType, request, response, readHints);
            if (adapter != null) {
                return Mono.just((Object)adapter.fromPublisher((Publisher)mono));
            }
            return mono;
        }
        return Mono.just((Object)exchange.getRequest().getQueryParams());
    }

    private Message<?> buildMessage(HttpEntity<?> httpEntity, ServerWebExchange exchange) {
        Object payload;
        Map matrixVariables;
        Map pathVariables;
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders requestHeaders = request.getHeaders();
        Map exchangeAttributes = exchange.getAttributes();
        StandardEvaluationContext evaluationContext = this.createEvaluationContext();
        evaluationContext.setVariable("requestAttributes", (Object)exchangeAttributes);
        MultiValueMap requestParams = request.getQueryParams();
        evaluationContext.setVariable("requestParams", (Object)requestParams);
        evaluationContext.setVariable("requestHeaders", (Object)requestHeaders);
        if (!CollectionUtils.isEmpty((Map)request.getCookies())) {
            evaluationContext.setVariable("cookies", (Object)request.getCookies());
        }
        if (!CollectionUtils.isEmpty((Map)(pathVariables = (Map)exchangeAttributes.get(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
            evaluationContext.setVariable("pathVariables", (Object)pathVariables);
        }
        if (!CollectionUtils.isEmpty((Map)(matrixVariables = (Map)exchangeAttributes.get(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE)))) {
            evaluationContext.setVariable("matrixVariables", (Object)matrixVariables);
        }
        evaluationContext.setRootObject(httpEntity);
        if (this.getPayloadExpression() != null) {
            payload = this.getPayloadExpression().getValue((EvaluationContext)evaluationContext);
            if (payload == null) {
                throw new IllegalStateException("The payload expression '" + this.getPayloadExpression().getExpressionString() + "' returned null.");
            }
        } else {
            payload = httpEntity.getBody();
        }
        Map headers = this.getHeaderMapper().toHeaders((Object)request.getHeaders());
        if (!CollectionUtils.isEmpty(this.getHeaderExpressions())) {
            for (Map.Entry<String, Expression> entry : this.getHeaderExpressions().entrySet()) {
                String headerName = entry.getKey();
                Expression headerExpression = entry.getValue();
                Object headerValue = headerExpression.getValue((EvaluationContext)evaluationContext);
                if (headerValue == null) continue;
                headers.put(headerName, headerValue);
            }
        }
        AbstractIntegrationMessageBuilder messageBuilder = payload instanceof Message ? this.getMessageBuilderFactory().fromMessage((Message)payload).copyHeadersIfAbsent(headers) : this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers);
        return messageBuilder.setHeader("http_requestUrl", (Object)request.getURI().toString()).setHeader("http_requestMethod", (Object)request.getMethod().toString()).setHeader("http_userPrincipal", exchange.getPrincipal().block()).build();
    }

    private Mono<Void> populateResponse(ServerWebExchange exchange, Message<?> replyMessage) {
        ServerHttpResponse response = exchange.getResponse();
        this.getHeaderMapper().fromHeaders(replyMessage.getHeaders(), (Object)response.getHeaders());
        Object responseContent = replyMessage;
        if (this.getExtractReplyPayload()) {
            responseContent = replyMessage.getPayload();
        }
        if (responseContent instanceof HttpStatus) {
            response.setStatusCode((HttpStatus)responseContent);
            return response.setComplete();
        }
        HttpStatus httpStatus = this.resolveHttpStatusFromHeaders(replyMessage.getHeaders());
        if (httpStatus != null) {
            response.setStatusCode(httpStatus);
        }
        return this.writeResponseBody(exchange, responseContent);
    }

    private Mono<Void> writeResponseBody(ServerWebExchange exchange, Object body) {
        ResolvableType elementType;
        Mono publisher;
        ResolvableType bodyType = ResolvableType.forInstance((Object)body);
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(bodyType.resolve(), body);
        if (adapter != null) {
            publisher = adapter.toPublisher(body);
            ResolvableType genericType = bodyType.getGeneric(new int[]{0});
            elementType = this.getElementType(adapter, genericType);
        } else {
            publisher = Mono.justOrEmpty((Object)body);
            elementType = bodyType;
        }
        if (Void.TYPE == elementType.getRawClass() || Void.class == elementType.getRawClass()) {
            return Mono.from((Publisher)publisher);
        }
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(bodyType);
        MediaType bestMediaType = this.selectMediaType(exchange, () -> producibleMediaTypes);
        if (bestMediaType != null) {
            for (HttpMessageWriter writer : this.codecConfigurer.getWriters()) {
                if (!writer.canWrite(bodyType, bestMediaType)) continue;
                return writer.write((Publisher)publisher, elementType, bestMediaType, (ReactiveHttpOutputMessage)exchange.getResponse(), Collections.emptyMap());
            }
        } else if (producibleMediaTypes.isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No HttpMessageWriters for response type: " + bodyType));
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(producibleMediaTypes));
    }

    private ResolvableType getElementType(ReactiveAdapter adapter, ResolvableType genericType) {
        if (adapter.isNoValue()) {
            return ResolvableType.forClass(Void.class);
        }
        if (genericType != ResolvableType.NONE) {
            return genericType;
        }
        return ResolvableType.forClass(Object.class);
    }

    private List<MediaType> getProducibleMediaTypes(ResolvableType elementType) {
        return this.codecConfigurer.getWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }

    private MediaType selectMediaType(ServerWebExchange exchange, Supplier<List<MediaType>> producibleTypesSupplier) {
        List<MediaType> acceptableTypes = this.getAcceptableTypes(exchange);
        List<MediaType> producibleTypes = this.getProducibleTypes(exchange, producibleTypesSupplier);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType acceptable : acceptableTypes) {
            for (MediaType producible : producibleTypes) {
                if (!acceptable.isCompatibleWith(producible)) continue;
                compatibleMediaTypes.add(this.selectMoreSpecificMediaType(acceptable, producible));
            }
        }
        ArrayList result = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(result);
        for (MediaType mediaType : result) {
            if (mediaType.isConcrete()) {
                return mediaType;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION_ALL)) continue;
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        return null;
    }

    private List<MediaType> getAcceptableTypes(ServerWebExchange exchange) {
        List<MediaType> mediaTypes = this.requestedContentTypeResolver.resolveMediaTypes(exchange);
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private List<MediaType> getProducibleTypes(ServerWebExchange exchange, Supplier<List<MediaType>> producibleTypesSupplier) {
        Set mediaTypes = (Set)exchange.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        return mediaTypes != null ? new ArrayList(mediaTypes) : producibleTypesSupplier.get();
    }

    private MediaType selectMoreSpecificMediaType(MediaType acceptable, MediaType producible) {
        Comparator comparator = MediaType.SPECIFICITY_COMPARATOR;
        return comparator.compare(acceptable, producible = producible.copyQualityValue(acceptable)) <= 0 ? acceptable : producible;
    }

    private Mono<Void> setStatusCode(ServerWebExchange exchange) {
        HttpStatus httpStatus;
        ServerHttpResponse response = exchange.getResponse();
        if (this.getStatusCodeExpression() != null && (httpStatus = this.evaluateHttpStatus()) != null) {
            response.setStatusCode(httpStatus);
        }
        return response.setComplete();
    }

    private Mono<Void> serviceUnavailableResponse(ServerWebExchange exchange) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Endpoint is stopped; returning status " + HttpStatus.SERVICE_UNAVAILABLE));
        }
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap("Endpoint is stopped".getBytes())));
    }
}

