/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.ReactiveHttpInboundEndpoint;
import org.springframework.integration.http.support.HttpContextUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;

public class ReactiveIntegrationRequestMappingHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Method HANDLER_METHOD = ReflectionUtils.findMethod(WebHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class});
    private final AtomicBoolean initialized = new AtomicBoolean();

    protected boolean isHandler(Class<?> beanType) {
        return ReactiveHttpInboundEndpoint.class.isAssignableFrom(beanType);
    }

    protected void detectHandlerMethods(Object handler) {
        RequestMappingInfo mapping;
        if (handler instanceof String) {
            handler = this.getApplicationContext().getBean((String)handler);
        }
        if ((mapping = this.getMappingForEndpoint((ReactiveHttpInboundEndpoint)((Object)handler))) != null) {
            this.registerMapping(mapping, handler, HANDLER_METHOD);
        }
    }

    private RequestMappingInfo getMappingForEndpoint(ReactiveHttpInboundEndpoint endpoint) {
        RequestMapping requestMappingAnnotation = HttpContextUtils.convertRequestMappingToAnnotation(endpoint.getRequestMapping());
        if (requestMappingAnnotation != null) {
            return this.createRequestMappingInfo(requestMappingAnnotation, this.getCustomTypeCondition(((Object)((Object)endpoint)).getClass()));
        }
        return null;
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        CrossOrigin crossOrigin = ((BaseHttpInboundEndpoint)((Object)handler)).getCrossOrigin();
        if (crossOrigin != null) {
            CorsConfiguration config = new CorsConfiguration();
            for (String string : crossOrigin.getOrigin()) {
                config.addAllowedOrigin(string);
            }
            for (String string : crossOrigin.getMethod()) {
                config.addAllowedMethod(string.name());
            }
            for (String string : crossOrigin.getAllowedHeaders()) {
                config.addAllowedHeader(string);
            }
            for (String string : crossOrigin.getExposedHeaders()) {
                config.addExposedHeader(string);
            }
            if (crossOrigin.getAllowCredentials() != null) {
                config.setAllowCredentials(crossOrigin.getAllowCredentials());
            }
            if (crossOrigin.getMaxAge() != -1L) {
                config.setMaxAge(Long.valueOf(crossOrigin.getMaxAge()));
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
                for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                    config.addAllowedMethod(allowedMethod.name());
                }
            }
            if (CollectionUtils.isEmpty((Collection)config.getAllowedHeaders())) {
                for (NameValueExpression headerExpression : mappingInfo.getHeadersCondition().getExpressions()) {
                    if (headerExpression.isNegated()) continue;
                    config.addAllowedHeader(headerExpression.getName());
                }
            }
            return config.applyPermitDefaultValues();
        }
        return null;
    }

    public void afterPropertiesSet() {
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.initialized.getAndSet(true)) {
            super.afterPropertiesSet();
        }
    }
}

