/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientException;
import reactor.core.publisher.Mono;

public class ReactiveHttpRequestExecutingMessageHandler
extends AbstractHttpRequestExecutingMessageHandler {
    private final WebClient webClient;

    public ReactiveHttpRequestExecutingMessageHandler(URI uri) {
        this((Expression)new ValueExpression((Object)uri));
    }

    public ReactiveHttpRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public ReactiveHttpRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public ReactiveHttpRequestExecutingMessageHandler(String uri, WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public ReactiveHttpRequestExecutingMessageHandler(Expression uriExpression, WebClient webClient) {
        super(uriExpression);
        this.webClient = webClient == null ? WebClient.create() : webClient;
        this.setAsync(true);
    }

    public String getComponentType() {
        return this.isExpectReply() ? "http:outbound-reactive-gateway" : "http:outbound-reactive-channel-adapter";
    }

    @Override
    protected Object exchange(Supplier<URI> uriSupplier, HttpMethod httpMethod, HttpEntity<?> httpRequest, Object expectedResponseType, Message<?> requestMessage) {
        WebClient.RequestBodySpec requestSpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(httpMethod).uri(b -> (URI)uriSupplier.get())).headers(headers -> headers.putAll((Map)httpRequest.getHeaders()));
        if (httpRequest.hasBody()) {
            requestSpec.body(BodyInserters.fromObject((Object)httpRequest.getBody()));
        }
        Mono responseMono = requestSpec.exchange().doOnNext(response -> {
            HttpStatus httpStatus = response.statusCode();
            if (httpStatus.is4xxClientError() || httpStatus.is5xxServerError()) {
                throw new WebClientException("ClientResponse has erroneous status code: " + httpStatus.value() + " " + httpStatus.getReasonPhrase());
            }
        });
        if (this.isExpectReply()) {
            Object bodyExtractor = expectedResponseType instanceof ParameterizedTypeReference ? BodyExtractors.toMono((ParameterizedTypeReference)((ParameterizedTypeReference)expectedResponseType)) : (expectedResponseType != null ? BodyExtractors.toMono((Class)((Class)expectedResponseType)) : null);
            return responseMono.map(arg_0 -> ReactiveHttpRequestExecutingMessageHandler.lambda$exchange$3((BodyExtractor)bodyExtractor, arg_0)).map(this::getReply);
        }
        responseMono.subscribe(v -> {}, ex -> this.sendErrorMessage((Message)requestMessage, (Throwable)ex));
        return null;
    }

    private static /* synthetic */ ResponseEntity lambda$exchange$3(BodyExtractor bodyExtractor, ClientResponse response) {
        return new ResponseEntity(bodyExtractor != null ? ((Mono)response.body(bodyExtractor)).block() : null, (MultiValueMap)response.headers().asHttpHeaders(), response.statusCode());
    }
}

