/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class DefaultHttpHeaderMapper
implements HeaderMapper<HttpHeaders>,
BeanFactoryAware,
InitializingBean {
    private static final String UNUSED = "unused";
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Deprecated
    public static final String ACCEPT = "Accept";
    @Deprecated
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    @Deprecated
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    @Deprecated
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    @Deprecated
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    @Deprecated
    public static final String AGE = "Age";
    @Deprecated
    public static final String ALLOW = "Allow";
    @Deprecated
    public static final String AUTHORIZATION = "Authorization";
    @Deprecated
    public static final String CACHE_CONTROL = "Cache-Control";
    @Deprecated
    public static final String CONNECTION = "Connection";
    @Deprecated
    public static final String CONTENT_ENCODING = "Content-Encoding";
    @Deprecated
    public static final String CONTENT_LANGUAGE = "Content-Language";
    @Deprecated
    public static final String CONTENT_LENGTH = "Content-Length";
    @Deprecated
    public static final String CONTENT_LOCATION = "Content-Location";
    @Deprecated
    public static final String CONTENT_RANGE = "Content-Range";
    @Deprecated
    public static final String CONTENT_TYPE = "Content-Type";
    @Deprecated
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    @Deprecated
    public static final String COOKIE = "Cookie";
    @Deprecated
    public static final String DATE = "Date";
    @Deprecated
    public static final String ETAG = "ETag";
    @Deprecated
    public static final String EXPECT = "Expect";
    @Deprecated
    public static final String EXPIRES = "Expires";
    @Deprecated
    public static final String FROM = "From";
    @Deprecated
    public static final String HOST = "Host";
    @Deprecated
    public static final String IF_MATCH = "If-Match";
    @Deprecated
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    @Deprecated
    public static final String IF_NONE_MATCH = "If-None-Match";
    @Deprecated
    public static final String IF_RANGE = "If-Range";
    @Deprecated
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    @Deprecated
    public static final String LAST_MODIFIED = "Last-Modified";
    @Deprecated
    public static final String LOCATION = "Location";
    @Deprecated
    public static final String MAX_FORWARDS = "Max-Forwards";
    @Deprecated
    public static final String PRAGMA = "Pragma";
    @Deprecated
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    @Deprecated
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    @Deprecated
    public static final String RANGE = "Range";
    @Deprecated
    public static final String REFERER = "Referer";
    @Deprecated
    public static final String RETRY_AFTER = "Retry-After";
    @Deprecated
    public static final String SERVER = "Server";
    @Deprecated
    public static final String SET_COOKIE = "Set-Cookie";
    @Deprecated
    public static final String TE = "TE";
    @Deprecated
    public static final String TRAILER = "Trailer";
    @Deprecated
    public static final String UPGRADE = "Upgrade";
    @Deprecated
    public static final String USER_AGENT = "User-Agent";
    @Deprecated
    public static final String VARY = "Vary";
    @Deprecated
    public static final String VIA = "Via";
    @Deprecated
    public static final String WARNING = "Warning";
    @Deprecated
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    @Deprecated
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String REFRESH = "Refresh";
    private static final String ACCEPT_LOWER = "accept";
    private static final String ACCEPT_CHARSET_LOWER = "accept-charset";
    private static final String ALLOW_LOWER = "allow";
    private static final String CACHE_CONTROL_LOWER = "cache-control";
    private static final String CONTENT_LENGTH_LOWER = "content-length";
    private static final String CONTENT_TYPE_LOWER = "content-type";
    private static final String DATE_LOWER = "date";
    private static final String ETAG_LOWER = "etag";
    private static final String EXPIRES_LOWER = "expires";
    private static final String IF_MODIFIED_SINCE_LOWER = "if-modified-since";
    private static final String IF_NONE_MATCH_LOWER = "if-none-match";
    private static final String IF_UNMODIFIED_SINCE_LOWER = "if-unmodified-since";
    private static final String LAST_MODIFIED_LOWER = "last-modified";
    private static final String LOCATION_LOWER = "location";
    private static final String PRAGMA_LOWER = "pragma";
    private static final String[] HTTP_REQUEST_HEADER_NAMES = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Authorization", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Cookie", "Date", "Expect", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Pragma", "Proxy-Authorization", "Range", "Referer", "TE", "Upgrade", "User-Agent", "Via", "Warning"};
    private static final Set<String> HTTP_REQUEST_HEADER_NAMES_LOWER = new HashSet<String>();
    private static final String[] HTTP_RESPONSE_HEADER_NAMES = new String[]{"Accept-Ranges", "Age", "Allow", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Content-Disposition", "Transfer-Encoding", "Date", "ETag", "Expires", "Last-Modified", "Location", "Pragma", "Proxy-Authenticate", "Refresh", "Retry-After", "Server", "Set-Cookie", "Trailer", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final Set<String> HTTP_RESPONSE_HEADER_NAMES_LOWER = new HashSet<String>();
    private static final String[] HTTP_REQUEST_HEADER_NAMES_OUTBOUND_EXCLUSIONS = new String[0];
    private static final String[] HTTP_RESPONSE_HEADER_NAMES_INBOUND_EXCLUSIONS = new String[]{"Content-Length", "Transfer-Encoding"};
    public static final String HTTP_REQUEST_HEADER_NAME_PATTERN = "HTTP_REQUEST_HEADERS";
    public static final String HTTP_RESPONSE_HEADER_NAME_PATTERN = "HTTP_RESPONSE_HEADERS";
    protected static final DateTimeFormatter[] DATE_FORMATS = new DateTimeFormatter[]{DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss zz", Locale.US), DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy", Locale.US).withZone(ZoneId.of("GMT"))};
    private volatile String[] outboundHeaderNames = new String[0];
    private volatile String[] outboundHeaderNamesLowerWithContentType = new String[0];
    private volatile String[] inboundHeaderNames = new String[0];
    private volatile String[] inboundHeaderNamesLower = new String[0];
    private volatile String[] excludedOutboundStandardRequestHeaderNames = new String[0];
    private volatile String[] excludedInboundStandardResponseHeaderNames = new String[0];
    private volatile String userDefinedHeaderPrefix = "";
    private volatile boolean isDefaultOutboundMapper;
    private volatile boolean isDefaultInboundMapper;
    private volatile ConversionService conversionService;
    private volatile BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setOutboundHeaderNames(String ... outboundHeaderNames) {
        if (HTTP_REQUEST_HEADER_NAMES == outboundHeaderNames) {
            this.isDefaultOutboundMapper = true;
        } else if (HTTP_RESPONSE_HEADER_NAMES == outboundHeaderNames) {
            this.isDefaultInboundMapper = true;
        }
        this.outboundHeaderNames = outboundHeaderNames != null ? Arrays.copyOf(outboundHeaderNames, outboundHeaderNames.length) : new String[]{};
        String[] outboundHeaderNamesLower = new String[this.outboundHeaderNames.length];
        for (int i = 0; i < this.outboundHeaderNames.length; ++i) {
            outboundHeaderNamesLower[i] = HTTP_REQUEST_HEADER_NAME_PATTERN.equals(this.outboundHeaderNames[i]) || HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(this.outboundHeaderNames[i]) ? this.outboundHeaderNames[i] : this.outboundHeaderNames[i].toLowerCase();
        }
        this.outboundHeaderNamesLowerWithContentType = Arrays.copyOf(outboundHeaderNamesLower, this.outboundHeaderNames.length + 1);
        this.outboundHeaderNamesLowerWithContentType[this.outboundHeaderNamesLowerWithContentType.length - 1] = "contentType".toLowerCase();
    }

    public void setInboundHeaderNames(String ... inboundHeaderNames) {
        this.inboundHeaderNames = inboundHeaderNames != null ? Arrays.copyOf(inboundHeaderNames, inboundHeaderNames.length) : new String[]{};
        this.inboundHeaderNamesLower = new String[this.inboundHeaderNames.length];
        for (int i = 0; i < this.inboundHeaderNames.length; ++i) {
            this.inboundHeaderNamesLower[i] = HTTP_REQUEST_HEADER_NAME_PATTERN.equals(this.inboundHeaderNames[i]) || HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(this.inboundHeaderNames[i]) ? this.inboundHeaderNames[i] : this.inboundHeaderNames[i].toLowerCase();
        }
    }

    public void setExcludedOutboundStandardRequestHeaderNames(String ... excludedOutboundStandardRequestHeaderNames) {
        Assert.notNull((Object)excludedOutboundStandardRequestHeaderNames, (String)"'excludedOutboundStandardRequestHeaderNames' must not be null");
        Assert.noNullElements((Object[])excludedOutboundStandardRequestHeaderNames, (String)"'excludedOutboundStandardRequestHeaderNames' must not have null elements");
        this.excludedOutboundStandardRequestHeaderNames = Arrays.copyOf(excludedOutboundStandardRequestHeaderNames, excludedOutboundStandardRequestHeaderNames.length);
    }

    public void setExcludedInboundStandardResponseHeaderNames(String ... excludedInboundStandardResponseHeaderNames) {
        Assert.notNull((Object)excludedInboundStandardResponseHeaderNames, (String)"'excludedInboundStandardResponseHeaderNames' must not be null");
        Assert.noNullElements((Object[])excludedInboundStandardResponseHeaderNames, (String)"'excludedInboundStandardResponseHeaderNames' must not have null elements");
        this.excludedInboundStandardResponseHeaderNames = Arrays.copyOf(excludedInboundStandardResponseHeaderNames, excludedInboundStandardResponseHeaderNames.length);
    }

    public void setUserDefinedHeaderPrefix(String userDefinedHeaderPrefix) {
        this.userDefinedHeaderPrefix = userDefinedHeaderPrefix != null ? userDefinedHeaderPrefix : "";
    }

    public void afterPropertiesSet() {
        if (this.beanFactory != null) {
            this.conversionService = IntegrationUtils.getConversionService((BeanFactory)this.beanFactory);
        }
    }

    public void fromHeaders(MessageHeaders headers, HttpHeaders target) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("outboundHeaderNames=" + Arrays.toString(this.outboundHeaderNames)));
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            String lowerName = name.toLowerCase();
            if (value == null || !this.shouldMapOutboundHeader(lowerName)) continue;
            if (!(HTTP_REQUEST_HEADER_NAMES_LOWER.contains(lowerName) || HTTP_RESPONSE_HEADER_NAMES_LOWER.contains(lowerName) || "contentType".equalsIgnoreCase(name))) {
                String string = name = StringUtils.startsWithIgnoreCase((String)name, (String)this.userDefinedHeaderPrefix) ? name : this.userDefinedHeaderPrefix + name;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
            }
            this.setHttpHeader(target, name, value);
        }
    }

    private void setHttpHeader(HttpHeaders target, String name, Object value) {
        switch (name.toLowerCase()) {
            case "accept": {
                this.setAccept(target, value);
                break;
            }
            case "accept-charset": {
                this.setAcceptCharset(target, value);
                break;
            }
            case "allow": {
                this.setAllow(target, value);
                break;
            }
            case "cache-control": {
                this.setCacheControl(target, value);
                break;
            }
            case "content-length": {
                this.setContentLength(target, value);
                break;
            }
            case "contenttype": {
                this.setContentType(target, value);
                break;
            }
            case "date": {
                this.setDate(target, value);
                break;
            }
            case "etag": {
                this.setETag(target, value);
                break;
            }
            case "expires": {
                this.setExpires(target, value);
                break;
            }
            case "if-modified-since": {
                this.setIfModifiedSince(target, value);
                break;
            }
            case "if-unmodified-since": {
                this.setIfUnmodifiedSince(target, value);
                break;
            }
            case "if-none-match": {
                this.setIfNoneMatch(target, value);
                break;
            }
            case "last-modified": {
                this.setLastModified(target, value);
                break;
            }
            case "location": {
                this.setLocation(target, value);
                break;
            }
            case "pragma": {
                this.setPragma(target, value);
                break;
            }
            default: {
                if (value instanceof String) {
                    target.set(name, (String)value);
                    break;
                }
                if (value instanceof String[]) {
                    target.addAll(name, Arrays.asList((String[])value));
                    break;
                }
                if (value instanceof Iterable) {
                    this.setIterableHeader(target, name, value);
                    break;
                }
                this.setPlainHeader(target, name, value);
            }
        }
    }

    private void setAccept(HttpHeaders target, Object value) {
        Collection<?> valuesToAccept = this.valueToCollection(value);
        if (!CollectionUtils.isEmpty(valuesToAccept)) {
            ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
            for (Object type : valuesToAccept) {
                if (type instanceof MediaType) {
                    acceptableMediaTypes.add((MediaType)type);
                    continue;
                }
                if (type instanceof String) {
                    acceptableMediaTypes.addAll(MediaType.parseMediaTypes((String)((String)type)));
                    continue;
                }
                this.throwIllegalArgumentForUnexpectedValue("Expected MediaType or String value for 'Accept' header value, but received: ", type);
            }
            target.setAccept(acceptableMediaTypes);
        }
    }

    private void setAcceptCharset(HttpHeaders target, Object value) {
        Collection<?> valuesToConvert = this.valueToCollection(value);
        if (!CollectionUtils.isEmpty(valuesToConvert)) {
            ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
            for (Object charset : valuesToConvert) {
                if (charset instanceof Charset) {
                    acceptableCharsets.add((Charset)charset);
                    continue;
                }
                if (charset instanceof String) {
                    String[] charsets;
                    for (String charset2 : charsets = StringUtils.delimitedListToStringArray((String)((String)charset), (String)",", (String)" ")) {
                        acceptableCharsets.add(Charset.forName(charset2));
                    }
                    continue;
                }
                this.throwIllegalArgumentForUnexpectedValue("Expected Charset or String value for 'Accept-Charset' header value, but received: ", charset);
            }
            target.setAcceptCharset(acceptableCharsets);
        }
    }

    private void setAllow(HttpHeaders target, Object value) {
        Collection<?> valuesToConvert = this.valueToCollection(value);
        if (!CollectionUtils.isEmpty(valuesToConvert)) {
            HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>();
            for (Object method : valuesToConvert) {
                if (method instanceof HttpMethod) {
                    allowedMethods.add((HttpMethod)method);
                    continue;
                }
                if (method instanceof String) {
                    String[] methods;
                    for (String method2 : methods = StringUtils.delimitedListToStringArray((String)((String)method), (String)",", (String)" ")) {
                        allowedMethods.add(HttpMethod.valueOf((String)method2));
                    }
                    continue;
                }
                this.throwIllegalArgumentForUnexpectedValue("Expected HttpMethod or String value for 'Allow' header value, but received: ", method);
            }
            target.setAllow(allowedMethods);
        }
    }

    private Collection<?> valueToCollection(Object value) {
        Collection<Object> valuesToConvert = value instanceof Collection ? (Set<Object>)value : (value.getClass().isArray() ? Arrays.asList(ObjectUtils.toObjectArray((Object)value)) : Collections.singleton(value));
        return valuesToConvert;
    }

    private void setCacheControl(HttpHeaders target, Object value) {
        if (value instanceof String) {
            target.setCacheControl((String)value);
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected String value for 'Cache-Control' header value, but received: ", value);
        }
    }

    private void setContentLength(HttpHeaders target, Object value) {
        if (value instanceof Number) {
            target.setContentLength(((Number)value).longValue());
        } else if (value instanceof String) {
            target.setContentLength(Long.parseLong((String)value));
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected Number or String value for 'Content-Length' header value, but received: ", value);
        }
    }

    private void setContentType(HttpHeaders target, Object value) {
        if (value instanceof MediaType) {
            target.setContentType((MediaType)value);
        } else if (value instanceof String) {
            target.setContentType(MediaType.parseMediaType((String)((String)value)));
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected MediaType or String value for 'Content-Type' header value, but received: ", value);
        }
    }

    private void setDate(HttpHeaders target, Object value) {
        if (value instanceof Date) {
            target.setDate(((Date)value).getTime());
        } else if (value instanceof Number) {
            target.setDate(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                target.setDate(Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                target.setDate(DefaultHttpHeaderMapper.getFirstDate((String)value, DATE));
            }
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected Date, Number, or String value for 'Date' header value, but received: ", value);
        }
    }

    private void setETag(HttpHeaders target, Object value) {
        if (value instanceof String) {
            target.setETag((String)value);
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected String value for 'ETag' header value, but received: ", value);
        }
    }

    private void setExpires(HttpHeaders target, Object value) {
        if (value instanceof Date) {
            target.setExpires(((Date)value).getTime());
        } else if (value instanceof Number) {
            target.setExpires(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                target.setExpires(Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                target.setExpires(DefaultHttpHeaderMapper.getFirstDate((String)value, EXPIRES));
            }
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected Date, Number, or String value for 'Expires' header value, but received: ", value);
        }
    }

    private void setIfModifiedSince(HttpHeaders target, Object value) {
        if (value instanceof Date) {
            target.setIfModifiedSince(((Date)value).getTime());
        } else if (value instanceof Number) {
            target.setIfModifiedSince(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                target.setIfModifiedSince(Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                target.setIfModifiedSince(DefaultHttpHeaderMapper.getFirstDate((String)value, IF_MODIFIED_SINCE));
            }
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected Date, Number, or String value for 'If-Modified-Since' header value, but received: ", value);
        }
    }

    private void setIfUnmodifiedSince(HttpHeaders target, Object value) {
        if (value instanceof Date) {
            target.setIfUnmodifiedSince(((Date)value).getTime());
        } else if (value instanceof Number) {
            target.setIfUnmodifiedSince(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                target.setIfUnmodifiedSince(Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                target.setIfUnmodifiedSince(DefaultHttpHeaderMapper.getFirstDate((String)value, IF_UNMODIFIED_SINCE));
            }
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected Date, Number, or String value for 'If-Unmodified-Since' header value, but received: ", value);
        }
    }

    private void setIfNoneMatch(HttpHeaders target, Object value) {
        Collection<?> valuesToAccept = this.valueToCollection(value);
        ArrayList<String> ifNoneMatchList = new ArrayList<String>();
        for (Object match : valuesToAccept) {
            if (match instanceof String) {
                ifNoneMatchList.add((String)match);
                continue;
            }
            this.throwIllegalArgumentForUnexpectedValue("Expected String value for 'If-None-Match' header value, but received: ", value);
        }
        if (!ifNoneMatchList.isEmpty()) {
            target.setIfNoneMatch(ifNoneMatchList);
        }
    }

    private void setLastModified(HttpHeaders target, Object value) {
        if (value instanceof Date) {
            target.setLastModified(((Date)value).getTime());
        } else if (value instanceof Number) {
            target.setLastModified(((Number)value).longValue());
        } else if (value instanceof String) {
            try {
                target.setLastModified(Long.parseLong((String)value));
            }
            catch (NumberFormatException e) {
                target.setLastModified(DefaultHttpHeaderMapper.getFirstDate((String)value, LAST_MODIFIED));
            }
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected Date, Number, or String value for 'Last-Modified' header value, but received: ", value);
        }
    }

    private void setLocation(HttpHeaders target, Object value) {
        if (value instanceof URI) {
            target.setLocation((URI)value);
        } else if (value instanceof String) {
            try {
                target.setLocation(new URI((String)value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected URI or String value for 'Location' header value, but received: ", value);
        }
    }

    private void setPragma(HttpHeaders target, Object value) {
        if (value instanceof String) {
            target.setPragma((String)value);
        } else {
            this.throwIllegalArgumentForUnexpectedValue("Expected String value for 'Pragma' header value, but received: ", value);
        }
    }

    private void throwIllegalArgumentForUnexpectedValue(String message, @Nullable Object value) {
        throw new IllegalArgumentException(message + (value != null ? value.getClass() : null));
    }

    private void setIterableHeader(HttpHeaders target, String name, Object value) {
        for (Object next : (Iterable)value) {
            String convertedValue = next instanceof String ? (String)next : this.convertToString(value);
            if (StringUtils.hasText((String)convertedValue)) {
                target.add(name, convertedValue);
                continue;
            }
            this.logger.warn((Object)("Element of the header '" + name + "' with value '" + value + "' will not be set since it is not a String and no Converter is available. Consider registering a Converter with ConversionService (e.g., <int:converter>)"));
        }
    }

    private void setPlainHeader(HttpHeaders target, String name, Object value) {
        String convertedValue = this.convertToString(value);
        if (StringUtils.hasText((String)convertedValue)) {
            target.set(name, convertedValue);
        } else {
            this.logger.warn((Object)("Header '" + name + "' with value '" + value + "' will not be set since it is not a String and no Converter is available. Consider registering a Converter with ConversionService (e.g., <int:converter>)"));
        }
    }

    public Map<String, Object> toHeaders(HttpHeaders source) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("inboundHeaderNames=" + Arrays.toString(this.inboundHeaderNames)));
        }
        HashMap<String, Object> target = new HashMap<String, Object>();
        Set headerNames = source.keySet();
        for (String name : headerNames) {
            String lowerName = name.toLowerCase();
            if (!this.shouldMapInboundHeader(lowerName)) continue;
            if (!HTTP_REQUEST_HEADER_NAMES_LOWER.contains(lowerName) && !HTTP_RESPONSE_HEADER_NAMES_LOWER.contains(lowerName)) {
                this.populateUserDefinedHeader(source, target, name);
                continue;
            }
            this.populateStandardHeader(source, target, name);
        }
        return target;
    }

    private void populateUserDefinedHeader(HttpHeaders source, Map<String, Object> target, String name) {
        Object value;
        String prefixedName = StringUtils.startsWithIgnoreCase((String)name, (String)this.userDefinedHeaderPrefix) ? name : this.userDefinedHeaderPrefix + name;
        Object object = value = source.containsKey((Object)prefixedName) ? this.getHttpHeader(source, prefixedName) : this.getHttpHeader(source, name);
        if (value != null) {
            this.setMessageHeader(target, name, value);
        }
    }

    private void populateStandardHeader(HttpHeaders source, Map<String, Object> target, String name) {
        Object value = this.getHttpHeader(source, name);
        if (value != null) {
            this.setMessageHeader(target, CONTENT_TYPE.equalsIgnoreCase(name) ? "contentType" : name, value);
        }
    }

    protected Object getHttpHeader(HttpHeaders source, String name) {
        switch (name.toLowerCase()) {
            case "accept": {
                return source.getAccept();
            }
            case "accept-charset": {
                return source.getAcceptCharset();
            }
            case "allow": {
                return source.getAllow();
            }
            case "cache-control": {
                String cacheControl = source.getCacheControl();
                return StringUtils.hasText((String)cacheControl) ? cacheControl : null;
            }
            case "content-length": {
                long contentLength = source.getContentLength();
                return contentLength > -1L ? Long.valueOf(contentLength) : null;
            }
            case "content-type": {
                return source.getContentType();
            }
            case "date": {
                long date = source.getDate();
                return date > -1L ? Long.valueOf(date) : null;
            }
            case "etag": {
                String eTag = source.getETag();
                return StringUtils.hasText((String)eTag) ? eTag : null;
            }
            case "expires": {
                long expires = source.getExpires();
                return expires > -1L ? Long.valueOf(expires) : null;
            }
            case "if-none-match": {
                return source.getIfNoneMatch();
            }
            case "if-modified-since": {
                long modifiedSince = source.getIfModifiedSince();
                return modifiedSince > -1L ? Long.valueOf(modifiedSince) : null;
            }
            case "if-unmodified-since": {
                long unmodifiedSince = source.getIfUnmodifiedSince();
                return unmodifiedSince > -1L ? Long.valueOf(unmodifiedSince) : null;
            }
            case "last-modified": {
                long lastModified = source.getLastModified();
                return lastModified > -1L ? Long.valueOf(lastModified) : null;
            }
            case "location": {
                return source.getLocation();
            }
            case "pragma": {
                String pragma = source.getPragma();
                return StringUtils.hasText((String)pragma) ? pragma : null;
            }
        }
        return source.get((Object)name);
    }

    private void setMessageHeader(Map<String, Object> target, String name, Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
        }
        if (ObjectUtils.isArray((Object)value)) {
            Object[] values = ObjectUtils.toObjectArray((Object)value);
            if (!ObjectUtils.isEmpty((Object[])values)) {
                if (values.length == 1) {
                    target.put(name, values);
                } else {
                    target.put(name, values[0]);
                }
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!CollectionUtils.isEmpty((Collection)values)) {
                if (values.size() == 1) {
                    target.put(name, values.iterator().next());
                } else {
                    target.put(name, values);
                }
            }
        } else if (value != null) {
            target.put(name, value);
        }
    }

    private boolean shouldMapOutboundHeader(String headerName) {
        String[] outboundHeaderNamesLower = this.outboundHeaderNamesLowerWithContentType;
        if (this.isDefaultInboundMapper) {
            if (DefaultHttpHeaderMapper.containsElementIgnoreCase(this.excludedInboundStandardResponseHeaderNames, headerName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped (excluded)", headerName));
                }
                return false;
            }
        } else if (this.isDefaultOutboundMapper) {
            outboundHeaderNamesLower = this.outboundHeaderNamesLowerWithContentType;
            if (DefaultHttpHeaderMapper.containsElementIgnoreCase(this.excludedOutboundStandardRequestHeaderNames, headerName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped (excluded)", headerName));
                }
                return false;
            }
        }
        return this.shouldMapHeader(headerName, outboundHeaderNamesLower);
    }

    protected final boolean shouldMapInboundHeader(String headerName) {
        return this.shouldMapHeader(headerName, this.inboundHeaderNamesLower);
    }

    private boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns != null && patterns.length > 0) {
            for (String pattern : patterns) {
                if (!this.matchHeaderForPattern(headerName, pattern)) continue;
                return true;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped", headerName));
        }
        return false;
    }

    private boolean matchHeaderForPattern(String headerName, String pattern) {
        if (PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
            }
            return true;
        }
        if (HTTP_REQUEST_HEADER_NAME_PATTERN.equals(pattern) && HTTP_REQUEST_HEADER_NAMES_LOWER.contains(headerName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
            }
            return true;
        }
        if (HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(pattern) && HTTP_RESPONSE_HEADER_NAMES_LOWER.contains(headerName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected String convertToString(Object value) {
        if (this.conversionService != null && this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversionService.convert(value, String.class);
        }
        return null;
    }

    protected static boolean containsElementIgnoreCase(String[] headerNames, String name) {
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected static long getFirstDate(String headerValue, String headerName) {
        for (DateTimeFormatter dateFormatter : DATE_FORMATS) {
            try {
                return ZonedDateTime.parse(headerValue, dateFormatter).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse date value '" + headerValue + "' for '" + headerName + "' header");
    }

    public static DefaultHttpHeaderMapper outboundMapper() {
        DefaultHttpHeaderMapper mapper = new DefaultHttpHeaderMapper();
        DefaultHttpHeaderMapper.setupDefaultOutboundMapper(mapper);
        return mapper;
    }

    protected static void setupDefaultOutboundMapper(DefaultHttpHeaderMapper mapper) {
        mapper.setOutboundHeaderNames(HTTP_REQUEST_HEADER_NAMES);
        mapper.setInboundHeaderNames(HTTP_RESPONSE_HEADER_NAMES);
        mapper.setExcludedOutboundStandardRequestHeaderNames(HTTP_REQUEST_HEADER_NAMES_OUTBOUND_EXCLUSIONS);
    }

    public static DefaultHttpHeaderMapper inboundMapper() {
        DefaultHttpHeaderMapper mapper = new DefaultHttpHeaderMapper();
        DefaultHttpHeaderMapper.setupDefaultInboundMapper(mapper);
        return mapper;
    }

    protected static void setupDefaultInboundMapper(DefaultHttpHeaderMapper mapper) {
        mapper.setInboundHeaderNames(HTTP_REQUEST_HEADER_NAMES);
        mapper.setOutboundHeaderNames(HTTP_RESPONSE_HEADER_NAMES);
        mapper.setExcludedInboundStandardResponseHeaderNames(HTTP_RESPONSE_HEADER_NAMES_INBOUND_EXCLUSIONS);
    }

    static {
        for (String header : HTTP_REQUEST_HEADER_NAMES) {
            HTTP_REQUEST_HEADER_NAMES_LOWER.add(header.toLowerCase());
        }
        for (String header : HTTP_RESPONSE_HEADER_NAMES) {
            HTTP_RESPONSE_HEADER_NAMES_LOWER.add(header.toLowerCase());
        }
    }
}

