/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingMessageGroupProcessor;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.MethodInvokingMessageGroupProcessor;
import org.springframework.integration.dsl.CorrelationHandlerSpec;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.store.MessageGroup;
import org.springframework.util.Assert;

public class AggregatorSpec
extends CorrelationHandlerSpec<AggregatorSpec, AggregatingMessageHandler> {
    AggregatorSpec() {
        super(new InternalAggregatingMessageHandler());
    }

    public AggregatorSpec processor(Object target, String methodName) {
        super.processor(target);
        return this.outputProcessor((MessageGroupProcessor)(methodName != null ? new MethodInvokingMessageGroupProcessor(target, methodName) : new MethodInvokingMessageGroupProcessor(target)));
    }

    public AggregatorSpec outputExpression(String expression) {
        return this.outputProcessor((MessageGroupProcessor)new ExpressionEvaluatingMessageGroupProcessor(expression));
    }

    public AggregatorSpec outputProcessor(MessageGroupProcessor outputProcessor) {
        Assert.notNull((Object)outputProcessor);
        ((InternalAggregatingMessageHandler)((Object)((Tuple2)this.target).getT2())).getOutputProcessor().setDelegate(outputProcessor);
        return (AggregatorSpec)this._this();
    }

    public AggregatorSpec expireGroupsUponCompletion(boolean expireGroupsUponCompletion) {
        ((AggregatingMessageHandler)((Tuple2)this.target).getT2()).setExpireGroupsUponCompletion(expireGroupsUponCompletion);
        return (AggregatorSpec)this._this();
    }

    private static class MessageGroupProcessorWrapper
    implements MessageGroupProcessor,
    BeanFactoryAware {
        private MessageGroupProcessor delegate = new DefaultAggregatingMessageGroupProcessor();

        private MessageGroupProcessorWrapper() {
        }

        void setDelegate(MessageGroupProcessor delegate) {
            this.delegate = delegate;
        }

        public Object processMessageGroup(MessageGroup group) {
            return this.delegate.processMessageGroup(group);
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (this.delegate instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.delegate).setBeanFactory(beanFactory);
            }
        }
    }

    private static class InternalAggregatingMessageHandler
    extends AggregatingMessageHandler {
        InternalAggregatingMessageHandler() {
            super((MessageGroupProcessor)new MessageGroupProcessorWrapper());
        }

        protected MessageGroupProcessorWrapper getOutputProcessor() {
            return (MessageGroupProcessorWrapper)super.getOutputProcessor();
        }
    }
}

