/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.dsl.transaction.TransactionInterceptorBuilder;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.ErrorHandler;

public final class PollerSpec
extends IntegrationComponentSpec<PollerSpec, PollerMetadata>
implements ComponentsRegistration {
    private final List<Advice> adviceChain = new LinkedList<Advice>();
    private TransactionInterceptor transactionInterceptor;

    PollerSpec(Trigger trigger) {
        this.target = new PollerMetadata();
        ((PollerMetadata)this.target).setAdviceChain(this.adviceChain);
        ((PollerMetadata)this.target).setTrigger(trigger);
    }

    public PollerSpec transactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        ((PollerMetadata)this.target).setTransactionSynchronizationFactory(transactionSynchronizationFactory);
        return this;
    }

    public PollerSpec errorHandler(ErrorHandler errorHandler) {
        ((PollerMetadata)this.target).setErrorHandler(errorHandler);
        return this;
    }

    public PollerSpec maxMessagesPerPoll(long maxMessagesPerPoll) {
        ((PollerMetadata)this.target).setMaxMessagesPerPoll(maxMessagesPerPoll);
        return this;
    }

    public PollerSpec receiveTimeout(long receiveTimeout) {
        ((PollerMetadata)this.target).setReceiveTimeout(receiveTimeout);
        return this;
    }

    public PollerSpec advice(Advice ... advice) {
        this.adviceChain.addAll(Arrays.asList(advice));
        return this;
    }

    public PollerSpec transactional(PlatformTransactionManager transactionManager) {
        return this.transactional(new TransactionInterceptorBuilder().transactionManager(transactionManager).build());
    }

    public PollerSpec transactional() {
        this.transactionInterceptor = new TransactionInterceptorBuilder().build();
        return this.transactional(this.transactionInterceptor);
    }

    public PollerSpec transactional(TransactionInterceptor transactionInterceptor) {
        return this.advice(new Advice[]{transactionInterceptor});
    }

    public PollerSpec taskExecutor(Executor taskExecutor) {
        ((PollerMetadata)this.target).setTaskExecutor(taskExecutor);
        return this;
    }

    public PollerSpec sendTimeout(long sendTimeout) {
        ((PollerMetadata)this.target).setSendTimeout(sendTimeout);
        return this;
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        if (this.transactionInterceptor != null) {
            return Collections.singletonList(this.transactionInterceptor);
        }
        return null;
    }
}

