/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.kafka.Kafka09ProducerMessageHandler;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.messaging.Message;

public class Kafka09ProducerMessageHandlerSpec<K, V>
extends MessageHandlerSpec<Kafka09ProducerMessageHandlerSpec<K, V>, Kafka09ProducerMessageHandler<K, V>> {
    protected final KafkaTemplate<K, V> kafkaTemplate;

    Kafka09ProducerMessageHandlerSpec(KafkaTemplate<K, V> kafkaTemplate) {
        this.target = new Kafka09ProducerMessageHandler<K, V>(kafkaTemplate);
        this.kafkaTemplate = kafkaTemplate;
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> topic(String topic) {
        return this.topicExpression((Expression)new LiteralExpression(topic));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> topicExpression(String topicExpression) {
        return this.topicExpression(PARSER.parseExpression(topicExpression));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> topicExpression(Expression topicExpression) {
        ((Kafka09ProducerMessageHandler)((Object)this.target)).setTopicExpression(topicExpression);
        return (Kafka09ProducerMessageHandlerSpec)this._this();
    }

    public <P> Kafka09ProducerMessageHandlerSpec<K, V> topic(Function<Message<P>, String> topicFunction) {
        return this.topicExpression(new FunctionExpression<Message<P>>(topicFunction));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> messageKeyExpression(String messageKeyExpression) {
        return this.messageKeyExpression(PARSER.parseExpression(messageKeyExpression));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> messageKey(String messageKey) {
        return this.messageKeyExpression((Expression)new LiteralExpression(messageKey));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> messageKeyExpression(Expression messageKeyExpression) {
        ((Kafka09ProducerMessageHandler)((Object)this.target)).setMessageKeyExpression(messageKeyExpression);
        return (Kafka09ProducerMessageHandlerSpec)this._this();
    }

    public <P> Kafka09ProducerMessageHandlerSpec<K, V> messageKey(Function<Message<P>, ?> messageKeyFunction) {
        return this.messageKeyExpression(new FunctionExpression<Message<P>>(messageKeyFunction));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> partitionId(Integer partitionId) {
        return this.partitionIdExpression((Expression)new ValueExpression((Object)partitionId));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> partitionIdExpression(String partitionIdExpression) {
        return this.partitionIdExpression(PARSER.parseExpression(partitionIdExpression));
    }

    public <P> Kafka09ProducerMessageHandlerSpec<K, V> partitionId(Function<Message<P>, Integer> partitionIdFunction) {
        return this.partitionIdExpression(new FunctionExpression<Message<P>>(partitionIdFunction));
    }

    public Kafka09ProducerMessageHandlerSpec<K, V> partitionIdExpression(Expression partitionIdExpression) {
        ((Kafka09ProducerMessageHandler)((Object)this.target)).setPartitionIdExpression(partitionIdExpression);
        return (Kafka09ProducerMessageHandlerSpec)this._this();
    }

    public static class KafkaProducerMessageHandlerTemplateSpec<K, V>
    extends Kafka09ProducerMessageHandlerSpec<K, V>
    implements ComponentsRegistration {
        KafkaProducerMessageHandlerTemplateSpec(ProducerFactory<K, V> producerFactory) {
            super(new KafkaTemplate(producerFactory));
        }

        public KafkaProducerMessageHandlerTemplateSpec<K, V> defaultTopic(String defaultTopic) {
            this.kafkaTemplate.setDefaultTopic(defaultTopic);
            return this;
        }

        public KafkaProducerMessageHandlerTemplateSpec<K, V> producerListener(ProducerListener<K, V> producerListener) {
            this.kafkaTemplate.setProducerListener(producerListener);
            return this;
        }

        @Override
        public Collection<Object> getComponentsToRegister() {
            return Collections.singleton(this.kafkaTemplate);
        }
    }
}

