/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Order;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ConfigurableMongoDbMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
InitializingBean,
ApplicationContextAware {
    public static final String DEFAULT_COLLECTION_NAME = "configurableStoreMessages";
    public static final String SAVED_KEY = ConfigurableMongoDbMessageStore.class.getSimpleName() + ".SAVED";
    public static final String CREATED_DATE_KEY = ConfigurableMongoDbMessageStore.class.getSimpleName() + ".CREATED_DATE";
    private static final String MESSAGE_ID = "messageId";
    private static final String GROUP_ID = "groupId";
    private static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    private static final String LAST_RELEASED_SEQUENCE = "lastReleasedSequence";
    private static final String COMPLETE = "complete";
    private final String collectionName;
    private final MongoDbFactory mongoDbFactory;
    private volatile MongoTemplate mongoTemplate;
    private volatile MappingMongoConverter mappingMongoConverter;
    private ApplicationContext applicationContext;

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate) {
        this(mongoTemplate, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        Assert.notNull((Object)"'mongoTemplate' must not be null");
        Assert.hasText((String)"'collectionName' must not be empty");
        this.collectionName = collectionName;
        this.mongoTemplate = mongoTemplate;
        this.mongoDbFactory = null;
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter) {
        this(mongoDbFactory, mappingMongoConverter, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter, String collectionName) {
        Assert.notNull((Object)"'mongoDbFactory' must not be null");
        Assert.hasText((String)"'collectionName' must not be empty");
        this.collectionName = collectionName;
        this.mongoDbFactory = mongoDbFactory;
        this.mappingMongoConverter = mappingMongoConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mongoTemplate == null) {
            if (this.mappingMongoConverter == null) {
                this.mappingMongoConverter = new MappingMongoConverter(this.mongoDbFactory, (MappingContext)new MongoMappingContext());
                this.mappingMongoConverter.setApplicationContext(this.applicationContext);
                ArrayList<MongoDbMessageBytesConverter> customConverters = new ArrayList<MongoDbMessageBytesConverter>();
                customConverters.add(new MongoDbMessageBytesConverter());
                this.mappingMongoConverter.setCustomConversions(new CustomConversions(customConverters));
                this.mappingMongoConverter.afterPropertiesSet();
            }
            this.mongoTemplate = new MongoTemplate(this.mongoDbFactory, (MongoConverter)this.mappingMongoConverter);
            if (this.applicationContext != null) {
                this.mongoTemplate.setApplicationContext(this.applicationContext);
            }
        }
        IndexOperations indexOperations = this.mongoTemplate.indexOps(this.collectionName);
        indexOperations.ensureIndex((IndexDefinition)new Index(MESSAGE_ID, Order.ASCENDING));
        indexOperations.ensureIndex((IndexDefinition)new Index(GROUP_ID, Order.ASCENDING).on(LAST_MODIFIED_TIME, Order.DESCENDING));
    }

    public Message<?> getMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageDocument document = (MessageDocument)this.mongoTemplate.findOne(Query.query((Criteria)Criteria.where((String)MESSAGE_ID).is((Object)id)), MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        this.addMessageDocument(new MessageDocument(message));
        return message;
    }

    private void addMessageDocument(MessageDocument document) {
        Message<?> saved;
        Message<?> message = document.getMessage();
        if (message.getHeaders().containsKey((Object)SAVED_KEY) && (saved = this.getMessage(message.getHeaders().getId())) != null && saved.equals(message)) {
            return;
        }
        long createdDate = document.getCreatedTime() == 0L ? System.currentTimeMillis() : document.getCreatedTime();
        Message result = MessageBuilder.fromMessage(message).setHeader(SAVED_KEY, (Object)Boolean.TRUE).setHeader(CREATED_DATE_KEY, (Object)createdDate).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)result.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().get((Object)"id"));
        innerMap.put("timestamp", message.getHeaders().get((Object)"timestamp"));
        document.setCreatedTime(createdDate);
        this.mongoTemplate.insert((Object)document, this.collectionName);
    }

    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageDocument document = (MessageDocument)this.mongoTemplate.findAndRemove(Query.query((Criteria)Criteria.where((String)MESSAGE_ID).is((Object)id)), MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public long getMessageCount() {
        return this.mongoTemplate.getCollection(this.collectionName).getCount();
    }

    public int messageGroupSize(Object groupId) {
        long lCount = this.mongoTemplate.count(ConfigurableMongoDbMessageStore.groupIdQuery(groupId), this.collectionName);
        Assert.isTrue((lCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)lCount;
    }

    public MessageGroup getMessageGroup(Object groupId) {
        List messageDocuments = this.mongoTemplate.find(ConfigurableMongoDbMessageStore.groupIdQuery(groupId), MessageDocument.class, this.collectionName);
        long createdTime = 0L;
        long lastModifiedTime = 0L;
        int lastReleasedSequence = 0;
        boolean complete = false;
        if (messageDocuments.size() > 0) {
            MessageDocument document = (MessageDocument)messageDocuments.get(0);
            createdTime = document.getCreatedTime();
            lastModifiedTime = document.getLastModifiedTime();
            complete = document.isComplete();
            lastReleasedSequence = document.getLastReleasedSequence();
        }
        ArrayList messages = new ArrayList();
        for (MessageDocument document : messageDocuments) {
            messages.add(document.getMessage());
        }
        SimpleMessageGroup group = new SimpleMessageGroup(messages, groupId, createdTime, complete);
        group.setLastReleasedMessageSequenceNumber(lastReleasedSequence);
        group.setLastModified(lastModifiedTime);
        return group;
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        MessageDocument messageDocument = (MessageDocument)this.mongoTemplate.findOne(ConfigurableMongoDbMessageStore.groupIdQuery(groupId), MessageDocument.class, this.collectionName);
        long createdTime = 0L;
        int lastReleasedSequence = 0;
        boolean complete = false;
        if (messageDocument != null) {
            createdTime = messageDocument.getCreatedTime();
            lastReleasedSequence = messageDocument.getLastReleasedSequence();
            complete = messageDocument.isComplete();
        }
        MessageDocument document = new MessageDocument(message);
        document.setGroupId(groupId);
        document.setComplete(complete);
        document.setLastReleasedSequence(lastReleasedSequence);
        document.setCreatedTime(createdTime == 0L ? System.currentTimeMillis() : createdTime);
        document.setLastModifiedTime(System.currentTimeMillis());
        this.addMessageDocument(document);
        return this.getMessageGroup(groupId);
    }

    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).addCriteria(Criteria.where((String)MESSAGE_ID).is((Object)messageToRemove.getHeaders().getId()));
        this.mongoTemplate.remove(query, this.collectionName);
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
        return this.getMessageGroup(groupId);
    }

    public void removeMessageGroup(Object groupId) {
        this.mongoTemplate.remove(ConfigurableMongoDbMessageStore.groupIdQuery(groupId), this.collectionName);
    }

    public Iterator<MessageGroup> iterator() {
        HashMap messageGroupMap = new HashMap();
        Query query = Query.query((Criteria)Criteria.where((String)GROUP_ID).exists(true));
        query.fields().include(GROUP_ID);
        List groupIds = this.mongoTemplate.find(query, Map.class, this.collectionName);
        for (Map groupId : groupIds) {
            Object key = groupId.get(GROUP_ID);
            if (messageGroupMap.containsKey(key)) continue;
            messageGroupMap.put(key, this.getMessageGroup(groupId));
        }
        return messageGroupMap.values().iterator();
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(new Sort(Sort.Direction.ASC, new String[]{LAST_MODIFIED_TIME}));
        MessageDocument document = (MessageDocument)this.mongoTemplate.findAndRemove(query, MessageDocument.class, this.collectionName);
        Message<?> message = null;
        if (document != null) {
            message = document.getMessage();
            this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
        }
        return message;
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set(LAST_RELEASED_SEQUENCE, (Object)sequenceNumber));
    }

    public void completeGroup(Object groupId) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set(COMPLETE, (Object)true));
    }

    private void updateGroup(Object groupId, Update update) {
        this.mongoTemplate.updateFirst(ConfigurableMongoDbMessageStore.groupIdQuery(groupId), update, this.collectionName);
    }

    private static Update lastModifiedUpdate() {
        return Update.update((String)LAST_MODIFIED_TIME, (Object)System.currentTimeMillis());
    }

    private static Query groupIdQuery(Object groupId) {
        return Query.query((Criteria)Criteria.where((String)GROUP_ID).is(groupId));
    }

    private static class MongoDbMessageBytesConverter
    implements GenericConverter {
        private final Converter<Object, byte[]> serializingConverter = new SerializingConverter();
        private final Converter<byte[], Object> deserializingConverter = new DeserializingConverter();

        private MongoDbMessageBytesConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
            convertiblePairs.add(new GenericConverter.ConvertiblePair(Message.class, byte[].class));
            convertiblePairs.add(new GenericConverter.ConvertiblePair(byte[].class, Message.class));
            return convertiblePairs;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (Message.class.isAssignableFrom(sourceType.getObjectType())) {
                return this.serializingConverter.convert(source);
            }
            return this.deserializingConverter.convert((Object)((byte[])source));
        }
    }

    private static class MessageDocument {
        private final Message<?> message;
        private final UUID messageId;
        private volatile Long createdTime = 0L;
        private volatile Object groupId;
        private volatile Long lastModifiedTime = 0L;
        private volatile Boolean complete = false;
        private volatile Integer lastReleasedSequence = 0;

        public MessageDocument(Message<?> message) {
            Assert.notNull(message, (String)"'message' must not be null");
            this.message = message;
            this.messageId = message.getHeaders().getId();
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public void setGroupId(Object groupId) {
            this.groupId = groupId;
        }

        public Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public Long getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(long createdTime) {
            this.createdTime = createdTime;
        }

        public Boolean isComplete() {
            return this.complete;
        }

        public void setComplete(boolean complete) {
            this.complete = complete;
        }

        public Integer getLastReleasedSequence() {
            return this.lastReleasedSequence;
        }

        public void setLastReleasedSequence(int lastReleasedSequence) {
            this.lastReleasedSequence = lastReleasedSequence;
        }
    }
}

