/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class MqttParserUtils {
    private MqttParserUtils() {
        throw new AssertionError();
    }

    public static void parseCommon(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String url = element.getAttribute("url");
        if (StringUtils.hasText((String)url)) {
            builder.addConstructorArgValue((Object)url);
        }
        builder.addConstructorArgValue((Object)element.getAttribute("client-id"));
        String clientFactory = element.getAttribute("client-factory");
        if (StringUtils.hasText((String)clientFactory)) {
            builder.addConstructorArgReference(clientFactory);
        } else if (!StringUtils.hasText((String)url)) {
            parserContext.getReaderContext().error("If no 'url' attribute is provided, a 'client-factory' (with serverURIs) is required", (Object)element);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"converter");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout");
    }
}

