/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.inbound;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

@ManagedResource
public abstract class AbstractMqttMessageDrivenChannelAdapter
extends MessageProducerSupport {
    private final String url;
    private final String clientId;
    private final Set<Topic> topics;
    private volatile MqttMessageConverter converter;
    protected final Lock topicLock = new ReentrantLock();

    public AbstractMqttMessageDrivenChannelAdapter(String url, String clientId, String ... topic) {
        Assert.hasText((String)clientId, (String)"'clientId' cannot be null or empty");
        Assert.notNull((Object)topic, (String)"'topics' cannot be null");
        Assert.noNullElements((Object[])topic, (String)"'topics' cannot have null elements");
        this.url = url;
        this.clientId = clientId;
        this.topics = new LinkedHashSet<Topic>();
        for (String t : topic) {
            this.topics.add(new Topic(t, 1));
        }
    }

    public void setConverter(MqttMessageConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' cannot be null");
        this.converter = converter;
    }

    public void setQos(int ... qos) {
        Assert.notNull((Object)qos, (String)"'qos' cannot be null");
        if (qos.length == 1) {
            for (Topic topic : this.topics) {
                topic.setQos(qos[0]);
            }
        } else {
            Assert.isTrue((qos.length == this.topics.size() ? 1 : 0) != 0, (String)"When setting qos, the array must be the same length as the topics");
            int n = 0;
            for (Topic topic : this.topics) {
                topic.setQos(qos[n++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public int[] getQos() {
        this.topicLock.lock();
        try {
            int[] topicQos = new int[this.topics.size()];
            int n = 0;
            for (Topic topic : this.topics) {
                topicQos[n++] = topic.getQos();
            }
            int[] nArray = topicQos;
            return nArray;
        }
        finally {
            this.topicLock.unlock();
        }
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected MqttMessageConverter getConverter() {
        return this.converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public String[] getTopic() {
        this.topicLock.lock();
        try {
            String[] topicNames = new String[this.topics.size()];
            int n = 0;
            for (Topic topic : this.topics) {
                topicNames[n++] = topic.getTopic();
            }
            String[] stringArray = topicNames;
            return stringArray;
        }
        finally {
            this.topicLock.unlock();
        }
    }

    public String getComponentType() {
        return "mqtt:inbound-channel-adapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void addTopic(String topic, int qos) {
        this.topicLock.lock();
        try {
            Topic topik = new Topic(topic, qos);
            if (this.topics.contains(topik)) {
                throw new MessagingException("Topic '" + topic + "' is already subscribed.");
            }
            this.topics.add(topik);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added '" + topic + "' to subscriptions."));
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void addTopic(String ... topic) {
        Assert.notNull((Object)topic, (String)"'topic' cannot be null");
        this.topicLock.lock();
        try {
            for (String t : topic) {
                this.addTopic(t, 1);
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void addTopics(String[] topic, int[] qos) {
        Assert.notNull((Object)topic, (String)"'topic' cannot be null.");
        Assert.noNullElements((Object[])topic, (String)"'topic' cannot contain any null elements.");
        Assert.isTrue((topic.length == qos.length ? 1 : 0) != 0, (String)"topic and qos arrays must the be the same length.");
        this.topicLock.lock();
        try {
            for (String topik : topic) {
                if (!this.topics.contains(new Topic(topik, 0))) continue;
                throw new MessagingException("Topic '" + topik + "' is already subscribed.");
            }
            for (int i = 0; i < topic.length; ++i) {
                this.addTopic(topic[i], qos[i]);
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void removeTopic(String ... topic) {
        this.topicLock.lock();
        try {
            for (String t : topic) {
                if (!this.topics.remove(new Topic(t, 0)) || !this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Removed '" + t + "' from subscriptions."));
            }
        }
        finally {
            this.topicLock.unlock();
        }
    }

    protected void onInit() {
        super.onInit();
        if (this.converter == null) {
            this.converter = new DefaultPahoMessageConverter();
        }
    }

    private static class Topic {
        private final String topic;
        private volatile int qos;

        public Topic(String topic, int qos) {
            this.topic = topic;
            this.qos = qos;
        }

        public int getQos() {
            return this.qos;
        }

        public void setQos(int qos) {
            this.qos = qos;
        }

        public String getTopic() {
            return this.topic;
        }

        public int hashCode() {
            return this.topic.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Topic other = (Topic)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public String toString() {
            return "Topic [topic=" + this.topic + ", qos=" + this.qos + "]";
        }
    }
}

