/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class RedisPublishingMessageHandler
extends AbstractMessageHandler
implements IntegrationEvaluationContextAware {
    private final RedisTemplate<?, ?> template;
    private volatile EvaluationContext evaluationContext;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile RedisSerializer<?> serializer = new StringRedisSerializer();
    private volatile Expression topicExpression;

    public RedisPublishingMessageHandler(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.template = new RedisTemplate();
        this.template.setConnectionFactory(connectionFactory);
        this.template.setEnableDefaultSerializer(false);
        this.template.afterPropertiesSet();
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    @Deprecated
    public void setDefaultTopic(String defaultTopic) {
        Assert.hasText((String)defaultTopic, (String)"'defaultTopic' must not be an empty string.");
        this.setTopicExpression((Expression)new LiteralExpression(defaultTopic));
    }

    public void setTopic(String topic) {
        Assert.hasText((String)topic, (String)"'topic' must not be an empty string.");
        this.setTopicExpression((Expression)new LiteralExpression(topic));
    }

    public void setTopicExpression(Expression topicExpression) {
        Assert.notNull((Object)topicExpression, (String)"'topicExpression' must not be null.");
        this.topicExpression = topicExpression;
    }

    public String getComponentType() {
        return "redis:outbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        Assert.notNull((Object)this.topicExpression, (String)"'topicExpression' must not be null.");
        if (this.messageConverter instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageConverter).setBeanFactory(this.getBeanFactory());
        }
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String topic = (String)this.topicExpression.getValue(this.evaluationContext, message, String.class);
        Object value = this.messageConverter.fromMessage(message, null);
        if (value instanceof byte[]) {
            this.template.convertAndSend(topic, value);
        } else {
            this.template.convertAndSend(topic, (Object)this.serializer.serialize(value));
        }
    }
}

