/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.support.collections.RedisCollectionFactoryBean;
import org.springframework.data.redis.support.collections.RedisList;
import org.springframework.data.redis.support.collections.RedisMap;
import org.springframework.data.redis.support.collections.RedisProperties;
import org.springframework.data.redis.support.collections.RedisSet;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.data.redis.support.collections.RedisZSet;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public class RedisStoreWritingMessageHandler
extends AbstractMessageHandler {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Expression zsetIncrementScoreExpression = new SpelExpressionParser().parseExpression("headers.redis_zsetIncrementScore");
    private volatile StandardEvaluationContext evaluationContext;
    private volatile Expression keyExpression = new SpelExpressionParser().parseExpression("headers.redis_key");
    private volatile Expression mapKeyExpression = new SpelExpressionParser().parseExpression("headers.redis_mapKey");
    private volatile boolean mapKeyExpressionExplicitlySet;
    private volatile RedisTemplate<String, ?> redisTemplate = new StringRedisTemplate();
    private volatile boolean redisTemplateExplicitlySet;
    private volatile RedisCollectionFactoryBean.CollectionType collectionType = RedisCollectionFactoryBean.CollectionType.LIST;
    private volatile boolean extractPayloadElements = true;
    private volatile RedisConnectionFactory connectionFactory;
    private volatile boolean initialized;

    public RedisStoreWritingMessageHandler(RedisTemplate<String, ?> redisTemplate) {
        Assert.notNull(redisTemplate, (String)"'redisTemplate' must not be null");
        this.redisTemplate = redisTemplate;
        this.redisTemplateExplicitlySet = true;
    }

    public RedisStoreWritingMessageHandler(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.connectionFactory = connectionFactory;
    }

    public void setKey(String key) {
        Assert.hasText((String)key, (String)"key must not be empty");
        this.setKeyExpression((Expression)new LiteralExpression(key));
    }

    public void setKeyExpression(Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"keyExpression must not be null");
        this.keyExpression = keyExpression;
    }

    public void setCollectionType(RedisCollectionFactoryBean.CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public void setExtractPayloadElements(boolean extractPayloadElements) {
        this.extractPayloadElements = extractPayloadElements;
    }

    public void setMapKeyExpression(Expression mapKeyExpression) {
        Assert.notNull((Object)mapKeyExpression, (String)"'mapKeyExpression' must not be null");
        this.mapKeyExpression = mapKeyExpression;
        this.mapKeyExpressionExplicitlySet = true;
    }

    public String getComponentType() {
        return "redis:store-outbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        Assert.state((!this.mapKeyExpressionExplicitlySet || this.collectionType == RedisCollectionFactoryBean.CollectionType.MAP || this.collectionType == RedisCollectionFactoryBean.CollectionType.PROPERTIES ? 1 : 0) != 0, (String)"'mapKeyExpression' can only be set for CollectionType.MAP or CollectionType.PROPERTIES");
        if (!this.redisTemplateExplicitlySet) {
            if (!this.extractPayloadElements) {
                RedisTemplate template = new RedisTemplate();
                StringRedisSerializer serializer = new StringRedisSerializer();
                template.setKeySerializer((RedisSerializer)serializer);
                template.setHashKeySerializer((RedisSerializer)serializer);
                this.redisTemplate = template;
            }
            this.redisTemplate.setConnectionFactory(this.connectionFactory);
            this.redisTemplate.afterPropertiesSet();
        }
        this.initialized = true;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String key = (String)this.keyExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
        Assert.hasText((String)key, (String)("Failed to determine a key for the Redis store using expression: " + this.keyExpression.getExpressionString()));
        RedisStore store = this.createStoreView(key);
        Assert.state((boolean)this.initialized, (String)"handler not initialized - afterPropertiesSet() must be called before the first use");
        try {
            if (this.collectionType == RedisCollectionFactoryBean.CollectionType.ZSET) {
                this.writeToZset((RedisZSet<Object>)((RedisZSet)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.SET) {
                this.writeToSet((RedisSet<Object>)((RedisSet)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.LIST) {
                this.writeToList((RedisList<Object>)((RedisList)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.MAP) {
                this.writeToMap((RedisMap<Object, Object>)((RedisMap)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.PROPERTIES) {
                this.writeToProperties((RedisProperties)store, message);
            }
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "Failed to store Message data in Redis collection", (Throwable)e);
        }
    }

    private void writeToZset(RedisZSet<Object> zset, final Message<?> message) throws Exception {
        final Object payload = message.getPayload();
        final BoundZSetOperations ops = this.redisTemplate.boundZSetOps(zset.getKey());
        final boolean zsetIncrementHeader = this.extractZsetIncrementHeader(message);
        if (this.extractPayloadElements) {
            if (payload instanceof Map && this.verifyAllMapValuesOfTypeNumber((Map)payload)) {
                final Map payloadAsMap = (Map)payload;
                this.processInPipeline(new PipelineCallback(){

                    @Override
                    public void process() {
                        for (Map.Entry entry : payloadAsMap.entrySet()) {
                            Number d = (Number)entry.getValue();
                            RedisStoreWritingMessageHandler.this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, entry.getKey(), d == null ? RedisStoreWritingMessageHandler.this.determineScore(message) : (Double)NumberUtils.convertNumberToTargetClass((Number)d, Double.class), zsetIncrementHeader);
                        }
                    }
                });
            } else if (payload instanceof Collection) {
                this.processInPipeline(new PipelineCallback(){

                    @Override
                    public void process() {
                        for (Object object : (Collection)payload) {
                            RedisStoreWritingMessageHandler.this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, object, RedisStoreWritingMessageHandler.this.determineScore(message), zsetIncrementHeader);
                        }
                    }
                });
            } else {
                this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, payload, this.determineScore(message), zsetIncrementHeader);
            }
        } else {
            this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, payload, this.determineScore(message), zsetIncrementHeader);
        }
    }

    private boolean extractZsetIncrementHeader(Message<?> message) {
        if (message.getHeaders().containsKey((Object)"redis_zsetIncrementScore")) {
            return (Boolean)this.zsetIncrementScoreExpression.getValue((EvaluationContext)this.evaluationContext, message, Boolean.class);
        }
        return true;
    }

    private void writeToList(RedisList<Object> list, Message<?> message) {
        Object payload = message.getPayload();
        if (this.extractPayloadElements) {
            if (payload instanceof Collection) {
                list.addAll((Collection)payload);
            } else {
                list.add(payload);
            }
        } else {
            list.add(payload);
        }
    }

    private void writeToSet(RedisSet<Object> set, Message<?> message) {
        final Object payload = message.getPayload();
        if (this.extractPayloadElements && payload instanceof Collection) {
            final BoundSetOperations ops = this.redisTemplate.boundSetOps(set.getKey());
            this.processInPipeline(new PipelineCallback(){

                @Override
                public void process() {
                    for (Object object : (Collection)payload) {
                        ops.add(new Object[]{object});
                    }
                }
            });
        } else {
            set.add(payload);
        }
    }

    private void writeToMap(final RedisMap<Object, Object> map, Message<?> message) {
        final Object payload = message.getPayload();
        if (this.extractPayloadElements && payload instanceof Map) {
            this.processInPipeline(new PipelineCallback(){

                @Override
                public void process() {
                    map.putAll((Map)payload);
                }
            });
        } else {
            Object key = this.determineMapKey(message, false);
            map.put(key, payload);
        }
    }

    private void writeToProperties(final RedisProperties properties, Message<?> message) {
        final Object payload = message.getPayload();
        if (this.extractPayloadElements && payload instanceof Properties) {
            this.processInPipeline(new PipelineCallback(){

                @Override
                public void process() {
                    properties.putAll((Map)((Properties)payload));
                }
            });
        } else {
            Assert.isInstanceOf(String.class, (Object)payload, (String)"For property, payload must be a String.");
            Object key = this.determineMapKey(message, true);
            properties.put(key, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInPipeline(PipelineCallback callback) {
        RedisConnection connection = RedisConnectionUtils.bindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        try {
            connection.openPipeline();
            callback.process();
        }
        finally {
            connection.closePipeline();
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    private Object determineMapKey(Message<?> message, boolean property) {
        Object mapKey = this.mapKeyExpression.getValue((EvaluationContext)this.evaluationContext, message);
        Assert.notNull((Object)mapKey, (String)"Cannot determine a map key for the entry. The key is determined by evaluating the 'mapKeyExpression' property.");
        if (property) {
            Assert.isInstanceOf(String.class, (Object)mapKey, (String)"For property, key must be a String");
        }
        Assert.isTrue((mapKey != null ? 1 : 0) != 0, (String)"Failed to determine the key for the Redis Map entry. Payload is not a Map and 'redis_mapKey' header is not provided");
        return mapKey;
    }

    private void incrementOrOverwrite(BoundZSetOperations<String, Object> ops, Object object, Double score, boolean zsetIncrementScore) {
        if (score != null) {
            this.doIncrementOrOverwrite(ops, object, score, zsetIncrementScore);
        } else {
            this.logger.debug((Object)"Zset Score could not be determined. Using default score of 1");
            this.doIncrementOrOverwrite(ops, object, 1.0, zsetIncrementScore);
        }
    }

    private void doIncrementOrOverwrite(BoundZSetOperations<String, Object> ops, Object object, Double score, boolean increment) {
        if (increment) {
            ops.incrementScore(object, score.doubleValue());
        } else {
            ops.add(object, score.doubleValue());
        }
    }

    private boolean verifyAllMapValuesOfTypeNumber(Map<?, ?> map) {
        for (Object value : map.values()) {
            if (value instanceof Number) continue;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("failed to extract payload elements because '" + value + "' is not of type Number"));
            }
            return false;
        }
        return true;
    }

    private RedisStore createStoreView(String key) {
        RedisCollectionFactoryBean fb = new RedisCollectionFactoryBean();
        fb.setKey(key);
        fb.setTemplate(this.redisTemplate);
        fb.setType(this.collectionType);
        fb.afterPropertiesSet();
        return fb.getObject();
    }

    private double determineScore(Message<?> message) {
        Object scoreHeader = message.getHeaders().get((Object)"redis_zsetScore");
        if (scoreHeader == null) {
            return 1.0;
        }
        Assert.isInstanceOf(Number.class, (Object)scoreHeader, (String)"Header redis_zsetScore must be a Number");
        Number score = (Number)scoreHeader;
        return Double.valueOf(score.toString());
    }

    private static interface PipelineCallback {
        public void process();
    }
}

