/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.scripting.DefaultScriptVariableGenerator;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public abstract class AbstractScriptExecutingMessageProcessor<T>
implements MessageProcessor<T>,
BeanClassLoaderAware,
BeanFactoryAware {
    private final ScriptVariableGenerator scriptVariableGenerator;
    private volatile ClassLoader beanClassLoader;
    private volatile BeanFactory beanFactory;

    protected AbstractScriptExecutingMessageProcessor() {
        this.scriptVariableGenerator = new DefaultScriptVariableGenerator();
    }

    protected AbstractScriptExecutingMessageProcessor(ScriptVariableGenerator scriptVariableGenerator) {
        Assert.notNull((Object)scriptVariableGenerator, (String)"scriptVariableGenerator must not be null");
        this.scriptVariableGenerator = scriptVariableGenerator;
    }

    public final T processMessage(Message<?> message) {
        try {
            ScriptSource source = this.getScriptSource(message);
            Map<String, Object> variables = this.scriptVariableGenerator.generateScriptVariables(message);
            return this.executeScript(source, variables);
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "failed to execute script", (Throwable)e);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected abstract ScriptSource getScriptSource(Message<?> var1);

    protected abstract T executeScript(ScriptSource var1, Map<String, Object> var2) throws Exception;
}

