/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.util.CollectionUtils;

public class DefaultScriptVariableGenerator
implements ScriptVariableGenerator {
    private final Map<String, Object> variableMap;

    public DefaultScriptVariableGenerator() {
        this.variableMap = Collections.emptyMap();
    }

    public DefaultScriptVariableGenerator(Map<String, Object> variableMap) {
        this.variableMap = variableMap;
    }

    @Override
    public Map<String, Object> generateScriptVariables(Message<?> message) {
        HashMap<String, Object> scriptVariables = new HashMap<String, Object>();
        if (message != null) {
            scriptVariables.put("payload", message.getPayload());
            scriptVariables.put("headers", message.getHeaders());
        }
        if (!CollectionUtils.isEmpty(this.variableMap)) {
            for (Map.Entry<String, Object> entry : this.variableMap.entrySet()) {
                scriptVariables.put(entry.getKey(), entry.getValue());
            }
        }
        return scriptVariables;
    }
}

