/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.splitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathMessageSplitter
extends AbstractMessageSplitter {
    private final XPathExpression xpathExpression;
    private volatile boolean createDocuments;
    private volatile DocumentBuilderFactory documentBuilderFactory;
    private volatile XmlPayloadConverter xmlPayloadConverter = new DefaultXmlPayloadConverter();

    public XPathMessageSplitter(String expression) {
        this(expression, new HashMap<String, String>());
    }

    public XPathMessageSplitter(String expression, Map<String, String> namespaces) {
        this(XPathExpressionFactory.createXPathExpression((String)expression, namespaces));
    }

    public XPathMessageSplitter(XPathExpression xpathExpression) {
        this.xpathExpression = xpathExpression;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public void setCreateDocuments(boolean createDocuments) {
        this.createDocuments = createDocuments;
    }

    public String getComponentType() {
        return "xml:xpath-splitter";
    }

    public void setDocumentBuilder(DocumentBuilderFactory documentBuilderFactory) {
        Assert.notNull((Object)documentBuilderFactory, (String)"DocumentBuilderFactory must not be null");
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void setXmlPayloadConverter(XmlPayloadConverter xmlPayloadConverter) {
        Assert.notNull((Object)xmlPayloadConverter, (String)"XmlPayloadConverter must not be null");
        this.xmlPayloadConverter = xmlPayloadConverter;
    }

    protected Object splitMessage(Message<?> message) {
        try {
            Object payload = message.getPayload();
            Object result = null;
            if (payload instanceof Node) {
                result = this.splitNode((Node)payload);
            } else {
                Document document = this.xmlPayloadConverter.convertToDocument(payload);
                Assert.notNull((Object)document, (String)("unsupported payload type [" + payload.getClass().getName() + "]"));
                result = this.splitDocument(document);
            }
            return result;
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException(message, "failed to create DocumentBuilder", (Throwable)e);
        }
        catch (Exception e) {
            throw new MessagingException(message, "failed to split Message payload", (Throwable)e);
        }
    }

    private Object splitDocument(Document document) throws Exception {
        List<Node> nodes = this.splitNode(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ArrayList<String> splitStrings = new ArrayList<String>(nodes.size());
        for (Node nodeFromList : nodes) {
            StringResult result = new StringResult();
            transformer.transform(new DOMSource(nodeFromList), (Result)result);
            splitStrings.add(result.toString());
        }
        return splitStrings;
    }

    private List<Node> splitNode(Node node) throws ParserConfigurationException {
        List nodeList = this.xpathExpression.evaluateAsNodeList(node);
        if (nodeList.size() == 0) {
            throw new IllegalArgumentException("failed to split message with XPath expression: " + this.xpathExpression);
        }
        if (this.createDocuments) {
            return this.convertNodesToDocuments(nodeList);
        }
        return nodeList;
    }

    private List<Node> convertNodesToDocuments(List<Node> nodes) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getNewDocumentBuilder();
        ArrayList<Node> documents = new ArrayList<Node>(nodes.size());
        for (Node node : nodes) {
            Document document = documentBuilder.newDocument();
            document.appendChild(document.importNode(node, true));
            documents.add(document);
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
    }
}

