/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.util.BeanFactoryTypeConverter;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.integration.xml.xpath.XPathEvaluationType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Node;

public class XPathExpressionEvaluatingHeaderValueMessageProcessor
implements HeaderValueMessageProcessor<Object>,
BeanFactoryAware {
    private static final XmlPayloadConverter converter = new DefaultXmlPayloadConverter();
    private final BeanFactoryTypeConverter typeConverter = new BeanFactoryTypeConverter();
    private final XPathExpression expression;
    private volatile XPathEvaluationType evaluationType = XPathEvaluationType.STRING_RESULT;
    private volatile TypeDescriptor headerTypeDescriptor;
    private volatile Boolean overwrite = null;

    public XPathExpressionEvaluatingHeaderValueMessageProcessor(String expression) {
        Assert.hasText((String)expression, (String)"expression must have text");
        this.expression = XPathExpressionFactory.createXPathExpression((String)expression);
    }

    public XPathExpressionEvaluatingHeaderValueMessageProcessor(XPathExpression expression) {
        Assert.notNull((Object)expression, (String)"expression must not be null");
        this.expression = expression;
    }

    public void setEvaluationType(XPathEvaluationType evaluationType) {
        this.evaluationType = evaluationType;
    }

    public void setHeaderType(Class<?> headerType) {
        if (headerType != null) {
            this.headerTypeDescriptor = TypeDescriptor.valueOf(headerType);
        }
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Boolean isOverwrite() {
        return this.overwrite;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ConversionService conversionService = IntegrationUtils.getConversionService((BeanFactory)beanFactory);
        if (conversionService != null) {
            this.typeConverter.setConversionService(conversionService);
        }
    }

    public Object processMessage(Message<?> message) {
        Node node = converter.convertToNode(message.getPayload());
        Object result = this.evaluationType.evaluateXPath(this.expression, node);
        if (result instanceof String && ((String)result).length() == 0) {
            result = null;
        }
        if (result != null && this.headerTypeDescriptor != null) {
            return this.typeConverter.convertValue(result, TypeDescriptor.forObject((Object)result), this.headerTypeDescriptor);
        }
        return result;
    }
}

