/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.integration.xml.source.DomSourceFactory;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public class UnmarshallingTransformer
extends AbstractPayloadTransformer<Object, Object> {
    private final Unmarshaller unmarshaller;
    private volatile SourceFactory sourceFactory = new DomSourceFactory();
    private volatile boolean alwaysUseSourceFactory = false;

    public UnmarshallingTransformer(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        Assert.notNull((Object)sourceFactory, (String)"sourceFactory must not be null");
        this.sourceFactory = sourceFactory;
    }

    public void setAlwaysUseSourceFactory(boolean alwaysUseSourceFactory) {
        this.alwaysUseSourceFactory = alwaysUseSourceFactory;
    }

    public String getComponentType() {
        return "xml:unmarshalling-transformer";
    }

    public Object transformPayload(Object payload) {
        Object source = null;
        source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(payload) : (payload instanceof String ? new StringSource((String)payload) : (payload instanceof File ? new StreamSource((File)payload) : (payload instanceof Document ? new DOMSource((Document)payload) : (payload instanceof Source ? (Source)payload : this.sourceFactory.createSource(payload)))));
        if (source == null) {
            throw new MessagingException("failed to transform message, payload not assignable from javax.xml.transform.Source and no conversion possible");
        }
        try {
            return this.unmarshaller.unmarshal((Source)source);
        }
        catch (IOException e) {
            throw new MessagingException("failed to unmarshal payload", (Throwable)e);
        }
    }
}

